/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.IJSFunction;
import com.ibm.jdojo.lang.ScopeVariable;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.JSRegExp;
import com.ibm.jdojo.util.JSSet;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition;
import com.ibm.team.apt.shared.ui.internal.quickqueries.ParameterProposalBuilder;
import com.ibm.team.apt.shared.ui.internal.quickqueries.ProposalMatcher;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryDefinition;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryProposal;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil;
import com.ibm.team.apt.shared.ui.internal.quickqueries.Term;
import com.ibm.team.apt.shared.ui.internal.quickqueries._CharSequenceIterator;

public class QuickQueryParser
extends DojoObject {
    private IInstantAttributeListener fSampleCallback;
    public static final JSRegExp RELATIVE_DATE_REGEX = new JSRegExp("^[<|>]?(today([+-][0-9]+)?$)", "g");
    public static final JSRegExp ABSOLUTE_DATE_REGEX = new JSRegExp("^[<|>]?(19|20)[0-9]{2}-(0[1-9]|1[0-2])-(0[1-9]|[12][0-9]|3[01])$", "g");
    public static final String ERROR_MESSAGE_SAMPLE = " 2013-10-21; <2013-10-21; today-1; >today+1";
    public static final String SAMPLE_DATE_EXPRESSION_TEXT_2 = " &lt;2013-10-21; &lt;today+1";
    public static final String SAMPLE_DATE_EXPRESSION_TEXT_3 = " &gt;2013-10-21; &gt;today+1";
    public static final String SAMPLE_DATE_EXPRESSION_TEXT_4 = " :2013-10-21; :today-1;";
    private boolean fIsErrorFlow;
    private QuickQueryDefinition fQuickQueryDefinition = null;
    public static JSSet whitespaceMap = QuickQueryParser.__buildCharMap(" \f\n\r\t", null);
    public static JSSet stopCharacterMap = QuickQueryParser.__buildCharMap(":~=<>\"", whitespaceMap);
    public static JSRegExp IDENTIFIER = new JSRegExp("[a-zA-Z_][\\w]*");

    public QuickQueryParser(QuickQueryDefinition quickQueryDefinition) {
        this.fQuickQueryDefinition = quickQueryDefinition;
    }

    public IQuickQueryCondition getExpression(String input) {
        return this.getExpressionForExclusion(input, false);
    }

    public IQuickQueryCondition getExpressionForExclusion(String input, boolean isExclusion) {
        String[] keys;
        Term result = new Term(Term.Operator.AND, new IQuickQueryCondition[0]);
        boolean hasExpressions = false;
        ParsedCommon[] parsed = this.doParse(input);
        JSMap expressionByAttribute = new JSMap();
        int i = 0;
        while (i < parsed.length) {
            IQuickQueryCondition expression;
            ParsedCommon element = parsed[i];
            if (element instanceof ParsedKeyword) {
                expression = this.fQuickQueryDefinition.getWordExpression(((ParsedKeyword)element).keyword);
                result.add(((ParsedKeyword)element).negate ? new Term(Term.Operator.NOT, expression) : expression);
                hasExpressions = true;
            } else if (element instanceof ParsedAttribute && (expression = this.fQuickQueryDefinition.getAttributeExpression(((ParsedAttribute)element).attribute, ((ParsedAttribute)element).operator, ((ParsedAttribute)element).parameterKey, ((ParsedAttribute)element).parameterValue)) != null) {
                JSArray expressions;
                if (((ParsedAttribute)element).negate) {
                    expression = new Term(Term.Operator.NOT, expression);
                }
                if ((expressions = (JSArray)expressionByAttribute.get(((ParsedAttribute)element).attribute)) == null) {
                    expressions = new JSArray();
                    expressionByAttribute.put(((ParsedAttribute)element).attribute, (Object)expressions);
                }
                expressions.push((Object)expression);
            }
            ++i;
        }
        String[] stringArray = keys = expressionByAttribute.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeId = stringArray[n2];
            JSArray expressions = (JSArray)expressionByAttribute.get(attributeId);
            Term expressionRoot = result;
            if (this.fQuickQueryDefinition.getAttributeCombinationForExclusion(attributeId, isExclusion) == Term.Operator.OR && expressions.length > 1) {
                expressionRoot = new Term(Term.Operator.OR, new IQuickQueryCondition[0]);
                result.add(expressionRoot);
            }
            IQuickQueryCondition[] iQuickQueryConditionArray = (IQuickQueryCondition[])expressions.toArray();
            int n3 = iQuickQueryConditionArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IQuickQueryCondition expression = iQuickQueryConditionArray[n4];
                expressionRoot.add(expression);
                ++n4;
            }
            hasExpressions = true;
            ++n2;
        }
        return hasExpressions ? result : null;
    }

    public String evaluateExpression(String input) {
        this.fIsErrorFlow = true;
        ParsedCommon[] parsed = this.doParse(input);
        this.fIsErrorFlow = false;
        int i = 0;
        while (i < parsed.length) {
            IPlanningAttribute<?> attribute;
            ParsedCommon element = parsed[i];
            if (element instanceof ParsedAttribute && (attribute = this.fQuickQueryDefinition.getAttribute(((ParsedAttribute)element).attribute)) != null) {
                switch (attribute.getDescription().getAttributeType()) {
                    case INSTANT: {
                        String value = this.validateDateExpressions(((ParsedAttribute)element).parameterValue);
                        if (value == null) break;
                        return value;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private boolean isLessThanExpression(String expression) {
        return expression.indexOf(60) >= 0;
    }

    private boolean isGreaterThanExpression(String expression) {
        return expression.indexOf(62) >= 0;
    }

    public String validateDateExpressions(String expression) {
        if (expression != null && expression.length() > 0) {
            String[] validationTokens = JSStrings.match((String)expression, (JSRegExp)RELATIVE_DATE_REGEX);
            String[] stringArray = validationTokens = validationTokens == null ? JSStrings.match((String)expression, (JSRegExp)ABSOLUTE_DATE_REGEX) : validationTokens;
            if (validationTokens == null) {
                return "Use a valid format for the date expression.<br />(Examples: 2013-10-21; <2013-10-21; today-1; >today+1)";
            }
        }
        return null;
    }

    public QuickQueryProposal[] getContentProposals(final String input, final int position) {
        ParsedCommon[] parsed = this.doParse(input);
        final ScopeVariable currentPredicate = new ScopeVariable(null);
        int i = 0;
        while (i < parsed.length) {
            ParsedCommon element = parsed[i];
            if (element.start < position && element.end >= position) {
                currentPredicate.value = element;
                break;
            }
            ++i;
        }
        final JSArray result = new JSArray();
        if (currentPredicate.value != null) {
            int attributeStart = ((ParsedCommon)((Object)currentPredicate.value)).start;
            int attributeEnd = ((ParsedCommon)((Object)currentPredicate.value)).end;
            if (currentPredicate.value instanceof ParsedAttribute) {
                attributeStart = ((ParsedAttribute)((Object)currentPredicate.value)).attributeStart;
                attributeEnd = ((ParsedAttribute)((Object)currentPredicate.value)).attributeEnd;
            }
            if (position <= attributeEnd) {
                final ProposalMatcher attributeMatcher = new ProposalMatcher(input.substring(attributeStart, position));
                this.withQueryableAttributes(new IQueryableAttributeRunnable(){

                    @Override
                    public void run(IPlanningAttribute<?> attribute) {
                        String[] candidates;
                        if (attributeMatcher.matches(QuickQueryUtil.getLabel(attribute))) {
                            QuickQueryProposal proposal = new QuickQueryProposal(attribute, null, null, ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, true);
                            result.push((Object)proposal);
                            if (attribute.getDescription().getAttributeType() == PlanningAttributeType.INSTANT) {
                                result.push((Object)new QuickQueryProposal(attribute, "<", null, ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, true));
                                result.push((Object)new QuickQueryProposal(attribute, ">", null, ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, true));
                            }
                        }
                        String[] stringArray = candidates = new ParameterProposalBuilder().getProposals(attribute);
                        int n = candidates.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String candidate = stringArray[n2];
                            if (attributeMatcher.matches(String.valueOf(candidate))) {
                                QuickQueryProposal proposal = new QuickQueryProposal(attribute, null, String.valueOf(candidate), ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, false);
                                result.push((Object)proposal);
                            }
                            ++n2;
                        }
                    }
                });
            } else if (currentPredicate.value instanceof ParsedAttribute) {
                final ParsedAttribute parsedAttribute = (ParsedAttribute)((Object)currentPredicate.value);
                this.withQueryableAttributes(new IQueryableAttributeRunnable(){

                    @Override
                    public void run(IPlanningAttribute<?> attribute) {
                        if (QuickQueryUtil.getLabel(attribute) == parsedAttribute.attribute) {
                            String[] candidates = new ParameterProposalBuilder().getProposals(attribute);
                            String prefix = null;
                            if (position > parsedAttribute.parameterStart) {
                                prefix = input.substring(parsedAttribute.parameterStart, position);
                            }
                            ProposalMatcher matcher = new ProposalMatcher(prefix);
                            String[] stringArray = candidates;
                            int n = candidates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String candiate = stringArray[n2];
                                if (matcher.matches(String.valueOf(candiate))) {
                                    QuickQueryProposal proposal = QuickQueryParser.this.isLessThanExpression(input) ? new QuickQueryProposal(attribute, "<", String.valueOf(candiate), ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, false) : (QuickQueryParser.this.isGreaterThanExpression(input) ? new QuickQueryProposal(attribute, ">", String.valueOf(candiate), ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, false) : new QuickQueryProposal(attribute, null, String.valueOf(candiate), ((ParsedCommon)((Object)currentPredicate.value)).start, ((ParsedCommon)((Object)currentPredicate.value)).end, false));
                                    result.push((Object)proposal);
                                }
                                ++n2;
                            }
                        }
                    }
                });
            }
        } else {
            this.withQueryableAttributes(new IQueryableAttributeRunnable(){

                @Override
                public void run(IPlanningAttribute<?> attribute) {
                    QuickQueryProposal proposal = new QuickQueryProposal(attribute, null, null, position, position, false);
                    result.push((Object)proposal);
                }
            });
        }
        result.sort((JSArray.IComparator)new JSArray.IComparator<QuickQueryProposal>(){

            public int compare(QuickQueryProposal left, QuickQueryProposal right) {
                return left.compareTo(right);
            }
        });
        return (QuickQueryProposal[])result.toArray();
    }

    private void withQueryableAttributes(IQueryableAttributeRunnable code) {
        IPlanningAttribute<?>[] iPlanningAttributeArray = this.fQuickQueryDefinition.getAllAttributes();
        int n = iPlanningAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanningAttribute<?> attribute = iPlanningAttributeArray[n2];
            if (QuickQueryUtil.getLabel(attribute) != null) {
                code.run(attribute);
            }
            ++n2;
        }
    }

    public void setSampleCallback(IInstantAttributeListener sampleCallback) {
        this.fSampleCallback = sampleCallback;
    }

    private static JSSet __buildCharMap(String characters, JSSet baseMap) {
        JSSet result = baseMap != null ? new JSSet(baseMap) : new JSSet();
        int i = 0;
        while (i < characters.length()) {
            result.add(String.valueOf(characters.charAt(i)));
            ++i;
        }
        return result;
    }

    public static boolean skipWhitespace(_CharSequenceIterator chars) {
        boolean result = false;
        while (chars.hasNext()) {
            if (!whitespaceMap.contains(String.valueOf(chars.next()))) {
                chars.pushback();
                break;
            }
            result = true;
        }
        return result;
    }

    public static String parseWord(_CharSequenceIterator chars) {
        int start = chars.getIndex();
        while (chars.hasNext()) {
            if (!stopCharacterMap.contains(String.valueOf(chars.next()))) continue;
            chars.pushback();
            break;
        }
        return start != chars.getIndex() ? chars.substring(start, -1) : null;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] parseParameter(_CharSequenceIterator chars) {
        block6: {
            block7: {
                if (!chars.hasNext()) {
                    return null;
                }
                start = chars.getIndex();
                first = chars.next();
                if (!chars.hasNext()) break block6;
                key = null;
                value = null;
                second = chars.next();
                if (first != '$' || second != '{') break block7;
                valueStart = start;
                while (chars.hasNext()) {
                    next = chars.next();
                    if (next == ':') {
                        key = chars.substring(start + 2, chars.getIndex() - 1);
                        valueStart = chars.getIndex();
                        break;
                    }
                    if (QuickQueryParser.whitespaceMap.contains(String.valueOf(next))) break;
                }
                if (key != null) ** GOTO lbl27
                chars.reset(start);
                return null;
lbl-1000:
                // 1 sources

                {
                    next = chars.next();
                    if (next == '}') {
                        value = chars.substring(valueStart, chars.getIndex() - 1);
                        break;
                    }
                    if (QuickQueryParser.whitespaceMap.contains(String.valueOf(next))) break;
lbl27:
                    // 2 sources

                    ** while (chars.hasNext())
                }
lbl28:
                // 3 sources

                if (value == null) {
                    chars.reset(start);
                    return null;
                }
                return new String[]{key, value};
            }
            chars.reset(start);
            return QuickQueryParser.parseLabelParameter(chars);
        }
        chars.reset(start);
        return QuickQueryParser.parseLabelParameter(chars);
    }

    private static String[] parseLabelParameter(_CharSequenceIterator chars) {
        String[] stringArray;
        int start = chars.getIndex();
        while (chars.hasNext()) {
            if (!whitespaceMap.contains(String.valueOf(chars.next()))) continue;
            chars.pushback();
            break;
        }
        if (start != chars.getIndex()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "label";
            stringArray = stringArray2;
            stringArray2[1] = chars.substring(start, -1);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public static String parseString(_CharSequenceIterator chars) {
        if (!chars.hasNext()) {
            return null;
        }
        char c = chars.next();
        if (c != '\"') {
            chars.pushback();
            return null;
        }
        String result = "";
        boolean foundEnd = false;
        while (chars.hasNext()) {
            c = chars.next();
            if (c == '\"') {
                foundEnd = true;
                break;
            }
            if (c == '\\') {
                if (!chars.hasNext()) {
                    return null;
                }
                switch (chars.next()) {
                    case '\\': {
                        result = String.valueOf(result) + '\\';
                        break;
                    }
                    case '\"': {
                        result = String.valueOf(result) + '\"';
                        break;
                    }
                    case '\'': {
                        result = String.valueOf(result) + '\'';
                        break;
                    }
                    case 'r': {
                        result = String.valueOf(result) + '\r';
                        break;
                    }
                    case 'n': {
                        result = String.valueOf(result) + '\n';
                        break;
                    }
                    case 't': {
                        result = String.valueOf(result) + '\t';
                    }
                }
                continue;
            }
            result = String.valueOf(result) + c;
        }
        return foundEnd ? result : null;
    }

    public ParsedCommon[] doParse(String input) {
        JSArray result = new JSArray();
        _CharSequenceIterator chars = new _CharSequenceIterator(input);
        boolean negate = false;
        int posElementStart = -1;
        int maxLoops = input.length();
        while (chars.hasNext()) {
            char c;
            if (maxLoops-- == 0) break;
            if (QuickQueryParser.skipWhitespace(chars)) continue;
            if (posElementStart == -1) {
                posElementStart = chars.getIndex();
            }
            if ((c = chars.next()) == '!' || c == '-' || c == '+') {
                negate = c == '-' || c == '!';
                continue;
            }
            chars.pushback();
            boolean foundOperation = false;
            int posOperationNameStart = chars.getIndex();
            String keyword = QuickQueryParser.parseWord(chars);
            if (keyword != null && chars.hasNext()) {
                int posOperationNameEnd = chars.getIndex();
                Operators operator = null;
                String operatorChar = String.valueOf(chars.next());
                Operators[] operatorsArray = Operators.values();
                int n = operatorsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Operators candidateOperator = operatorsArray[n2];
                    if (candidateOperator.fToken == operatorChar) {
                        if (operatorChar.equals(Operators.Default.fToken) && chars.hasNext()) {
                            if (input.indexOf(":<") > 0) {
                                operator = Operators.Lt;
                                break;
                            }
                            if (input.indexOf(":>") > 0) {
                                operator = Operators.Gt;
                                break;
                            }
                            operator = Operators.Default;
                            break;
                        }
                        operator = candidateOperator;
                        break;
                    }
                    ++n2;
                }
                if (operator != null) {
                    int posAfterColon = chars.getIndex();
                    String parameterKey = "label";
                    String parameterValue = QuickQueryParser.parseString(chars);
                    if (parameterValue == null) {
                        chars.reset(posAfterColon);
                        String[] tuple = QuickQueryParser.parseParameter(chars);
                        if (tuple == null) {
                            result.push((Object)new ParsedError("Invalid query expression.", input, posAfterColon, chars.getIndex()));
                        } else {
                            parameterKey = tuple[0];
                            parameterValue = tuple[1];
                        }
                    }
                    ParsedAttribute parseResult = new ParsedAttribute(keyword, operator, parameterKey, parameterValue, negate, input, posOperationNameStart, chars.getIndex());
                    parseResult.attributeStart = posElementStart;
                    parseResult.attributeEnd = posOperationNameEnd;
                    parseResult.parameterStart = posAfterColon;
                    parseResult.parameterEnd = chars.getIndex();
                    IPlanningAttribute<?> attribute = this.fQuickQueryDefinition.getAttribute(parseResult.attribute);
                    if (!this.fIsErrorFlow && this.fSampleCallback != null && attribute != null) {
                        switch (attribute.getDescription().getAttributeType()) {
                            case INSTANT: {
                                if (this.isLessThanExpression(input)) {
                                    this.fSampleCallback.showSamples("Examples: &lt;2013-10-21; &lt;today+1");
                                    break;
                                }
                                if (this.isGreaterThanExpression(input)) {
                                    this.fSampleCallback.showSamples("Examples: &gt;2013-10-21; &gt;today+1");
                                    break;
                                }
                                this.fSampleCallback.showSamples("Examples: :2013-10-21; :today-1;");
                                break;
                            }
                            default: {
                                this.fSampleCallback.showSamples(null);
                            }
                        }
                    }
                    result.push((Object)parseResult);
                    foundOperation = true;
                } else {
                    chars.pushback();
                }
            } else if (keyword == null) {
                chars.reset(posOperationNameStart);
                keyword = QuickQueryParser.parseString(chars);
            }
            if (!foundOperation) {
                if (keyword != null) {
                    result.push((Object)new ParsedKeyword(keyword, negate, input, posOperationNameStart, chars.getIndex()));
                } else if (chars.hasNext()) {
                    chars.next();
                    result.push((Object)new ParsedError("Parameter expected.", input, posOperationNameStart, chars.getIndex()));
                }
            }
            negate = false;
            posElementStart = -1;
        }
        return (ParsedCommon[])result.toArray();
    }

    private void replaceInSegments(String[] segments, String valueToReplace, String replacementValue) {
        String regExStr = "(^|\\W)" + valueToReplace + "($|\\W)";
        JSRegExp regExp = new JSRegExp(regExStr);
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            if (regExp.test(segment)) {
                segments[i] = JSStrings.replace((String)segment, (String)valueToReplace, (String)replacementValue);
            }
            ++i;
        }
    }

    public String idLabelSwitcher(String expression, final LabelSwitcher direction) {
        if (expression == null) {
            return null;
        }
        Object[] segments = JSStrings.split((String)expression, (JSRegExp)new JSRegExp("\\s", "g"));
        this.withQueryableAttributes(new IQueryableAttributeRunnable((String[])segments){
            private final /* synthetic */ String[] val$segments;
            {
                this.val$segments = stringArray;
            }

            @Override
            public void run(IPlanningAttribute<?> attribute) {
                if (attribute.getDescription().getAttributeType() == PlanningAttributeType.REFERENCE) {
                    String label = QuickQueryUtil.getLabel(attribute);
                    String queryId = attribute.getDescription().getQueryId();
                    if (queryId != null && label != queryId) {
                        String replacement = direction == LabelSwitcher.TO_LABEL ? label : queryId;
                        String valueToReplace = direction == LabelSwitcher.TO_LABEL ? queryId : label;
                        QuickQueryParser.this.replaceInSegments(this.val$segments, valueToReplace, replacement);
                    }
                }
            }
        });
        return JSArrays.join((Object[])segments, (String)" ");
    }

    public static interface IInstantAttributeListener
    extends IJSFunction {
        public void showSamples(String var1);
    }

    private static interface IQueryableAttributeRunnable
    extends IJSFunction {
        public void run(IPlanningAttribute<?> var1);
    }

    public static enum LabelSwitcher {
        TO_LABEL,
        TO_ID;

    }

    public static enum Operators {
        Default(":"),
        Subtree("~"),
        Eq("="),
        Lt("<"),
        Gt(">");

        public final String fToken;

        private Operators(String token) {
            this.fToken = token;
        }
    }

    private static class ParsedAttribute
    extends ParsedCommon {
        private String attribute;
        private Operators operator;
        private String parameterKey;
        private String parameterValue;
        private boolean negate;
        private int attributeStart;
        private int attributeEnd;
        private int parameterStart;
        private int parameterEnd;

        public ParsedAttribute(String attribute, Operators operator, String parameterKey, String parameterValue, boolean negate, String input, int start, int end) {
            super(input, start, end);
            this.attribute = attribute;
            this.operator = operator;
            this.parameterKey = parameterKey;
            this.parameterValue = parameterValue;
            this.negate = negate;
        }
    }

    private static class ParsedCommon
    extends DojoObject {
        private int start;
        private int end;
        private String text;

        public ParsedCommon(String input, int start, int end) {
            this.start = start;
            this.end = end;
            this.text = input.substring(start, end);
        }
    }

    private static class ParsedError
    extends ParsedCommon {
        private String errorMessage;

        public ParsedError(String errorMessage, String input, int start, int end) {
            super(input, start, end);
            this.errorMessage = errorMessage;
        }
    }

    private static class ParsedKeyword
    extends ParsedCommon {
        private String keyword;
        private boolean negate;

        public ParsedKeyword(String keyword, boolean negate, String input, int start, int end) {
            super(input, start, end);
            this.keyword = keyword;
            this.negate = negate;
        }
    }
}

