/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.JSNumbers;
import com.ibm.team.apt.api.client.ICmChangeRequest;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.apt.api.client.IPlanModel;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.api.ui.essentials.IPlanModelContext;
import com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition;
import com.ibm.team.apt.shared.ui.internal.quickqueries.AttributeCondition;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryUtil;
import com.ibm.team.apt.shared.ui.internal.quickqueries.Term;

public class QuickQueryDefinition
extends DojoObject {
    private static PlanningAttributeType[] OR_ATTRIBUTE_TYPES = new PlanningAttributeType[]{PlanningAttributeType.INTEGER, PlanningAttributeType.BOOLEAN, PlanningAttributeType.INSTANT, PlanningAttributeType.DURATION, PlanningAttributeType.TIMESPAN, PlanningAttributeType.WORKITEM_TYPE, PlanningAttributeType.ITEM, PlanningAttributeType.ENUMERATION, PlanningAttributeType.TAGS};
    private static PlanningAttributeType[] OR_ATTRIBUTE_TYPES_FOR_EXCLUSION = new PlanningAttributeType[]{PlanningAttributeType.INTEGER, PlanningAttributeType.BOOLEAN, PlanningAttributeType.INSTANT, PlanningAttributeType.DURATION, PlanningAttributeType.TIMESPAN, PlanningAttributeType.WORKITEM_TYPE, PlanningAttributeType.ITEM, PlanningAttributeType.ENUMERATION};
    private final IPlanModelContext fContext;
    private IPlanningAttribute<?>[] fAttributes = null;

    public QuickQueryDefinition(IPlanModelContext context) {
        this.fContext = context;
    }

    public IQuickQueryCondition getWordExpression(String keyword) {
        Term result = new Term(Term.Operator.OR, new IQuickQueryCondition[0]);
        IPlanModel plan = this.fContext.getPlanModel();
        result.add(new AttributeCondition(plan.findAttribute(IPlanItem.SUMMARY), QuickQueryParser.Operators.Eq, "label", keyword));
        result.add(new AttributeCondition(plan.findAttribute(IPlanItem.DESCRIPTION), QuickQueryParser.Operators.Eq, "label", keyword));
        result.add(new AttributeCondition(plan.findAttribute(ICmChangeRequest.DC_TITLE), QuickQueryParser.Operators.Eq, "label", keyword));
        if (!JSNumbers.isNaN((int)JSNumbers.parseInt((String)keyword))) {
            result.add(new AttributeCondition(plan.findAttribute(IPlanItem.ID), QuickQueryParser.Operators.Eq, "label", keyword));
        }
        return result;
    }

    public IQuickQueryCondition getAttributeExpression(String queryName, QuickQueryParser.Operators operator, String key, String value) {
        IPlanningAttribute<?> planAttribute = this.getAttribute(queryName);
        return planAttribute != null ? new AttributeCondition(planAttribute, operator, key, value) : null;
    }

    public Term.Operator getAttributeCombination(String queryName) {
        return this.getAttributeCombinationForExclusion(queryName, false);
    }

    public Term.Operator getAttributeCombinationForExclusion(String queryName, boolean isExclusion) {
        IPlanningAttribute<?> planAttribute = this.getAttribute(queryName);
        if (planAttribute != null) {
            PlanningAttributeType[] orAttributeTypes = isExclusion ? this.getOrAttributeTypesForExclusion() : this.getOrAttributeTypes();
            PlanningAttributeType[] planningAttributeTypeArray = orAttributeTypes;
            int n = orAttributeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                PlanningAttributeType type = planningAttributeTypeArray[n2];
                if (type == planAttribute.getDescription().getAttributeType()) {
                    return Term.Operator.OR;
                }
                ++n2;
            }
        }
        return Term.Operator.AND;
    }

    protected PlanningAttributeType[] getOrAttributeTypes() {
        return OR_ATTRIBUTE_TYPES;
    }

    protected PlanningAttributeType[] getOrAttributeTypesForExclusion() {
        return OR_ATTRIBUTE_TYPES_FOR_EXCLUSION;
    }

    private boolean shouldReplace(IPlanningAttribute<?> existing, IPlanningAttribute<?> newAttr) {
        return existing.getDescription().getQueryId() == null && newAttr.getDescription().getQueryId() != null;
    }

    public IPlanningAttribute<?>[] getAllAttributes() {
        if (this.fAttributes == null) {
            JSMap map = new JSMap();
            IPlanningAttribute[] iPlanningAttributeArray = this.fContext.getPlanModel().getAllAttributes();
            int n = iPlanningAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlanningAttribute attribute = iPlanningAttributeArray[n2];
                String label = QuickQueryUtil.getLabel(attribute);
                if (label != null && (!map.contains(label) || this.shouldReplace((IPlanningAttribute)map.get(label), attribute))) {
                    map.put(label, (Object)attribute);
                }
                ++n2;
            }
            this.fAttributes = (IPlanningAttribute[])map.values();
        }
        return this.fAttributes;
    }

    public IPlanningAttribute<?> getAttribute(String attributeQueryId) {
        IPlanningAttribute<?> attribute;
        IPlanningAttribute<?>[] attributes;
        if (attributeQueryId == null) {
            return null;
        }
        IPlanningAttribute<?>[] iPlanningAttributeArray = attributes = this.getAllAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            attribute = iPlanningAttributeArray[n2];
            if (attribute.getDescription().getAttributeType() == PlanningAttributeType.REFERENCE && attributeQueryId == QuickQueryUtil.getLabel(attribute)) {
                return attribute;
            }
            ++n2;
        }
        iPlanningAttributeArray = attributes;
        n = attributes.length;
        n2 = 0;
        while (n2 < n) {
            attribute = iPlanningAttributeArray[n2];
            if (attribute.getDescription().getQueryId() == attributeQueryId) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }
}

