/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.base.dojo;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSRegExp;
import com.ibm.jdojo.util.JSSet;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.jdojo.util.NLS;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;

public class ParameterProposalBuilder
extends DojoObject {
    private static final String[] BOOLEAN_PROPOSALS = new String[]{String.valueOf(true), String.valueOf(false)};
    private static final String[] INSTANT_PROPOSALS = new String[]{"today", "today+", "today-"};
    private static final String[] REFERENCE_PROPOSALS = new String[]{String.valueOf(1), "set", "unset"};
    private static final String[] NO_PROPOSALS = new String[0];
    private static final String QUOTE_FORMAT = "\"${0}\"";

    public String[] getProposals(IPlanningAttribute<?> attribute) {
        String[] result = this.getProposalsByType(attribute);
        return result == null ? NO_PROPOSALS : result;
    }

    private IUIItem[] considerOnlyUIItems(Object[] values) {
        Object[] items = dojo.filter((Object[])values, (dojo.Selector)new dojo.Selector<Object>(){

            public boolean select(Object element, int index, Object[] array) {
                return element instanceof IUIItem;
            }
        });
        return (IUIItem[])items;
    }

    private boolean containsWhitespace(String label) {
        JSRegExp catchWhitespace = new JSRegExp("\\s");
        String[] matches = JSStrings.match((String)label, (JSRegExp)catchWhitespace);
        return matches != null && matches.length > 0;
    }

    private String[] getProposalsByType(IPlanningAttribute<?> attribute) {
        PlanningAttributeType type = this.getType(attribute);
        switch (type) {
            case WORKITEM_TYPE: 
            case WORKFLOW_STATE: 
            case ITEM: 
            case ENUMERATION: {
                return this.handleValueSetProposals(attribute);
            }
            case REFERENCE: {
                return REFERENCE_PROPOSALS;
            }
            case BOOLEAN: {
                return BOOLEAN_PROPOSALS;
            }
            case INSTANT: {
                return INSTANT_PROPOSALS;
            }
        }
        return null;
    }

    private String getProposalFromUIItem(IUIItem item) {
        String label = item.getLabel();
        return label == null ? null : this.wrapLabelIfMultiWord(label);
    }

    private PlanningAttributeType getType(IPlanningAttribute<?> attribute) {
        if (attribute.getDescription() != null) {
            return attribute.getDescription().getAttributeType();
        }
        return null;
    }

    private String[] handleValueSetProposals(IPlanningAttribute<?> attribute) {
        IPlanningAttributeValueSet valueSet = attribute.getValueSet(null);
        return valueSet == null ? null : this.mapValueSetToProposals(valueSet);
    }

    private String[] mapUIItemsToProposals(IUIItem[] items) {
        Object[] result = new String[]{};
        JSSet visited = new JSSet();
        IUIItem[] iUIItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IUIItem item = iUIItemArray[n2];
            String proposal = this.getProposalFromUIItem(item);
            if (proposal != null && !visited.contains(proposal)) {
                visited.add(proposal);
                JSArrays.push((Object[])result, (Object)proposal);
            }
            ++n2;
        }
        return result;
    }

    private String[] mapValueSetToProposals(IPlanningAttributeValueSet valueSet) {
        Object[] allValues = valueSet.getAllValues();
        return allValues == null ? null : this.mapValuesToProposals(allValues);
    }

    private String[] mapValuesToProposals(Object[] values) {
        IUIItem[] items = this.considerOnlyUIItems(values);
        return this.mapUIItemsToProposals(items);
    }

    private String wrapLabelIfMultiWord(String label) {
        if (label != null && this.containsWhitespace(label)) {
            return NLS.bind((String)QUOTE_FORMAT, (Object)label, (Object[])new Object[0]);
        }
        return label;
    }
}

