/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.quickqueries;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Types;
import com.ibm.jdojo.lang.reflection.Undefined;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSDate;
import com.ibm.jdojo.util.JSNumbers;
import com.ibm.jdojo.util.JSRegExp;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.client.IPlanningAttributeValueSet;
import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.planning.IPlanInclusion;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.api.common.repository.IContributor;
import com.ibm.team.apt.api.common.repository.IReferences;
import com.ibm.team.apt.api.common.workitem.ICategory;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.api.common.workitem.IEnumerationElement;
import com.ibm.team.apt.api.common.workitem.IWorkflowResolution;
import com.ibm.team.apt.api.common.workitem.IWorkflowState;
import com.ibm.team.apt.api.ui.quickquery.IQuickQueryCondition;
import com.ibm.team.apt.shared.client.internal.duration.Instant;
import com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute;
import com.ibm.team.apt.shared.ui.internal.quickqueries.QuickQueryParser;
import com.ibm.team.workitem.shared.common.AuthenticatedContributor;
import com.ibm.team.workitem.shared.common.BigDecimal;

public class AttributeCondition
extends DojoObject
implements IQuickQueryCondition {
    private static final String ID_KEY = "id";
    private static final String EMPTY = "";
    private static final String CURRENT_USER = "currentuser";
    private IPlanningAttribute<?> fAttribute;
    private QuickQueryParser.Operators fOperator;
    private Object fValue;
    private Evaluators fEvaluator;
    private final String fKey;
    private final String fStringValue;

    public AttributeCondition(IPlanningAttribute<?> attribute, QuickQueryParser.Operators operator, String key, String value) {
        this.fAttribute = attribute;
        this.fOperator = operator;
        this.fKey = key;
        this.fStringValue = value;
        this.fEvaluator = this.getEvaluator();
    }

    public boolean evaluate(IPlanElement planItem) {
        Object itemValue;
        if (this.fValue == null) {
            this.fValue = this.fEvaluator.convertQueryValue(this.fAttribute, this.fStringValue != null ? this.fStringValue : EMPTY);
            if (this.fValue == null) {
                return false;
            }
        }
        return (itemValue = planItem.getAttributeValue(this.fAttribute)) != Undefined.VALUE() ? this.fEvaluator.doEvaluate(this.fOperator, this.fKey, this.fValue, itemValue, planItem) : false;
    }

    public boolean canEvaluate(IPlanElement planItem) {
        return planItem.getAttributeValue(this.fAttribute) != Undefined.VALUE();
    }

    public IPlanningAttributeIdentifier[] getDependentAttributes() {
        return new IPlanningAttributeIdentifier[]{this.fAttribute};
    }

    public QuickQueryParser.Operators getOperator() {
        return this.fOperator;
    }

    public String getValue() {
        return this.fStringValue;
    }

    public Evaluators getEvaluator() {
        switch (this.fAttribute.getDescription().getAttributeType()) {
            case STRING: 
            case HTML: {
                return Evaluators.String;
            }
            case TAGS: {
                return Evaluators.Tags;
            }
            case INTEGER: 
            case FLOAT: {
                return Evaluators.Number;
            }
            case DECIMAL: {
                return Evaluators.Decimal;
            }
            case BOOLEAN: {
                return Evaluators.Boolean;
            }
            case INSTANT: {
                return Evaluators.Instant;
            }
            case DURATION: {
                return Evaluators.Duration;
            }
            case WORKITEM_TYPE: 
            case ITEM: {
                return Evaluators.Item;
            }
            case WORKFLOW_STATE: {
                return Evaluators.State;
            }
            case WORKFLOW_RESOLUTION: {
                return Evaluators.Resolution;
            }
            case ENUMERATION: {
                return Evaluators.Enumeration;
            }
            case CHECKERREPORT: {
                return Evaluators.ProblemReport;
            }
            case REFERENCE: {
                return Evaluators.Reference;
            }
        }
        return Evaluators.False;
    }

    public IQuickQueryCondition[] getSubConditions() {
        return new IQuickQueryCondition[0];
    }

    public boolean isEqual(IQuickQueryCondition other) {
        if (this == other) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        if (this.fAttribute.getId() == ((AttributeCondition)other).fAttribute.getId()) {
            return false;
        }
        if (this.fOperator != ((AttributeCondition)other).fOperator) {
            return false;
        }
        if (this.fEvaluator != ((AttributeCondition)other).fEvaluator) {
            return false;
        }
        if (this.fAttribute.getDescription().getAttributeType() == PlanningAttributeType.ENUMERATION) {
            return ((IEnumerationElement)this.fValue).getLabel() == ((IEnumerationElement)((AttributeCondition)other).fValue).getLabel();
        }
        return this.fValue == ((AttributeCondition)other).fValue;
    }

    public static enum Evaluators {
        Boolean{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                if (itemValue instanceof DirtyAttribute.DirtyAttributes) {
                    return ((DirtyAttribute.DirtyAttributes)itemValue).isDirty() == ((Boolean)queryValue).booleanValue();
                }
                if (itemValue instanceof IPlanInclusion) {
                    return ((IPlanInclusion)itemValue).isIncluded() == ((Boolean)queryValue).booleanValue();
                }
                return queryValue == itemValue;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value != null && value.toLowerCase() == "true") {
                    return true;
                }
                return false;
            }
        }
        ,
        Duration{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                long numberValue = (Long)queryValue;
                if (numberValue == -1L) {
                    return !((IDuration)itemValue).isSpecified();
                }
                if (numberValue == -2L) {
                    return ((IDuration)itemValue).isSpecified();
                }
                if (!JSNumbers.isNaN((Object)queryValue) && itemValue != null && ((IDuration)itemValue).isSpecified()) {
                    long ms = ((IDuration)itemValue).getMilliseconds();
                    switch (operator) {
                        case Default: 
                        case Eq: {
                            return ms == numberValue;
                        }
                        case Lt: {
                            return ms < numberValue;
                        }
                        case Gt: {
                            return ms > numberValue;
                        }
                    }
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value == null) {
                    return -3;
                }
                if (value.toLowerCase() == "set") {
                    return -2;
                }
                if (value.toLowerCase() == "unset") {
                    return -1;
                }
                return JSNumbers.parseInt((String)value) * 60 * 60 * 1000;
            }
        }
        ,
        Enumeration{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                if (queryValue == null || itemValue == null) {
                    return false;
                }
                int compared = ((IEnumerationElement)itemValue).compareTo((IEnumerationElement)queryValue);
                if (operator == QuickQueryParser.Operators.Default || operator == QuickQueryParser.Operators.Eq) {
                    return compared == 0;
                }
                if (operator == QuickQueryParser.Operators.Lt) {
                    return compared < 0;
                }
                if (operator == QuickQueryParser.Operators.Gt) {
                    return compared > 0;
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value == null) {
                    return null;
                }
                Object[] valueSet = attribute.getValueSet(null).getValues();
                int i = 0;
                while (i < valueSet.length) {
                    if (((IEnumerationElement)valueSet[i]).getLabel().toLowerCase() == value.toLowerCase()) {
                        return valueSet[i];
                    }
                    ++i;
                }
                return null;
            }
        }
        ,
        Reference{

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value == null) {
                    return -3;
                }
                if (value.toLowerCase() == "set") {
                    return -1;
                }
                if (value.toLowerCase() == "unset") {
                    return -2;
                }
                int number = JSNumbers.parseInt((String)value);
                if (JSNumbers.isNaN((int)number)) {
                    return -3;
                }
                return number;
            }

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                int queryNumber = (Integer)queryValue;
                if (queryNumber == -3) {
                    return false;
                }
                IReferences references = (IReferences)itemValue;
                int length = references.getReferences().length;
                if (operator == QuickQueryParser.Operators.Default && queryNumber < 0) {
                    return queryNumber == -1 && length != 0 || queryNumber == -2 && length == 0;
                }
                if (operator == QuickQueryParser.Operators.Eq || operator == QuickQueryParser.Operators.Default) {
                    return queryNumber == length;
                }
                if (operator == QuickQueryParser.Operators.Gt) {
                    return length > queryNumber;
                }
                if (operator == QuickQueryParser.Operators.Lt) {
                    return length > queryNumber;
                }
                return false;
            }
        }
        ,
        False{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value;
            }
        }
        ,
        Instant{

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value.indexOf(60) == 0 || value.indexOf(62) == 0) {
                    value = value.substring(1);
                }
                if (value.indexOf(45) != -1 && value.indexOf(45) < 4) {
                    return null;
                }
                Object queryValue = this.checkIfPrefixExpression(value);
                if (queryValue != null) {
                    return queryValue;
                }
                if (this.checkIfAbsoluteDateExpression(value)) {
                    JSRegExp formatDate = new JSRegExp("-", "g");
                    String convertedString = JSStrings.replace((String)value, (JSRegExp)formatDate, (String)"/");
                    return new JSDate(convertedString);
                }
                return null;
            }

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                JSDate itemDate;
                int MILLISECONDSINADAY = 86400000;
                JSDate jSDate = itemDate = itemValue != null ? new JSDate(((Instant)itemValue).getTime()) : null;
                if (queryValue instanceof JSDate) {
                    int dateCompareResult = this.compareDates(itemDate, (JSDate)queryValue);
                    if (itemDate != null) {
                        if (operator == QuickQueryParser.Operators.Lt) {
                            return dateCompareResult < 0;
                        }
                        if (operator == QuickQueryParser.Operators.Gt) {
                            return dateCompareResult > 0;
                        }
                        return dateCompareResult == 0;
                    }
                } else {
                    int today = (Integer)queryValue;
                    long timeDifference = new JSDate().getTime() + (long)(today * MILLISECONDSINADAY);
                    JSDate differenceDate = new JSDate(timeDifference);
                    int dateCompareResult = this.compareDates(itemDate, differenceDate);
                    if (itemDate != null) {
                        if (operator == QuickQueryParser.Operators.Lt) {
                            return dateCompareResult < 0;
                        }
                        if (operator == QuickQueryParser.Operators.Gt) {
                            return dateCompareResult > 0;
                        }
                        return dateCompareResult == 0;
                    }
                }
                return false;
            }

            public Object checkIfPrefixExpression(String value) {
                String PREFIX = "today";
                String PREFIXFORWARD = "today+";
                String PREFIXBACKWARD = "today-";
                JSRegExp EXTRACT_NON_NUMERIC = new JSRegExp("[^(0-9)]", "g");
                if (value.equals(PREFIX)) {
                    return JSNumbers.Number((Object)0);
                }
                if (value.substring(0, 6).equals(PREFIXFORWARD)) {
                    String[] nonNumericElements = JSStrings.match((String)value.substring(6), (JSRegExp)EXTRACT_NON_NUMERIC);
                    return nonNumericElements != null && nonNumericElements.length > 0 ? null : Integer.valueOf(JSNumbers.parseInt((String)value.substring(6)));
                }
                if (value.substring(0, 6).equals(PREFIXBACKWARD)) {
                    String[] nonNumericElements = JSStrings.match((String)value.substring(6), (JSRegExp)EXTRACT_NON_NUMERIC);
                    return nonNumericElements != null && nonNumericElements.length > 0 ? null : Integer.valueOf(JSNumbers.parseInt((String)value.substring(6)) * -1);
                }
                return null;
            }

            private boolean checkIfAbsoluteDateExpression(String value) {
                return JSStrings.match((String)value, (JSRegExp)QuickQueryParser.ABSOLUTE_DATE_REGEX) != null;
            }

            public int compareDates(JSDate date1, JSDate date2) {
                if (date1 != null && date2 != null) {
                    int yearDifference = date1.getFullYear() - date2.getFullYear();
                    if (yearDifference == 0) {
                        int monthDifference = date1.getMonth() - date2.getMonth();
                        if (monthDifference == 0) {
                            return date1.getDate() - date2.getDate();
                        }
                        return monthDifference;
                    }
                    return yearDifference;
                }
                return -1;
            }
        }
        ,
        Item{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                String s;
                if (itemValue == null) {
                    return queryValue == "unset";
                }
                boolean value = false;
                if (Types.isString((Object)queryValue) && (s = (String)queryValue).charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
                    queryValue = s.substring(1, s.length() - 2);
                }
                if (operator == QuickQueryParser.Operators.Subtree && itemValue instanceof ICategory && Types.isString((Object)queryValue)) {
                    value = this.isSubCategory((String)queryValue, (ICategory)itemValue);
                } else if (itemValue instanceof IContributor && this.checkIfCurrentUserExpression((String)queryValue)) {
                    value = this.isCurrentUser((IContributor)itemValue);
                } else if (key == null || "label".equals(key)) {
                    value = ((IUIItem)itemValue).getLabel().toLowerCase() == queryValue;
                } else if (AttributeCondition.ID_KEY.equals(key)) {
                    value = ((IUIItem)itemValue).getItemId().toLowerCase() == queryValue;
                }
                return value;
            }

            boolean isSubCategory(String qvs, ICategory category) {
                qvs = ("/" + qvs + "/").toLowerCase();
                String categoryId = category.getCategoryId().toLowerCase();
                return categoryId.indexOf(qvs) != -1;
            }

            boolean checkIfCurrentUserExpression(String value) {
                return value.equals(AttributeCondition.CURRENT_USER);
            }

            boolean isCurrentUser(IContributor contributor) {
                return AuthenticatedContributor.getItemId() == contributor.getItemId();
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value.toLowerCase();
            }
        }
        ,
        Number{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                if (queryValue == null) {
                    return false;
                }
                switch (operator) {
                    case Default: 
                    case Eq: {
                        return itemValue == queryValue;
                    }
                    case Lt: {
                        return (Double)itemValue <= (Double)queryValue;
                    }
                    case Gt: {
                        return (Double)itemValue >= (Double)queryValue;
                    }
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value != null ? Double.valueOf(JSNumbers.parseFloat((String)value)) : null;
            }
        }
        ,
        Decimal{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                if (queryValue == null) {
                    return false;
                }
                BigDecimal itemDecimal = (BigDecimal)itemValue;
                BigDecimal queryDecimal = (BigDecimal)queryValue;
                int compared = itemDecimal.compareTo(queryDecimal);
                switch (operator) {
                    case Default: 
                    case Eq: {
                        return compared == 0;
                    }
                    case Lt: {
                        return compared == -1;
                    }
                    case Gt: {
                        return compared == 1;
                    }
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value != null ? new BigDecimal(value) : null;
            }
        }
        ,
        ProblemReport{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value;
            }
        }
        ,
        State{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planElement) {
                if (itemValue instanceof IWorkflowState && queryValue instanceof IWorkflowState) {
                    IWorkflowState itemState = (IWorkflowState)itemValue;
                    IWorkflowState queryState = (IWorkflowState)queryValue;
                    String itemStateLabel = itemState.getLabel();
                    String queryStateLabel = queryState.getLabel();
                    return queryStateLabel.toLowerCase() == itemStateLabel.toLowerCase();
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                if (value != null) {
                    String loweredValue = value.toLowerCase();
                    IPlanningAttributeValueSet values = attribute.getValueSet(null);
                    Object[] objectArray = values.getValues();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IWorkflowState && ((IWorkflowState)element).getLabel().toLowerCase() == loweredValue) {
                            return element;
                        }
                        ++n2;
                    }
                }
                return null;
            }
        }
        ,
        Resolution{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planElement) {
                if (itemValue instanceof IWorkflowResolution) {
                    boolean isLabelEmpty;
                    IWorkflowResolution state = (IWorkflowResolution)itemValue;
                    String label = state.getLabel();
                    label = label == null ? AttributeCondition.EMPTY : label.toLowerCase();
                    boolean bl = isLabelEmpty = label == AttributeCondition.EMPTY;
                    return queryValue == AttributeCondition.EMPTY ? !isLabelEmpty : label == queryValue;
                }
                return false;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value != null ? value.toLowerCase() : AttributeCondition.EMPTY;
            }
        }
        ,
        String{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                if (queryValue == null || itemValue == null) {
                    return false;
                }
                return ((String)itemValue).toLowerCase().indexOf((String)queryValue) != -1;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value != null ? value.toLowerCase() : null;
            }
        }
        ,
        Tags{

            @Override
            public boolean doEvaluate(QuickQueryParser.Operators operator, String key, Object queryValue, Object itemValue, IPlanElement planItem) {
                Object[] tags = (String[])itemValue;
                if (queryValue == AttributeCondition.EMPTY) {
                    return tags.length > 0;
                }
                return JSArrays.indexOf((Object[])tags, (Object)java.lang.String.valueOf(queryValue)) != -1;
            }

            @Override
            public Object convertQueryValue(IPlanningAttribute<?> attribute, String value) {
                return value.toLowerCase();
            }
        };


        public abstract boolean doEvaluate(QuickQueryParser.Operators var1, String var2, Object var3, Object var4, IPlanElement var5);

        public abstract Object convertQueryValue(IPlanningAttribute<?> var1, String var2);
    }

    public static enum InstantExpressionOperation {
        Equal("="),
        LessThan("<"),
        GreaterThan(">");

        private String fOperationType;

        private InstantExpressionOperation(String operationType) {
            this.fOperationType = operationType;
        }

        public String getOperationType() {
            return this.fOperationType;
        }
    }
}

