/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.ui.internal.filters;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.apt.api.client.IPlanningAttributeDependent;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.ui.structure.IGroupElement;
import com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryFilter;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryTag;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.tags.PrimaryLocationTag;

public abstract class AbstractPlanElementFilter
extends DojoObject
implements IViewEntryFilter,
IPlanningAttributeDependent {
    private final IPlanningAttributeIdentifier[] fDependentAttrs;
    protected final IPlanningAttributeIdentifier[] fFilterProperty = new IPlanningAttributeIdentifier[0];

    protected AbstractPlanElementFilter(IPlanningAttributeIdentifier ... more) {
        JSArrays.pushArray((Object[])this.fFilterProperty, (Object[])more);
        this.fDependentAttrs = new IPlanningAttributeIdentifier[]{IPlanItem.DIRTY};
        JSArrays.pushArray((Object[])this.fDependentAttrs, (Object[])this.fFilterProperty);
    }

    public IPlanningAttributeIdentifier[] getDependentAttributes() {
        return this.fDependentAttrs;
    }

    public boolean isFilterProperty(IViewEntry<?> entry, String property) {
        int i = 0;
        while (i < this.fFilterProperty.length) {
            if (property == this.fFilterProperty[i].getId()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isDirty(IPlanElement element) {
        DirtyAttribute.DirtyAttributes dirtyAttributes = (DirtyAttribute.DirtyAttributes)element.getAttributeValue(IPlanItem.DIRTY);
        return dirtyAttributes == null || dirtyAttributes.isDirty();
    }

    public boolean select(IViewEntry<?> entry, IViewModelReader readAccessor) {
        Object element = entry.getElement();
        if (!(element instanceof IPlanElement)) {
            return true;
        }
        if (this.isDirty((IPlanElement)element)) {
            return true;
        }
        boolean selected = this.doSelect(entry, readAccessor);
        return this.applyContextToSelection(entry, readAccessor, selected);
    }

    protected boolean applyContextToSelection(IViewEntry<?> entry, IViewModelReader readAccessor, boolean entrySelected) {
        if (entry.hasTag((IViewEntryTag)PrimaryLocationTag.INSTANCE) || !entrySelected) {
            return entrySelected;
        }
        IViewEntry parent = readAccessor.getParent(entry);
        if (!(parent.getElement() instanceof IGroupElement) && !parent.isRootEntry()) {
            return true;
        }
        for (IViewEntry child : readAccessor.getChildren(entry)) {
            if (!child.isVisible()) continue;
            return true;
        }
        return false;
    }

    protected boolean doSelect(IViewEntry<IPlanElement> entry, IViewModelReader readAccessor) {
        return true;
    }
}

