/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2010, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeScheduler");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Instant");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");
dojo.require("com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment");
dojo.require("com.ibm.team.apt.shared.client.internal.scheduler.time.AssignmentIterator");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var internal= com.ibm.team.apt.shared.client.internal;
var duration2= internal.duration;
var Instant= duration2.Instant;
var Timespan= duration2.Timespan;
var time= internal.scheduler.time;
var Assignment= time.Assignment;
var AssignmentIterator= time.AssignmentIterator;

dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeScheduler", null, {
	"-chains-": { constructor: "manual" },

	//fIterator: null,

	constructor: function(timeIterator) {
		if (timeIterator instanceof AssignmentIterator) {
			this.fIterator= timeIterator;
		} else {
			var assignment= new Assignment(Instant.time(1), Instant.time(Math.pow(2, 52)), 1);
			this.fIterator= new AssignmentIterator(timeIterator, [assignment]);
		}
	},

	schedule: function(earliestStart, duration, forward) {
		this.fIterator.reset(earliestStart, forward);
		var startTime, endTime, currentStart, currentEnd;
		var access= forward ? Direction.Forward : Direction.Backward;
		var lastAssignment= this.fIterator.getAssignment();
		var scaledDuration= (lastAssignment === 0) ? Math.max(1, duration.getMilliseconds()) : Math.max(1, Math.round(duration.getMilliseconds() / lastAssignment));
		startTime= currentStart= access.low(this.fIterator.current());
		endTime= currentEnd= access.high(this.fIterator.current(), scaledDuration);
		while(scaledDuration > 0){
			scaledDuration-= Math.abs(currentEnd - currentStart);
			endTime= currentEnd;
			if (!(this.fIterator.next() != null)) Assert.fail("this.fIterator.next() != null", "WorktimeScheduler:53");
			if (lastAssignment !== this.fIterator.getAssignment()) {
				scaledDuration= Math.max(1, Math.round(((scaledDuration * lastAssignment) / this.fIterator.getAssignment())));
				lastAssignment= this.fIterator.getAssignment();
			}
			currentStart= access.low(this.fIterator.current());
			currentEnd= access.high(this.fIterator.current(), scaledDuration);
		}
		var begin= Instant.time(startTime);
		var end= Instant.time(endTime);
		return forward ? new Timespan(begin, end) : new Timespan(end, begin);
	},

	workTime: function(timespan) {
		this.fIterator.reset(timespan.getStart(), true);
		var workTime= 0;
		var maxEnd= timespan.getEnd().getTime();
		var currentStart, currentEnd;
		do {
			currentStart= Math.min(this.fIterator.current().getStart().getTime(), maxEnd);
			currentEnd= Math.min(this.fIterator.current().getEnd().getTime(), maxEnd);
			workTime+= Math.max(0, currentEnd - currentStart) * this.fIterator.getAssignmentForWorkTime();
		} while(this.fIterator.nextForWorkTime() != null && currentEnd !== maxEnd)
		return Math.round(workTime);
	}
});
var Direction= dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeScheduler.Direction", null, {

	low: function(timespan) {
		Assert.isTrue(false, "Abstract method 'low' invoked");
	},

	high: function(timespan, rawDuration) {
		Assert.isTrue(false, "Abstract method 'high' invoked");
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});

Direction.values= [
	dojo.mixin(new Direction(), {
		name: 'Forward',
		ordinal: 0,
		low: function(timespan) {
			return timespan.getStart().getTime();
		},
		high: function(timespan, rawDuration) {
			return Math.min(timespan.getEnd().getTime(), timespan.getStart().getTime() + rawDuration);
		}
	}),
	dojo.mixin(new Direction(), {
		name: 'Backward',
		ordinal: 1,
		low: function(timespan) {
			return timespan.getEnd().getTime();
		},
		high: function(timespan, rawDuration) {
			return Math.max(timespan.getStart().getTime(), timespan.getEnd().getTime() - rawDuration);
		}
	})
];
Direction.Forward= Direction.values[0];
Direction.Backward= Direction.values[1];

})();
