/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeIterator");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.workitem.Duration");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Instant");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var apt= com.ibm.team.apt;
var Duration= apt.api.common.workitem.Duration;
var duration4= apt.shared.client.internal.duration;
var Instant= duration4.Instant;
var Timespan= duration4.Timespan;

var WorktimeIterator= dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeIterator", null, {
	"-chains-": { constructor: "manual" },

	//fCurrent: null,

	//fCurrentDay: null,

	//fWorkdays: null,

	//fDirection: null,

	constructor: function(workdays) {
		this.fWorkdays= [];
		var isValid= false;
		var $subject= workdays;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var workday= $subject[$count];
			this.fWorkdays[workday.day - 1]= workday;
			isValid|= workday.workingTime > 0 && workday.endTime > 0;
		}
		if (!isValid) {
			var workDuration= 24 * 60 * 60 * 1000 - 1;
			var $subject2= workdays;
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var workday= $subject2[$count2];
				workday.workingTime= workDuration;
				workday.endTime= workDuration;
			}
		}
	},

	reset: function(earliestStart, forward) {
		this.fDirection= forward ? Direction.Forward : Direction.Backward;
		this.fCurrentDay= earliestStart;
		this.validate();
		if (forward && earliestStart.after(this.fCurrent.getStart())) {
			if (earliestStart.before(this.fCurrent.getEnd())) {
				this.fCurrent= new Timespan(earliestStart, this.fCurrent.getEnd());
			} else {
				this.next();
			}
		} else if (!forward && earliestStart.before(this.fCurrent.getEnd())) {
			if (earliestStart.after(this.fCurrent.getStart())) {
				this.fCurrent= new Timespan(this.fCurrent.getStart(), earliestStart);
			} else {
				this.next();
			}
		}
	},

	current: function() {
		return this.fCurrent;
	},

	next: function() {
		this.fCurrentDay= this.fDirection.next(this.fCurrentDay, WorktimeIterator.DAY);
		this.validate();
		return this.fCurrent;
	},

	validate: function() {
		var date= new Date(this.fCurrentDay.getTime());
		while(true){
			var workDay= this.fWorkdays[date.getDay()];
			date.setHours(0, 0, 0, 0);
			if (workDay.workingTime > 0) {
				var start= date.getTime() + workDay.endTime - workDay.workingTime;
				var end= date.getTime() + workDay.endTime;
				this.fCurrent= new Timespan(Instant.time(start), Instant.time(end));
				break;
			}
			this.fCurrentDay= this.fDirection.next(this.fCurrentDay, WorktimeIterator.DAY);
			date= new Date(this.fCurrentDay.getTime());
		}
	},

	$interfaces: {
		'com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator': true
	}
});
var Direction= dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.WorktimeIterator.Direction", null, {

	next: function(instant, duration) {
		Assert.isTrue(false, "Abstract method 'next' invoked");
	},

	compareTo: function(other) {
		return this.ordinal - other.ordinal;
	}
});

WorktimeIterator.DAY= new Duration(24 * 60 * 60 * 1000);
Direction.values= [
	dojo.mixin(new Direction(), {
		name: 'Forward',
		ordinal: 0,
		next: function(instant, duration) {
			return instant.plus(duration);
		}
	}),
	dojo.mixin(new Direction(), {
		name: 'Backward',
		ordinal: 1,
		next: function(instant, duration) {
			return instant.minus(duration);
		}
	})
];
Direction.Forward= Direction.values[0];
Direction.Backward= Direction.values[1];

})();
