/******************************************************************************
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.UnionIterator");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var Timespan= com.ibm.team.apt.shared.client.internal.duration.Timespan;

dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.UnionIterator", null, {
	"-chains-": { constructor: "manual" },

	//fIterators: null,

	//fCurrent: null,

	//fForward: null,

	constructor: function(iterators) {
		if (!(iterators.length > 0)) Assert.fail("iterators.length > 0", "UnionIterator:23");
		this.fIterators= iterators;
	},

	reset: function(earliestStart, forward) {
		this.fForward= forward;
		for (var i= 0; i < this.fIterators.length; i++){
			this.fIterators[i].reset(earliestStart, forward);
		}
		this.fCurrent= this.validate(earliestStart);
	},

	current: function() {
		return this.fCurrent;
	},

	next: function() {
		if (this.fCurrent != null) {
			this.fCurrent= this.validate(this.fForward ? this.fCurrent.getEnd() : this.fCurrent.getStart());
		}
		return this.fCurrent;
	},

	validate: function(earliestStart) {
		var currentPeriod;
		var begin, end;
		do {
			begin= earliestStart;
			end= null;
			for (var i= 0; i < this.fIterators.length; i++){
				currentPeriod= this.fIterators[i].current();
				if (currentPeriod == null) 
					return null;
				if (begin == null || (this.fForward ? currentPeriod.getStart().after(begin) : currentPeriod.getEnd().before(begin))) {
					begin= this.fForward ? currentPeriod.getStart() : currentPeriod.getEnd();
				}
			}
			var candidateInstant= begin;
			for (var i= 0; i < this.fIterators.length; i++){
				currentPeriod= this.fIterators[i].current();
				if (!this.contains(currentPeriod, candidateInstant)) {
					while(this.fForward ? currentPeriod.getEnd().beforeEq(candidateInstant) : currentPeriod.getStart().afterEq(candidateInstant)){
						currentPeriod= this.fIterators[i].next();
						if (currentPeriod == null) 
							return null;
					}
					begin= null;
					end= null;
				}
				if (end == null || (this.fForward ? currentPeriod.getEnd().before(end) : currentPeriod.getStart().after(end))) {
					end= this.fForward ? currentPeriod.getEnd() : currentPeriod.getStart();
				}
			}
		} while(begin == null || end == null)
		if (this.fForward) {
			return new Timespan(earliestStart.after(begin) ? earliestStart : begin, end);
		} else {
			return new Timespan(end, earliestStart.before(begin) ? earliestStart : begin);
		}
	},

	contains: function(timespan, instant) {
		if (this.fForward) {
			return timespan.getStart().beforeEq(instant) && timespan.getEnd().after(instant);
		} else {
			return timespan.getEnd().afterEq(instant) && timespan.getStart().before(instant);
		}
	},

	$interfaces: {
		'com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator': true
	}
});

})();
