/******************************************************************************
 Licensed Materials - Property of IBM
 (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.TimespanIterator");

dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");

(function() {
var Timespan= com.ibm.team.apt.shared.client.internal.duration.Timespan;

dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.TimespanIterator", null, {
	"-chains-": { constructor: "manual" },

	//fTimespans: null,

	//fCurrent: null,

	//fCurrentIndex: null,

	//fForward: null,

	constructor: function(timespans) {
		this.fCurrentIndex= -1;
		this.fForward= true;
		if (timespans.length === 0) {
			this.fTimespans= [];
		} else {
			timespans= this.sanitizeTimespans(timespans);
			this.fTimespans= [];
			this.fTimespans.push(timespans[0]);
			for (var i= 1; i < timespans.length; i++){
				var current= timespans[i];
				if (current !== this.fTimespans[this.fTimespans.length - 1]) {
					this.fTimespans.push(current);
				}
			}
		}
	},

	add: function(when) {
		var positionToInsert= 0;
		for (var i= 0; i < this.fTimespans.length; i++){
			var timespan= this.fTimespans[i];
			positionToInsert= i;
			if (timespan.contains(when.getStart()) && timespan.contains(when.getEnd())) {
				return ;
			}
			if (timespan.contains(when.getStart()) && !timespan.contains(when.getEnd())) {
				when= new Timespan(timespan.getStart(), when.getEnd());
				this.fTimespans.splice(i, 1, when);
				this.fTimespans= this.sanitizeTimespans(this.fTimespans);
				return ;
			}
			if (timespan.getEnd().eq(when.getStart())) {
				when= new Timespan(timespan.getStart(), when.getEnd());
				this.fTimespans.splice(i, 1, when);
				this.fTimespans= this.sanitizeTimespans(this.fTimespans);
				return ;
			}
			if (!timespan.contains(when.getStart()) && timespan.contains(when.getEnd())) {
				when= new Timespan(when.getStart(), timespan.getEnd());
				this.fTimespans.splice(i, 1, when);
				this.fTimespans= this.sanitizeTimespans(this.fTimespans);
				return ;
			}
			if (when.contains(timespan.getStart()) && when.contains(timespan.getEnd())) {
				this.fTimespans.splice(i, 1, when);
				this.fTimespans= this.sanitizeTimespans(this.fTimespans);
				return ;
			}
			if (when.getStart().before(timespan.getStart())) {
				this.fTimespans.splice(i, 0, when);
				this.fTimespans= this.sanitizeTimespans(this.fTimespans);
				return ;
			}
			if (when.getStart().afterEq(this.fTimespans[i].getEnd())) {
				positionToInsert= i + 1;
			}
		}
		this.fTimespans.splice(positionToInsert, 0, when);
	},

	sanitizeTimespans: function(timespans) {
		timespans.sort(function(left, right) {
			return left.getStart().compareTo(right.getStart());
		});
		for (var i= 1; i < timespans.length; i++){
			var previous= timespans[i - 1];
			var current= timespans[i];
			if (previous.getStart().eq(current.getStart()) && previous.getEnd().eq(current.getEnd())) {
				timespans[i]= timespans[i - 1];
			} else if (previous.getEnd().after(current.getStart())) {
				if (previous.getEnd().after(current.getEnd())) {
					timespans[i]= timespans[i - 1];
				} else {
					timespans[i]= new Timespan(previous.getEnd(), current.getEnd());
				}
			}
		}
		return timespans;
	},

	clear: function() {
		this.fTimespans= [];
		this.fCurrent= null;
		this.fCurrentIndex= -1;
		this.fForward= true;
	},

	reset: function(earliestStart, forward) {
		var current= null;
		var currentIndex= forward ? 0 : this.fTimespans.length - 1;
		while(forward ? currentIndex < this.fTimespans.length : currentIndex >= 0){
			current= this.fTimespans[currentIndex];
			if (forward) {
				if (current.getStart().afterEq(earliestStart) || current.getEnd().after(earliestStart)) 
					break;
				currentIndex++;
			} else {
				if (current.getEnd().beforeEq(earliestStart) || current.getStart().before(earliestStart)) 
					break;
				currentIndex--;
			}
		}
		if (forward && currentIndex < this.fTimespans.length) {
			if (earliestStart.after(current.getStart())) {
				this.fCurrent= new Timespan(earliestStart, current.getEnd());
			} else {
				this.fCurrent= current;
			}
		} else if (!forward && currentIndex >= 0) {
			if (earliestStart.before(current.getEnd())) {
				this.fCurrent= new Timespan(current.getStart(), earliestStart);
			} else {
				this.fCurrent= current;
			}
		} else {
			this.fCurrent= null;
		}
		this.fCurrentIndex= currentIndex;
		this.fForward= forward;
	},

	current: function() {
		return this.fCurrent;
	},

	next: function() {
		if (this.fCurrent != null) {
			if (this.fForward && this.fCurrentIndex < this.fTimespans.length - 1) {
				this.fCurrent= this.fTimespans[++this.fCurrentIndex];
			} else if (!this.fForward && this.fCurrentIndex > 0) {
				this.fCurrent= this.fTimespans[--this.fCurrentIndex];
			} else {
				this.fCurrent= null;
			}
		}
		return this.fCurrent;
	},

	getTimespans: function() {
		return this.fTimespans;
	},

	$interfaces: {
		'com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator': true
	}
});

})();
