/******************************************************************************
 Licensed Materials - Property of IBM
 (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.ExclusionIterator");

dojo.require("com.ibm.team.apt.shared.client.internal.duration.Instant");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");

(function() {
var duration= com.ibm.team.apt.shared.client.internal.duration;
var Instant= duration.Instant;
var Timespan= duration.Timespan;

var ExclusionIterator= dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.ExclusionIterator", null, {
	"-chains-": { constructor: "manual" },

	//fWrapped: null,

	//fForward: null,

	//fCurrent: null,

	constructor: function(wrapped) {
		this.fForward= true;
		this.fWrapped= wrapped;
	},

	reset: function(earliestStart, forward) {
		this.fForward= forward;
		this.fWrapped.reset(earliestStart, forward);
		var wrappedCurrent= this.fWrapped.current();
		var begin= null;
		var end= null;
		while(wrappedCurrent != null && wrappedCurrent.contains(earliestStart)){
			begin= forward ? wrappedCurrent.getEnd() : wrappedCurrent.getStart();
			wrappedCurrent= this.fWrapped.next();
		}
		if (begin == null) {
			begin= forward ? ExclusionIterator.LOWEST : ExclusionIterator.HIGHEST;
		}
		if (wrappedCurrent != null) {
			end= forward ? wrappedCurrent.getStart() : wrappedCurrent.getEnd();
		} else {
			end= forward ? ExclusionIterator.HIGHEST : ExclusionIterator.LOWEST;
		}
		if (forward) {
			this.fCurrent= new Timespan(earliestStart.after(begin) ? earliestStart : begin, end);
		} else {
			this.fCurrent= new Timespan(end, earliestStart.before(begin) ? earliestStart : begin);
		}
	},

	current: function() {
		return this.fCurrent;
	},

	next: function() {
		if (this.fCurrent != null) {
			if (this.fForward ? this.fCurrent.getEnd() !== ExclusionIterator.HIGHEST : this.fCurrent.getStart() !== ExclusionIterator.LOWEST) {
				var wrappedLast= this.fWrapped.current();
				var wrappedNext= this.fWrapped.next();
				if (this.fForward) {
					this.fCurrent= new Timespan(wrappedLast.getEnd(), wrappedNext != null ? wrappedNext.getStart() : ExclusionIterator.HIGHEST);
				} else {
					this.fCurrent= new Timespan(wrappedNext != null ? wrappedNext.getEnd() : ExclusionIterator.LOWEST, wrappedLast.getStart());
				}
			} else {
				this.fCurrent= null;
			}
		}
		return this.fCurrent;
	},

	$interfaces: {
		'com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator': true
	}
});

ExclusionIterator.LOWEST= Instant.time(1);
ExclusionIterator.HIGHEST= Instant.time(Math.pow(2, 52));

})();
