/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2010, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.AssignmentIterator");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.shared.client.internal.duration.Timespan");
dojo.require("com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var internal= com.ibm.team.apt.shared.client.internal;
var Timespan= internal.duration.Timespan;
var Assignment= internal.scheduler.time.Assignment;

dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.AssignmentIterator", null, {
	"-chains-": { constructor: "manual" },

	//fCurrent: null,

	//fRest: null,

	fCurrentAssignment: 0,

	fLastAssignment: 0,

	//fAssignments: null,

	//fWrapper: null,

	//fForward: null,

	constructor: function(wrapper, assignments) {
		if (!(wrapper != null && assignments != null && assignments.length > 0)) Assert.fail("wrapper != null && assignments != null && assignments.length > 0", "AssignmentIterator:31");
		this.fWrapper= wrapper;
		assignments.sort(function(left, right) {
			return left.getStart().compareTo(right.getStart());
		});
		for (var i= 1; i < assignments.length; i++){
			var previous= assignments[i - 1];
			var current= assignments[i];
			if (previous.getStart().eq(current.getStart()) && previous.getEnd().eq(current.getEnd())) {
				assignments[i]= assignments[i - 1];
			} else if (previous.getEnd().after(current.getStart())) {
				if (previous.getEnd().after(current.getEnd())) {
					assignments[i]= assignments[i - 1];
				} else {
					assignments[i]= new Assignment(previous.getEnd(), current.getEnd(), current.getAssignment());
				}
			}
		}
		this.fAssignments= [];
		this.fAssignments.push(assignments[0]);
		for (var i= 1; i < assignments.length; i++){
			var current= assignments[i];
			if (current !== this.fAssignments[this.fAssignments.length - 1]) {
				this.fAssignments.push(current);
			}
		}
		var maxDate= assignments[0].getEnd();
		this.fLastAssignment= 0;
		for (var i= 0; i < this.fAssignments.length; i++){
			var current= this.fAssignments[i];
			if (maxDate.before(current.getEnd())) {
				maxDate= current.getEnd();
				this.fLastAssignment= i;
			}
		}
	},

	reset: function(earliestStart, forward) {
		this.fForward= forward;
		var index= this.findIndex(earliestStart, forward);
		this.fCurrentAssignment= index;
		this.fRest= null;
		var assignment= this.fAssignments[index];
		var resetInstant= earliestStart;
		if (forward) {
			if (earliestStart.before(assignment.getStart())) {
				resetInstant= assignment.getStart();
			}
		} else {
			if (earliestStart.after(assignment.getEnd())) {
				resetInstant= assignment.getEnd();
			}
		}
		this.fWrapper.reset(resetInstant, forward);
		this.fCurrent= this.fWrapper.current();
	},

	current: function() {
		return this.fCurrent;
	},

	next: function() {
		if (this.fCurrent != null) {
			this.fCurrent= this.computeNext();
		}
		return this.fCurrent;
	},

	nextForWorkTime: function() {
		var tempCurrent= this.next();
		if (!this.fAssignments[this.fLastAssignment].endsAfter(tempCurrent.getEnd())) {
			tempCurrent= null;
		}
		return tempCurrent;
	},

	getAssignmentForWorkTime: function() {
		var tempAssignment= this.getAssignment();
		if (!this.fAssignments[this.fLastAssignment].endsAfter(this.fCurrent.getEnd())) {
			tempAssignment= 0;
		}
		return tempAssignment;
	},

	getAssignment: function() {
		return this.fAssignments[this.fCurrentAssignment].getAssignment();
	},

	computeNext: function() {
		var next= this.fRest == null ? this.fWrapper.next() : this.fRest;
		var assignment= this.fAssignments[this.fCurrentAssignment];
		do {
			if (assignment.containsTimespan(next) || (this.fForward && this.fCurrentAssignment === this.fAssignments.length - 1) || (!this.fForward && this.fCurrentAssignment === 0)) {
				this.fRest= null;
				return next;
			} else {
				if (this.fForward) {
					if (next.getStart().afterEq(assignment.getEnd())) {
						this.fCurrentAssignment= this.findIndex(next.getStart(), true);
						assignment= this.fAssignments[this.fCurrentAssignment];
						this.fWrapper.reset(assignment.getStart(), true);
						next= this.fWrapper.current();
					} else {
						var result= new Timespan(next.getStart(), assignment.getEnd());
						this.fRest= new Timespan(assignment.getEnd(), next.getEnd());
						return result;
					}
				} else {
					if (next.getEnd().before(assignment.getStart())) {
						this.fCurrentAssignment= this.findIndex(next.getEnd(), false);
						assignment= this.fAssignments[this.fCurrentAssignment];
						this.fWrapper.reset(assignment.getEnd(), false);
						next= this.fWrapper.current();
					} else {
						var result= new Timespan(assignment.getStart(), next.getEnd());
						this.fRest= new Timespan(next.getStart(), assignment.getStart());
						return result;
					}
				}
			}
		} while(this.fCurrentAssignment > 0 && this.fCurrentAssignment < this.fAssignments.length - 1)
		return next;
	},

	findIndex: function(when, forward) {
		var low= 0;
		var high= this.fAssignments.length - 1;
		var mid= 0;
		while(low <= high){
			mid= (low + high) >> 1;
			var assignment= this.fAssignments[mid];
			if (assignment.contains(when)) {
				return mid;
			} else if (assignment.getStart().after(when)) {
				high= mid - 1;
			} else {
				if (!(assignment.getEnd().compareTo(when) === 0 || assignment.getEnd().before(when))) Assert.fail("assignment.getEnd().compareTo(when) === 0 || assignment.getEnd().before(when)", "AssignmentIterator:182");
				low= mid + 1;
			}
		}
		if (forward) {
			return Math.min(low, this.fAssignments.length - 1);
		} else {
			return Math.max(low - 1, 0);
		}
	},

	$interfaces: {
		'com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator': true
	}
});

})();
