/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2012, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("dojo.date");

(function() {
var Assert= com.ibm.jdojo.util.Assert;

dojo.declare("com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment", null, {
	"-chains-": { constructor: "manual" },

	//fStartDate: null,

	//fEndDate: null,

	fAssignment: 0,

	constructor: function(startDate, endDate, assignment) {
		if (!(startDate != null && endDate != null && assignment >= 0 && assignment <= 1)) Assert.fail("startDate != null && endDate != null && assignment >= 0 && assignment <= 1", "Assignment:26");
		this.fStartDate= startDate;
		this.fEndDate= endDate;
		this.fAssignment= assignment;
	},

	getStart: function() {
		return this.fStartDate;
	},

	getEnd: function() {
		return this.fEndDate;
	},

	getAssignment: function() {
		return this.fAssignment;
	},

	endsAfter: function(instant) {
		return (this.fEndDate.after(instant) || this.isSameDay(this.fEndDate, instant));
	},

	startsBefore: function(instant) {
		return (this.fStartDate.before(instant) || this.isSameDay(this.fStartDate, instant));
	},

	contains: function(instant) {
		return this.endsAfter(instant) && this.startsBefore(instant);
	},

	containsTimespan: function(timespan) {
		return this.endsAfter(timespan.getEnd()) && this.startsBefore(timespan.getStart());
	},

	/**
	 * // The assignment time is always set to 00 hours and the time span hours will never be 00. 
		// Hence it will always skip the boundaries. To avoid that we will check if it is the same day as well.
	 * @param a
	 * @param b
	 * @return
	 */
	isSameDay: function(a, b) {
		return dojo.date.compare(new Date(a.getTime()), new Date(b.getTime()), "date") === 0;
	}
});

})();
