/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressLabelProvider");

dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");
dojo.require("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider");
dojo.require("dojo.i18n");
dojo.require("dojo.number");
dojo.require("dojo.string");

dojo.requireLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

(function() {
var ProgressMessages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

var apt= com.ibm.team.apt;
var Unit= apt.api.common.planning.IProgressInformation.Unit;
var AbstractProgressLabelProvider= apt.shared.client.internal.progress.AbstractProgressLabelProvider;
var Description= AbstractProgressLabelProvider.Description;

dojo.declare("com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressLabelProvider", AbstractProgressLabelProvider, {

	//__complexityUnit: null,

	//__complexityLabel: null,

	constructor: function(options) {
		this.inherited(arguments, [options]);
		if (options != null) {
			this.__complexityLabel= options.getParameter("complexityLabel");
			this.__complexityUnit= options.getParameter("complexityUnit");
		}
	},

	hasUnitsConfigured: function() {
		return this.__complexityUnit != null && this.__complexityLabel != null;
	},

	getSizingUnit: function() {
		return Unit.COMPLEXITY;
	},

	getMessage: function(element) {
		if (this.hasUnitsConfigured()) {
			if (element == null) {
				return ProgressMessages.progress_computing;
			} else if (element.getCount() === 0) {
				return ProgressMessages.progress_noWork;
			} else if (element.getEstimatedCount(Unit.COMPLEXITY) === 0 && element.getOpenCount() > 0) {
				return ProgressMessages.progress_noWorkEstimated;
			} else {
				return null;
			}
		}
		return ProgressMessages.complexity_attributeNotDefined;
	},

	getProgressText: function(element) {
		var result= dojo.string.substitute(ProgressMessages.complexity_progress, [element.getStepsDone(Unit.COMPLEXITY), element.getSteps(Unit.COMPLEXITY), this._getComplexityUnit()]);
		if (this._showLabels) {
			result= dojo.string.substitute(ProgressMessages.complexity_progressLabel, [result]);
		}
		return result;
	},

	getAllDescriptions: function(element) {
		if (!this.hasUnitsConfigured()) 
			return null;
		var descriptions= [];
		var description= this.getComplexityUnitsCompletedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		description= this.getComplexityUnitsExpectedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		if (element.getSteps(Unit.TIME) !== 0) {
			description= this.getWorkCompletedText(element);
			if (description != null) {
				descriptions.push(description);
			}
			description= this.getWorkExpectedText(element);
			if (description != null) {
				descriptions.push(description);
			}
		}
		description= this.getItemsEstimatedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		description= this.getItemsCompletedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		return descriptions;
	},

	getConfigurationMissingMessage: function() {
		if (!this.hasUnitsConfigured()) {
			var lines= [];
			lines.push("<span class=\"header\">" + ProgressMessages.complexity_tooltipNotConfiguredTitle + "</span>");
			lines.push(ProgressMessages.complexity_tooltipNotConfiguredMessage);
			return lines.join("<br />");
		}
		return null;
	},

	getTooltipText: function(element) {
		if (this.hasUnitsConfigured()) {
			var descriptions= [];
			descriptions.push(this.getComplexityUnitsCompletedText(element));
			descriptions.push(this.getComplexityUnitsExpectedText(element));
			if (element.getSteps(Unit.TIME) !== 0) {
				descriptions.push(this.getWorkCompletedText(element));
				descriptions.push(this.getWorkExpectedText(element));
			}
			descriptions.push(this.getItemsEstimatedText(element));
			descriptions.push(this.getItemsCompletedText(element));
			var lines= [];
			lines.push("<span class=\"header\">" + ProgressMessages.progress_tooltipTitle + "</span>");
			this.renderDescriptionsAsTable(descriptions, lines);
			return dojo.string.substitute("<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", [ lines.join("\n") ]) ;
		} else {
			return this.getConfigurationMissingMessage();
		}
	},

	getComplexityUnitsCompletedText: function(element) {
		var description= new Description();
		description.label= dojo.string.substitute(ProgressMessages.complexity_tooltipDoneLabel, [this._getComplexityLabel()]);
		description.value= dojo.string.substitute(ProgressMessages.complexity_tooltipDoneValue, [dojo.number.format(element.getStepsDone(Unit.COMPLEXITY)), dojo.number.format(element.getSteps(Unit.COMPLEXITY))]);
		return description;
	},

	getComplexityUnitsExpectedText: function(element) {
		if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {
			var dir= this.getDeltaDirection(element);
			var deltaMessage= dir > 0 ? ProgressMessages.complexity_tooltipAhead : (dir < 0 ? ProgressMessages.complexity_tooltipBehind : ProgressMessages.complexity_tooltipOnTrack);
			var delta= dojo.string.substitute(deltaMessage, [Math.abs(this._round(element.getStepsDoneDelta(Unit.COMPLEXITY), 2)), this._getComplexityUnit()]);
			var description= new Description();
			description.label= dojo.string.substitute(ProgressMessages.complexity_tooltipExpectedDoneLabel, [this._getComplexityLabel()]);
			description.value= dojo.string.substitute(ProgressMessages.complexity_tooltipExpectedDoneValue, [Math.round(element.getStepsDoneExpected(Unit.COMPLEXITY)), delta]);
			return description;
		}
		return null;
	},

	getItemsEstimatedText: function(element) {
		if (!element.isAllWorkDone()) {
			var description= new Description();
			description.label= ProgressMessages.complexity_tooltipItemsEstimatedLabel;
			description.value= dojo.string.substitute(ProgressMessages.complexity_tooltipItemsEstimatedValue, [Math.round(element.getQualityOfPlanning(Unit.COMPLEXITY) * 100)]);
			return description;
		}
		return null;
	},

	getItemsCompletedText: function(element) {
		var description= new Description();
		description.label= ProgressMessages.complexity_tooltipItemsCompletedLabel;
		if (this.hasUnitsConfigured()) {
			if (!element.isAllWorkDone()) {
				description.value= dojo.string.substitute(ProgressMessages.complexity_tooltipItemsCompletedValue, [element.getCloseCount(), element.getCount(), Math.round(element.getClosedRatio() * 100)]);
			} else {
				description.value= dojo.string.substitute(ProgressMessages.complexity_tooltipItemsCompletedValue, [ProgressMessages.complexity_tooltipItemsCompletedAll, element.getCount(), 100]);
			}
		}
		return description;
	},

	getUnitsLabel: function(unit) {
		if (this.hasUnitsConfigured()) {
			return this._getComplexityLabel();
		} else {
			return ProgressMessages.complexity_tooltipNotConfiguredMessage;
		}
	},

	getUnitsShortLabel: function(unit) {
		if (this.hasUnitsConfigured()) {
			return this._getComplexityUnit();
		} else {
			return ProgressMessages.complexity_tooltipNotConfiguredMessage;
		}
	},

	_round: function(d, digits) {
		var fac= Math.pow(10, digits);
		return Math.round(d * fac) / fac;
	},

	_getComplexityLabel: function() {
		return this.__complexityLabel != null ? this.__complexityLabel : "";
	},

	_getComplexityUnit: function() {
		return this.__complexityUnit != null ? this.__complexityUnit : "";
	}
});

})();
