/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2007, 2023. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider2");

dojo.require("com.ibm.jdojo.lang.RuntimeException");
dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");
dojo.require("com.ibm.team.apt.api.common.workitem.WorkItemAttributeType");
dojo.require("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider");
dojo.require("dojo.i18n");
dojo.require("dojo.number");
dojo.require("dojo.string");

dojo.requireLocalization("com.ibm.team.apt.shared.client.internal.progress", "Messages");

(function() {
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal.progress", "Messages");

var RuntimeException= com.ibm.jdojo.lang.RuntimeException;
var apt= com.ibm.team.apt;
var common= apt.api.common;
var Unit= common.planning.IProgressInformation.Unit;
var WorkItemAttributeType= common.workitem.WorkItemAttributeType;
var AbstractProgressLabelProvider= apt.shared.client.internal.progress.AbstractProgressLabelProvider;
var Description= AbstractProgressLabelProvider.Description;
var string= dojo.string;

var ProgressLabelProvider2= dojo.declare("com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider2", AbstractProgressLabelProvider, {

	//fForTopLevelWorkItemType: null,

	//fComplexityLabel: null,

	//fComplexityUnit: null,

	//fComplexityType: null,

	constructor: function(options) {
		this.inherited(arguments, [options]);
		this.fForTopLevelWorkItemType= this.getParameterValue(options, "topLevelWorkItemType", String(false)) === String(true);
		this.fComplexityLabel= this.getParameterValue(options, "complexityLabel", ProgressLabelProvider2.EMPTY);
		this.fComplexityUnit= this.getParameterValue(options, "complexityUnit", ProgressLabelProvider2.EMPTY);
		this.fComplexityType= this.getParameterValue(options, "type", ProgressLabelProvider2.EMPTY);
	},

	getParameterValue: function(option, key, defaultValue) {
		if (option == null) 
			return defaultValue;
		var value= option.getParameter(key);
		if (value == null) 
			value= defaultValue;
		return value;
	},

	getFillLevel: function(element) {
		return ProgressLabelProvider2.avg(this._getFillLevelForUnit(Unit.COMPLEXITY, element), this._getFillLevelForUnit(Unit.TIME, element));
	},

	getDoneRange: function(element) {
		var rangeTime= this._getDoneRangeForUnit(Unit.TIME, element);
		if (!this.mentionComplexity(element)) 
			return rangeTime;
		var rangeComplexity= this._getDoneRangeForUnit(Unit.COMPLEXITY, element);
		if (element.getStepsDone(Unit.TIME) === 0 && element.getStepsLeft(Unit.TIME) === 0) {
			return [0, rangeComplexity[1]];
		} else {
			return [0, ProgressLabelProvider2.avg(rangeComplexity[1], rangeTime[1])];
		}
	},

	getProjectionRange: function(element) {
		if (element == null || !element.isRealTimeSpecified()) {
			return [-1, -1];
		}
		var stepsProgress= this.mentionComplexity(element) ? element.getStepsProgress(Unit.COMPLEXITY) : element.getStepsProgress(Unit.TIME);
		var ratio= stepsProgress - element.getRealTimeProgress();
		if (ratio > 0) {
			return [stepsProgress - ratio, ratio];
		} else {
			return [stepsProgress, -ratio];
		}
	},

	getDeltaDirection: function(element) {
		if (element == null || !element.isRealTimeSpecified()) {
			return 0;
		}
		return (this.mentionComplexity(element) ? element.getStepsProgress(Unit.COMPLEXITY) : element.getStepsProgress(Unit.TIME)) - element.getRealTimeProgress();
	},

	getMessage: function(element) {
		if (element == null) 
			return ProgressLabelProvider2.EMPTY;
		if (!this.hasUnitsConfigured()) 
			return Messages.DualProgressLabelProvider_MSG_COMPLEXITY_MISSING;
		if (element.getCount() === 0) 
			return Messages.DualProgressLabelProvider_MSG_NO_WORK;
		if (element.getOpenCount() > 0 && element.getEstimatedCount(Unit.TIME) + element.getEstimatedCount(Unit.COMPLEXITY) === 0) 
			return Messages.DualProgressLabelProvider_MSG_NO_WORK_ESTIMATED;
		return null;
	},

	getQualityText: function(element) {
		var result= Messages.DualProgressLabelProvider_DEFAULT;
		if (element != null && element.getCount() !== 0 && !element.isAllWorkDone()) {
			var estimatedCountComplexity= element.getEstimatedCount(Unit.COMPLEXITY);
			var estimatedCountTime= element.getEstimatedCount(Unit.TIME);
			var value;
			if (estimatedCountComplexity === 0 ^ estimatedCountTime === 0) {
				value= (estimatedCountComplexity !== 0 ? element.getQualityOfPlanning(Unit.COMPLEXITY) : element.getQualityOfPlanning(Unit.TIME)) * 100;
			} else {
				value= (element.getQualityOfPlanning(Unit.COMPLEXITY) + element.getQualityOfPlanning(Unit.TIME)) * 50;
			}
			result= string.substitute(Messages.DualProgressLabelProvider_QUALITY_PATTERN_PERCENT, [Math.round(value) ]);
		}
		if (this._showLabels) {
			result= string.substitute(Messages.DualProgressLabelProvider_QUALITY_PATTERN_LABEL, [result ]);
		}
		return result;
	},

	/**
	 * @return Something like <code>2/3h | 4/8pts</code>
	 */
	getProgressText: function(element) {
		if (element == null) 
			return Messages.DualProgressLabelProvider_PROGRESS_DEFAULT;
		var complexityPart= null;
		var timePart= null;
		if (this.mentionComplexity(element)) {
			if ((this.fComplexityType === WorkItemAttributeType.DURATION.name)) {
				complexityPart= string.substitute(Messages.DualProgressLabelProvider_PROGRESS_PATTERN_COMPLEXITY, [this._toHours(element.getStepsDone(Unit.COMPLEXITY)) , this._toHours(element.getSteps(Unit.COMPLEXITY)), this.getUnitsShortLabel(Unit.COMPLEXITY)]);
			} else {
				complexityPart= string.substitute(Messages.DualProgressLabelProvider_PROGRESS_PATTERN_COMPLEXITY, [element.getStepsDone(Unit.COMPLEXITY) , element.getSteps(Unit.COMPLEXITY), this.getUnitsShortLabel(Unit.COMPLEXITY)]);
			}
		}
		if (element.getSteps(Unit.TIME) > 0) {
			timePart= string.substitute(Messages.DualProgressLabelProvider_PROGRESS_PATTERN_TIME, [this._toHours(element.getStepsDone(Unit.TIME)) , this._toHours(element.getSteps(Unit.TIME)), this.getUnitsShortLabel(Unit.TIME)]);
		}
		if (complexityPart != null ^ timePart != null) {
			return complexityPart != null ? complexityPart : timePart;
		} else if (complexityPart != null && timePart != null) {
			return string.substitute(Messages.DualProgressLabelProvider_PROGRESS_PATTERN_OVERALL, [complexityPart , timePart]);
		}
		return Messages.DualProgressLabelProvider_PROGRESS_DEFAULT;
	},

	getTooltipText: function(element) {
		if (element == null) 
			return ProgressLabelProvider2.EMPTY;
		var lines= [];
		lines.push(string.substitute("<span class=\"header\">${0}</span>", [Messages.DualProgressLabelProvider_TITLE ]));
		this.renderDescriptionsAsTable(this.getAllDescriptions(element), lines);
		return dojo.string.substitute("<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", [ lines.join("\n") ]) ;
	},

	getAllDescriptions: function(element) {
		var result= [];
		if (element != null) {
			var desc;
			if (this.mentionComplexity(element)) {
				ProgressLabelProvider2.pushIfNotNull(result, this.getWorkProgressTextForUnit(Unit.COMPLEXITY, element));
				ProgressLabelProvider2.pushIfNotNull(result, this.getWorkExpectedTextForUnit(Unit.COMPLEXITY, element));
			}
			ProgressLabelProvider2.pushIfNotNull(result, this.getWorkProgressTextForUnit(Unit.TIME, element));
			ProgressLabelProvider2.pushIfNotNull(result, this.getWorkExpectedTextForUnit(Unit.TIME, element));
			if (this.mentionComplexity(element)) {
				ProgressLabelProvider2.pushIfNotNull(result, this.getQualityTextForUnit(Unit.COMPLEXITY, element));
			}
			ProgressLabelProvider2.pushIfNotNull(result, this.getQualityTextForUnit(Unit.TIME, element));
			desc= new Description();
			desc.label= Messages.DualProgressLabelProvider_COMPLETED_TITLE;
			var oldShowLabel= this._showLabels;
			this._showLabels= false;
			try {
				desc.value= string.substitute(Messages.DualProgressLabelProvider_COMPLETED_PATTERN, [element.getCloseCount() , element.getCount(), this.getOpenCloseText(element)]);
			} finally {
				this._showLabels= oldShowLabel;
			}
			ProgressLabelProvider2.pushIfNotNull(result, desc);
		}
		return result;
	},

	getOpenCloseText: function(element) {
		var result= Messages.DualProgressLabelProvider_OPEN_CLOSE_DEFAULT;
		if (element != null) {
			result= string.substitute(Messages.DualProgressLabelProvider_OPEN_CLOSE_PATTERN, [Math.round(element.getClosedRatio() * 100) ]);
		}
		if (this._showLabels) {
			result= string.substitute(Messages.DualProgressLabelProvider_CLOSED_TITLE, [result ]);
		}
		return result;
	},

	getConfigurationMissingMessage: function() {
		if (!this.hasUnitsConfigured()) {
			var lines= [];
			lines.push(dojo.string.substitute("<span class=\"header\">${0}</span>", [ Messages.DualProgressLabelProvider_MSG_COMPLEXITY_TITLE ]) );
			lines.push(Messages.DualProgressLabelProvider_MSG_COMPLEXITY_DETAILS);
			return lines.join("<br />");
		}
		return null;
	},

	hasUnitsConfigured: function() {
		return this.fComplexityLabel != null && this.fComplexityUnit != null;
	},

	mentionComplexity: function(element) {
		return this.fForTopLevelWorkItemType || element.getSteps(Unit.COMPLEXITY) > 0;
	},

	getQualityTextForUnit: function(unit, element) {
		var desc= new Description();
		desc.label= string.substitute(Messages.DualProgressLabelProvider_QUALITY_UNIT_PATTERN, [this.getUnitsLabel(unit) ]);
		desc.value= this._getQualityTextForUnit(unit, element);
		return desc;
	},

	getWorkProgressTextForUnit: function(unit, element) {
		var desc= new Description();
		desc.label= string.substitute(Messages.DualProgressLabelProvider_PATTERN_DONE, [this.getUnitsLabel(unit) ]);
		if ((this.fComplexityType === WorkItemAttributeType.DURATION.name)) {
			desc.value= string.substitute(Messages.DualProgressLabelProvider_PATTERN_PROGRESS, [this._toHours(element.getStepsDone(unit)) , this._toHours(element.getSteps(unit)), Math.round(element.getStepsProgress(unit) * 100)]);
		} else {
			desc.value= string.substitute(Messages.DualProgressLabelProvider_PATTERN_PROGRESS, [this.formatByUnit(unit, element.getStepsDone(unit)) , this.formatByUnit(unit, element.getSteps(unit)), Math.round(element.getStepsProgress(unit) * 100)]);
		}
		return desc;
	},

	getWorkExpectedTextForUnit: function(unit, element) {
		if (element == null || !element.isRealTimeSpecified()) 
			return null;
		var dir= this._getDeltaDirectionForUnit(unit, element);
		var pattern= dir > 0 ? Messages.DualProgressLabelProvider_AHEAD : dir < 0 ? Messages.DualProgressLabelProvider_BEHIND : Messages.DualProgressLabelProvider_ON_TIME;
		var desc= new Description();
		desc.label= string.substitute(Messages.DualProgressLabelProvider_EXPECTED_LABEL, [this.getUnitsLabel(unit) ]);
		if ((this.fComplexityType === WorkItemAttributeType.DURATION.name)) {
			var message= string.substitute(pattern, [this._toHours(Math.abs(element.getStepsDoneDelta(unit))) , this.getUnitsShortLabel(unit)]);
			desc.value= dojo.string.substitute(Messages.DualProgressLabelProvider_EXPECTED_PATTERN, [this._toHours(element.getStepsDoneExpected(unit)), message]);
		} else {
			var message= string.substitute(pattern, [this.formatByUnit(unit, Math.round(Math.abs(element.getStepsDoneDelta(unit)))) , this.getUnitsShortLabel(unit)]);
			desc.value= dojo.string.substitute(Messages.DualProgressLabelProvider_EXPECTED_PATTERN, [this.formatByUnit(unit, element.getStepsDoneExpected(unit)), message]);
		}
		return desc;
	},

	formatByUnit: function(unit, value) {
		switch(unit) {
			case Unit.TIME:
				return this._toHours(value);
			case Unit.COMPLEXITY:
				return dojo.number.format(value);
		}
		return String(value);
	},

	getUnitsLabel: function(unit) {
		return unit === Unit.COMPLEXITY ? this.fComplexityLabel : Messages.DualProgressLabelProvider_TIME_LABEL_LONG;
	},

	getUnitsShortLabel: function(unit) {
		return unit === Unit.COMPLEXITY ? this.fComplexityUnit : Messages.DualProgressLabelProvider_TIME_LABEL_SHORT;
	},

	getSizingUnit: function() {
		throw new RuntimeException("not supported");
	}
});

ProgressLabelProvider2.EMPTY= "";
ProgressLabelProvider2.pushIfNotNull= function(array, element) {
	if (element != null) {
		array.push(element);
	}
};
ProgressLabelProvider2.avg= function( /*, values... */ ) {
	var values= Array.prototype.slice.call(arguments, 0);
	var result= 0;
	for (var i= 0; i < values.length; i++){
		result+= values[i];
	}
	return result / values.length;
};

})();
