/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider");

dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");
dojo.require("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider");
dojo.require("dojo.i18n");
dojo.require("dojo.string");

dojo.requireLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

(function() {
var ProgressMessages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

var apt= com.ibm.team.apt;
var Unit= apt.api.common.planning.IProgressInformation.Unit;
var AbstractProgressLabelProvider= apt.shared.client.internal.progress.AbstractProgressLabelProvider;
var Description= AbstractProgressLabelProvider.Description;

var ProgressLabelProvider= dojo.declare("com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider", AbstractProgressLabelProvider, {

	constructor: function(options) {
		this.inherited(arguments, [options]);
	},

	getSizingUnit: function() {
		return Unit.TIME;
	},

	getUnitsLabel: function(unit) {
		return ProgressLabelProvider.SIZE_UNIT_LABEL;
	},

	getUnitsShortLabel: function(unit) {
		return "ms";
	},

	getMessage: function(element) {
		if (element == null) {
			return ProgressMessages.progress_computing;
		} else if (element.getCount() === 0) {
			return ProgressMessages.progress_noWork;
		} else if (element.getEstimatedCount(Unit.TIME) === 0 && element.getOpenCount() > 0) {
			return ProgressMessages.progress_noWorkEstimated;
		}
		return null;
	},

	getProgressText: function(element) {
		var result= "";
		if (element != null && element.getCount() !== 0) {
			var direction= this._getDeltaDirectionForUnit(Unit.TIME, element);
			result+= this._toHours(element.getStepsDone(Unit.TIME));
			result+= "/";
			result+= this._toHours(element.getSteps(Unit.TIME));
			if (element.isRealTimeSpecified()) {
				result+= " | ";
				result+= "<span class=\"" + (direction > 0 ? "ahead" : direction < 0 ? "behind" : "none") + "\">";
				if (direction > 0) 
					result+= "+";
				result+= this._toHours(element.getStepsDoneDelta(Unit.TIME));
				result+= "</span>";
			}
			result+= ProgressMessages.progress_ProgressHours;
		} else {
			result+= ProgressMessages.progress_ProgressNone;
		}
		if (this._showLabels) {
			result= dojo.string.substitute(ProgressMessages.progress_ProgressLabel, [result]);
		}
		return result;
	},

	getTooltipText: function(element) {
		var descriptions= [];
		descriptions.push(this.getWorkCompletedText(element));
		descriptions.push(this.getWorkExpectedText(element));
		descriptions.push(this.getItemsEstimatedText(element));
		descriptions.push(this.getItemsCompletedText(element));
		var lines= [];
		lines.push("<span class=\"header\">" + ProgressMessages.progress_tooltipTitle + "</span>");
		this.renderDescriptionsAsTable(descriptions, lines);
		return dojo.string.substitute("<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", [ lines.join("\n") ]) ;
	},

	getConfigurationMissingMessage: function() {
		return null;
	},

	getAllDescriptions: function(element) {
		var descriptions= [];
		var description= this.getWorkCompletedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		description= this.getWorkExpectedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		description= this.getItemsEstimatedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		description= this.getItemsCompletedText(element);
		if (description != null) {
			descriptions.push(description);
		}
		return descriptions;
	},

	getItemsEstimatedText: function(element) {
		if (!element.isAllWorkDone()) {
			var description= new Description();
			description.label= ProgressMessages.progress_tooltipItemsEstimatedLabel;
			description.value= dojo.string.substitute(ProgressMessages.progress_tooltipItemsEstimatedValue, [Math.round(element.getQualityOfPlanning(Unit.TIME) * 100)]);
			return description;
		}
		return null;
	},

	getItemsCompletedText: function(element) {
		var description= new Description();
		description.label= ProgressMessages.progress_tooltipItemsCompletedLabel;
		if (!element.isAllWorkDone()) {
			description.value= dojo.string.substitute(ProgressMessages.progress_tooltipItemsCompletedValue, [element.getCloseCount(), element.getCount(), Math.round(element.getClosedRatio() * 100)]);
		} else {
			description.value= dojo.string.substitute(ProgressMessages.progress_tooltipItemsCompletedValue, [ProgressMessages.progress_tooltipItemsCompletedAll, element.getCount(), 100]);
		}
		return description;
	}
});

ProgressLabelProvider.SIZE_UNIT_LABEL= "milliseconds";

})();
