// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.ProgressInformation");

dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");

(function() {
var Unit= com.ibm.team.apt.api.common.planning.IProgressInformation.Unit;

dojo.declare("com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", null, {
	"-chains-": { constructor: "manual" },

	//fStepsDone: null,

	//fStepsLeft: null,

	fRealTimeDone: 0,

	fRealTimeLeft: 0,

	//fOpenCount: null,

	//fCloseCount: null,

	//fEstimatedCount: null,

	//fDescendantsItemIds: null,

	constructor: function(realTimeDone, realTimeLeft) {
		this.fStepsDone= [0, 0];
		this.fStepsLeft= [0, 0];
		this.fOpenCount= 0;
		this.fCloseCount= 0;
		this.fEstimatedCount= [0, 0];
		this.fDescendantsItemIds= [];
		if (realTimeDone === undefined) 
			realTimeDone= -1;
		if (realTimeLeft === undefined) 
			realTimeLeft= -1;
		this.fRealTimeDone= realTimeDone;
		this.fRealTimeLeft= realTimeLeft;
	},

	getIndex: function(unit) {
		if (unit === Unit.COMPLEXITY) {
			return 1;
		}
		return 0;
	},

	deltaStepsDone: function(unit, delta) {
		var index= this.getIndex(unit);
		this.fStepsDone[index]= this.safeDelta(this.fStepsDone[index], delta);
	},

	deltaStepsLeft: function(unit, delta) {
		var index= this.getIndex(unit);
		this.fStepsLeft[index]= this.safeDelta(this.fStepsLeft[index], delta);
	},

	deltaRealTimeDone: function(delta) {
		if (this.fRealTimeDone !== delta) {
			this.fRealTimeDone= this.safeDelta(Math.max(0, this.fRealTimeDone), delta);
		}
	},

	deltaRealTimeLeft: function(delta) {
		if (this.fRealTimeLeft !== delta) {
			this.fRealTimeLeft= this.safeDelta(Math.max(0, this.fRealTimeLeft), delta);
		}
	},

	deltaOpenCount: function(delta) {
		this.fOpenCount= ((this.safeDelta(this.fOpenCount, delta))|0);
	},

	deltaCloseCount: function(delta) {
		this.fCloseCount= ((this.safeDelta(this.fCloseCount, delta))|0);
	},

	deltaEstimateCount: function(unit, delta) {
		var index= this.getIndex(unit);
		this.fEstimatedCount[index]= ((this.safeDelta(this.fEstimatedCount[index], delta))|0);
	},

	safeDelta: function(value, delta) {
		return Math.max(0, value + delta);
	},

	isAllWorkDone: function() {
		return this.fCloseCount > 0 && this.fOpenCount === 0;
	},

	isRealTimeSpecified: function() {
		return this.fRealTimeDone !== -1 || this.fRealTimeLeft !== -1;
	},

	getStepsLeft: function(unit) {
		return this.fStepsLeft[this.getIndex(unit)];
	},

	getStepsDone: function(unit) {
		return this.fStepsDone[this.getIndex(unit)];
	},

	getSteps: function(unit) {
		var index= this.getIndex(unit);
		return this.fStepsDone[index] + this.fStepsLeft[index];
	},

	getRealTimeDone: function() {
		return this.fRealTimeDone;
	},

	getRealTimeLeft: function() {
		return this.fRealTimeLeft;
	},

	getRealTime: function() {
		return this.fRealTimeDone + this.fRealTimeLeft;
	},

	getOpenCount: function() {
		return this.fOpenCount;
	},

	getCloseCount: function() {
		return this.fCloseCount;
	},

	getCount: function() {
		return this.fOpenCount + this.fCloseCount;
	},

	getEstimatedCount: function(unit) {
		return this.fEstimatedCount[this.getIndex(unit)];
	},

	getStepsDoneExpected: function(unit) {
		return this.getSteps(unit) * this.getRealTimeProgress();
	},

	getStepsDoneDelta: function(unit) {
		var stepsDone= this.getStepsDone(unit);
		var stepsLeft= this.getStepsLeft(unit);
		return (stepsDone - ((stepsDone + stepsLeft) * this.getRealTimeProgress()));
	},

	getStepsProgress: function(unit) {
		var stepsDone= this.getStepsDone(unit);
		var stepsLeft= this.getStepsLeft(unit);
		var divisor= stepsDone + stepsLeft;
		return divisor <= 0 ? 1 : stepsDone / divisor;
	},

	getRealTimeProgress: function() {
		var divisor= this.fRealTimeDone + this.fRealTimeLeft;
		return divisor <= 0 ? 0 : this.fRealTimeDone / divisor;
	},

	getClosedRatio: function() {
		if (this.getCount() === 0) {
			return 1;
		}
		return this.fCloseCount / this.getCount();
	},

	getQualityOfPlanning: function(unit) {
		if (this.fOpenCount === 0) {
			return this.fCloseCount === 0 ? 0 : 1;
		}
		return this.getEstimatedCount(unit) / this.fOpenCount;
	},

	getDescendantsItemIds: function() {
		return this.fDescendantsItemIds;
	},

	addDescendantItemId: function(descendantItemId) {
		this.fDescendantsItemIds.push(descendantItemId);
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.planning.IProgressInformation': true,
		'com.ibm.team.apt.api.common.planning.IProgressInformationDetailed': true
	}
});

})();
