/*******************************************************************************
\ * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2012, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.NewProgressComputer");

dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");
dojo.require("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressComputer");

(function() {
var apt= com.ibm.team.apt;
var Unit= apt.api.common.planning.IProgressInformation.Unit;
var AbstractProgressComputer= apt.shared.client.internal.progress.AbstractProgressComputer;

/**
 * Progress computer that computes progress for time and for the complexity units.
 */
dojo.declare("com.ibm.team.apt.shared.client.internal.progress.NewProgressComputer", AbstractProgressComputer, {

	//fDelayedChildrenLoading: null,

	constructor: function(itemAccessor, progressInformation) {
		this.inherited(arguments, [itemAccessor, progressInformation]);
	},

	setDelayedChildrenLoadingMode: function(enableDelayedChildrenLoading) {
		this.fDelayedChildrenLoading= enableDelayedChildrenLoading;
	},

	_visit: function(element) {
		if (!this.fItemAccessor.isPlanItem(element)) {
			return false;
		}
		if (this.fItemAccessor.isAuxiliaryPlanItem(element)) {
			return this.hasUnloadedChildren(element);
		}
		if (!this.fItemAccessor.isPrimaryElement(element)) {
			return this.hasUnloadedChildren(element);
		}
		this.visitForInfo(element);
		return this.handleUnloadedChildren(element);
	},

	handleUnloadedChildren: function(element) {
		if (this.hasUnloadedChildren(element) && this.updateProgressInfo(this.fItemAccessor.getProgressInformation(element))) {
			return true;
		}
		return false;
	},

	updateProgressInfo: function(progressInformation) {
		if (progressInformation != null) {
			this.fProgressInformation.deltaOpenCount(progressInformation.getOpenCount());
			this.fProgressInformation.deltaCloseCount(progressInformation.getCloseCount());
			this.fProgressInformation.deltaStepsDone(Unit.TIME, progressInformation.getStepsDone(Unit.TIME));
			this.fProgressInformation.deltaStepsLeft(Unit.TIME, progressInformation.getStepsLeft(Unit.TIME));
			this.fProgressInformation.deltaEstimateCount(Unit.TIME, progressInformation.getEstimatedCount(Unit.TIME));
			this.fProgressInformation.deltaStepsDone(Unit.COMPLEXITY, progressInformation.getStepsDone(Unit.COMPLEXITY));
			this.fProgressInformation.deltaStepsLeft(Unit.COMPLEXITY, progressInformation.getStepsLeft(Unit.COMPLEXITY));
			this.fProgressInformation.deltaEstimateCount(Unit.COMPLEXITY, progressInformation.getEstimatedCount(Unit.COMPLEXITY));
			return true;
		}
		return false;
	},

	hasUnloadedChildren: function(element) {
		return this.fDelayedChildrenLoading && this.fItemAccessor.hasUnloadedChildren(element);
	},

	visitForInfo: function(element) {
		if (this.fItemAccessor.isResolved(element)) {
			this.fProgressInformation.deltaCloseCount(1);
		} else {
			this.fProgressInformation.deltaOpenCount(1);
		}
		this.visitForTime(element);
		this.visitForComplexity(element);
	},

	visitForTime: function(element) {
		var isTopLevelItem= this.fItemAccessor.isTopLevelPlanItem(element);
		var planDuration= this.fItemAccessor.getDuration(element);
		if (planDuration != null) {
			if (this.fItemAccessor.isResolved(element)) {
				if (!isTopLevelItem) {
					this.fProgressInformation.deltaStepsDone(Unit.TIME, planDuration.getMilliseconds());
				}
			} else {
				if (!isTopLevelItem) {
					this.fProgressInformation.deltaStepsLeft(Unit.TIME, planDuration.getMilliseconds());
					this.fProgressInformation.deltaStepsDone(Unit.TIME, planDuration.getTimeSpent().getMilliseconds());
				}
				if (planDuration.isSpecified() || isTopLevelItem) {
					this.fProgressInformation.deltaEstimateCount(Unit.TIME, 1);
				}
			}
		}
	},

	visitForComplexity: function(element) {
		var isTopLevelItem= this.fItemAccessor.isTopLevelPlanItem(element);
		var storyPts= this.fItemAccessor.getComplexity(element);
		if (this.fItemAccessor.isResolved(element)) {
			if (isTopLevelItem) {
				this.fProgressInformation.deltaStepsDone(Unit.COMPLEXITY, storyPts);
			}
		} else {
			if (isTopLevelItem) {
				this.fProgressInformation.deltaStepsLeft(Unit.COMPLEXITY, storyPts);
			}
			if (!isTopLevelItem || storyPts > 0) {
				this.fProgressInformation.deltaEstimateCount(Unit.COMPLEXITY, 1);
			}
		}
	}
});

})();
