/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2010, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.planning.IProgressInformation");
dojo.require("dojo.i18n");
dojo.require("dojo.number");
dojo.require("dojo.string");

dojo.requireLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

(function() {
var ProgressMessages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal.progress", "ProgressMessages");

var Assert= com.ibm.jdojo.util.Assert;
var Unit= com.ibm.team.apt.api.common.planning.IProgressInformation.Unit;

dojo.declare("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider", null, {
	"-chains-": { constructor: "manual" },

	//_showLabels: null,

	constructor: function(options) {
		this._showLabels= true;
		if (options != null) {
			this._showLabels= ("true" === String(options.getParameter("showLabels")).toLowerCase());
		}
	},

	getOpenCloseText: function(element) {
		var result= null;
		if (element != null && !element.isAllWorkDone()) {
			result= dojo.string.substitute(ProgressMessages.progress_EstimatedPercentage, [Math.round(element.getClosedRatio() * 100)]);
		} else {
			result= ProgressMessages.progress_ClosedDone;
		}
		if (this._showLabels) {
			result= dojo.string.substitute(ProgressMessages.progress_ClosedLabel, [result]);
		}
		return result;
	},

	getSizingUnit: function() {
		Assert.isTrue(false, "Abstract method 'getSizingUnit' invoked");
	},

	getFillLevel: function(element) {
		return this._getFillLevelForUnit(this.getSizingUnit(), element);
	},

	getDoneRange: function(element) {
		return this._getDoneRangeForUnit(this.getSizingUnit(), element);
	},

	getProjectionRange: function(element) {
		return this._getProjectionRangeForUnit(this.getSizingUnit(), element);
	},

	getDeltaDirection: function(element) {
		return this._getDeltaDirectionForUnit(this.getSizingUnit(), element);
	},

	getQualityText: function(element) {
		return this._getQualityTextForUnit(this.getSizingUnit(), element);
	},

	_getDoneRangeForUnit: function(unit, element) {
		if (element == null) {
			return [0, 0];
		} else {
			var stepsProgress= element.getStepsProgress(unit);
			return [0, stepsProgress < 1 ? stepsProgress - this.__aheadRange(unit, element) : stepsProgress];
		}
	},

	_getFillLevelForUnit: function(unit, element) {
		return element != null ? element.getQualityOfPlanning(unit) : 0;
	},

	_getProjectionRangeForUnit: function(unit, element) {
		if (element != null && element.isRealTimeSpecified()) {
			var ratio= element.getStepsProgress(unit) - element.getRealTimeProgress();
			if (ratio > 0) {
				return [element.getStepsProgress(unit) - this.__aheadRange(unit, element), ratio];
			} else {
				return [element.getStepsProgress(unit), -ratio];
			}
		} else {
			return [-1, -1];
		}
	},

	_getDeltaDirectionForUnit: function(unit, element) {
		return element != null && element.isRealTimeSpecified() ? element.getStepsProgress(unit) - element.getRealTimeProgress() : 0;
	},

	_getQualityTextForUnit: function(unit, element) {
		var result= null;
		if (element != null && element.getCount() !== 0 && !element.isAllWorkDone()) {
			result= dojo.string.substitute(ProgressMessages.progress_EstimatedPercentage, [Math.round(element.getQualityOfPlanning(unit) * 100)]);
		} else {
			result= ProgressMessages.progress_EstimatedNone;
		}
		if (this._showLabels) {
			result= dojo.string.substitute(ProgressMessages.progress_EstimatedLabel, [result]);
		}
		return result;
	},

	__aheadRange: function(unit, element) {
		if (element != null && element.isRealTimeSpecified()) {
			var ratio= element.getStepsProgress(unit) - element.getRealTimeProgress();
			return Math.max(0, ratio);
		}
		return 0;
	},

	_absString: function(value) {
		if (value.charAt(0) === "-") 
			return value.substring(1);
		return value;
	},

	_hasWork: function(element) {
		return element.getCount() > 0;
	},

	_hasEstimatedWork: function(unit, element) {
		return this._hasWork(element) && element.getEstimatedCount(unit) > 0;
	},

	getWorkCompletedText: function(element) {
		var description= new Description();
		description.label= ProgressMessages.progress_tooltipWorkHoursDoneLabel;
		description.value= dojo.string.substitute(ProgressMessages.progress_tooltipWorkHoursDoneValue, [this._toHours(element.getStepsDone(Unit.TIME)), this._toHours(element.getSteps(Unit.TIME))]);
		return description;
	},

	getWorkExpectedText: function(element) {
		if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {
			var dir= this._getDeltaDirectionForUnit(Unit.TIME, element);
			var deltaMessage= dir > 0 ? ProgressMessages.progress_tooltipAhead : dir < 0 ? ProgressMessages.progress_tooltipBehind : ProgressMessages.progress_tooltipOnTime;
			var delta= dojo.string.substitute(deltaMessage, [this._toHours(Math.abs(element.getStepsDoneDelta(Unit.TIME)))]);
			var description= new Description();
			description.label= ProgressMessages.progress_tooltipExpectedWorkHoursDoneLabel;
			description.value= dojo.string.substitute(ProgressMessages.progress_tooltipExpectedWorkHoursDoneValue, [this._toHours(element.getStepsDoneExpected(Unit.TIME)), delta]);
			return description;
		}
		return null;
	},

	_toHours: function(value) {
		var n= 2;
		var fac= Math.pow(10, n);
		var neg= value < 0;
		value= Math.abs(value);
		var result= Math.round((value / (1000 * 60 * 60)) * fac) / fac;
		var fraction= result - Math.floor(result);
		result-= fraction;
		if (fraction <= 0.125) {
			fraction= 0;
		} else if (fraction > 0.125 && fraction <= 0.25) {
			fraction= 0.25;
		} else if (fraction > 0.25 && fraction <= 0.5) {
			fraction= 0.5;
		} else if (fraction > 0.5 && fraction <= 0.75) {
			fraction= 0.75;
		} else if (fraction > 0.75) {
			fraction= 1;
		}
		return dojo.number.format((result + fraction) * (neg ? -1 : 1));
	},

	renderDescriptionsAsTable: function(descriptions, lines) {
		lines.push("<table border=\"0\">");
		for (var i= 0; i < descriptions.length; i++){
			var desc= descriptions[i];
			if (desc != null) {
				lines.push(dojo.string.substitute("<tr><td class=\"label\">${0}</td><td class=\"value\">${1}</td></tr>", [desc.getLabel(), desc.getValue()]));
			}
		}
		lines.push("</table>");
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.planning.IProgressLabelProvider': true
	}
});
var Description= dojo.declare("com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider.Description", null, {
	"-chains-": { constructor: "manual" },

	//label: null,

	//value: null,

	getLabel: function() {
		return this.label;
	},

	getValue: function() {
		return this.value;
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.planning.IProgressLabelProvider.IDescription': true
	}
});

})();
