/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.internal.plancheck.EnumerationHierarchyCheck"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.plancheck.PlanCheck"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.plancheck.Problem"); //$NON-NLS-1$

dojo.require("dojo.string"); //$NON-NLS-1$
dojo.require("dojo.i18n"); //$NON-NLS-1$
dojo.requireLocalization("com.ibm.team.apt.shared.client.internal", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

(function() {

var Assert							= com.ibm.jdojo.util.Assert;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;
var PlanCheck						= com.ibm.team.apt.shared.client.plancheck.PlanCheck;
var Run								= com.ibm.team.apt.shared.client.plancheck.PlanCheck.Run;
var Problem							= com.ibm.team.apt.client.plancheck.Problem;

var bind= dojo.string.substitute;
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal", "PlanCheckMessages"); //$NON-NLS-1$ //$NON-NLS-2$

dojo.declare("com.ibm.team.apt.shared.client.internal.plancheck.EnumerationHierarchyCheck", PlanCheck, { //$NON-NLS-1$

	__attributeId: null,
	__attribute: null,
	
	constructor: function(checkDescription, plan) {
		this.__attributeId= new PlanningAttributeIdentifier(checkDescription.getParameter("attribute")); //$NON-NLS-1$
		this.__problemId= checkDescription.getParameter("problemId"); //$NON-NLS-1$
	},

	// ---- implementation -------------------------------------------------------------------------------------------------

	initialize: function() {
		this.inherited(arguments);
		this.__attribute= this._plan.findAttribute(this.__attributeId);
	},

	_includeDelta: function(delta) {
		if (delta.isChanged() && delta.getAttributeDelta(this.__attributeId))
			return true;

		if (delta.isStructuralChange())
			return true;
		
		return false;
	},

	checkElement: function(planElement, progressMonitor) {
		var runner= new Run(dojo.hitch(this, function() {
			var parentElement= planElement.getParent();
			if (parentElement instanceof PlanItem && !planElement.isResolved() && !parentElement.isResolved()) {
				var elementValue= planElement.getAttributeValue(this.__attribute);
				var parentValue= parentElement.getAttributeValue(this.__attribute);
				
				var comparison= this.__attribute.getAttributeType().compareValues(elementValue, parentValue);
				if (comparison < 0) {
					var message= bind(Messages['enumHierarchy_lowerValue'], [this.__attribute.getLabel(), parentElement.getId()]); //$NON-NLS-1$
					runner._result= [ Problem.forItemAttribute(this.__problemId, planElement, this.__attribute, message) ];
				}
			}
			return PlanCheck.Run.DONE;
		}));
		
		return runner;
	},

	__sentinel: null // terminates this class definition
});

})();
