/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2009, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute");

dojo.require("com.ibm.team.apt.api.client.IAttributeValueComparator");
dojo.require("com.ibm.team.apt.api.client.IPlanningAttributeValueSet");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator");

(function() {
var apt= com.ibm.team.apt;
var client= apt.api.client;
var IAttributeValueComparator= client.IAttributeValueComparator;
var IPlanningAttributeValueSet= client.IPlanningAttributeValueSet;
var DefaultAttributeValueComparator= apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator;

dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute", null, {
	"-chains-": { constructor: "manual" },

	//fDescription: null,

	//fPlanningClient: null,

	//fValueComparator: null,

	constructor: function(description, planningClient, planContext) {
		this.fDescription= description;
		this.fPlanningClient= planningClient;
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		future.callback(null);
	},

	unInitialize: function(planModel, planElements) {
	},

	getValue: function(receiver) {
		return receiver.defined(this);
	},

	getValueSet: function(planElement) {
		return IPlanningAttributeValueSet.EMPTY;
	},

	setValue: function(receiver, value) {
		var $this= this;
		receiver.getPlanModel().compoundChange(function(deltaBuilder) {
			var oldValue= receiver.define($this, value);
			deltaBuilder.changed(receiver, $this, oldValue, value);
			return null;
		});
	},

	getDescription: function() {
		return this.fDescription;
	},

	getId: function() {
		return this.fDescription.getId();
	},

	getAdapter: function(interfaceType) {
		if (interfaceType === IAttributeValueComparator) {
			if (this.fValueComparator == null) {
				this.fValueComparator= DefaultAttributeValueComparator.createComparator(this);
			}
			return this.fValueComparator;
		}
		return null;
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttribute': true,
		'com.ibm.team.apt.api.client.IPlanningAttributeIdentifier': true
	}
});

})();
