/****************************************************************************** 
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.RankingAttribute");

dojo.require("com.ibm.team.apt.api.client.internal.PlanningAttributeIdentifierImpl");
dojo.require("com.ibm.team.apt.api.common.planning.IPlanningAttributeDescription");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.client.SequenceValue");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute");

(function() {
var apt= com.ibm.team.apt;
var api= apt.api;
var PlanningAttributeIdentifierImpl= api.client.internal.PlanningAttributeIdentifierImpl;
var planning= api.common.planning;
var IPlanningAttributeDescription= planning.IPlanningAttributeDescription;
var PlanningAttributeType= planning.PlanningAttributeType;
var SequenceValue= apt.client.SequenceValue;
var FACTORY= SequenceValue.FACTORY;
var SharedPlanningAttribute= apt.shared.client.internal.model.attributes.SharedPlanningAttribute;

/**
 * $NON-NLS-1$
 */
var RankingAttribute= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.RankingAttribute", SharedPlanningAttribute, {

	//fSequenceAttribute: null,

	//fSequenceAttributeId: null,

	//fEnumerationAttribute: null,

	//fEnumerationAttributeId: null,

	fDirection: 0,

	constructor: function(description, planningClient, planContext) {
		this.inherited(arguments, [description, planningClient, planContext]);
		var enumerationAttributeId= description.getParameter(RankingAttribute.PARAM_ATTR);
		var direction= -1;
		if (description.getParameter(RankingAttribute.PARAM_REVERSE) != null || String(description.getParameter(RankingAttribute.PARAM_REVERSE)).toLowerCase() === "false") 
			direction= -1;
		this.fDirection= direction;
		this.fSequenceAttributeId= new PlanningAttributeIdentifierImpl(enumerationAttributeId + "." + IPlanningAttributeDescription.RANKING_SEQUENCE_ATTRIBUTE_ID_SUFFIX);
		this.fEnumerationAttributeId= new PlanningAttributeIdentifierImpl(enumerationAttributeId);
	},

	getUnranked: function(source) {
		return this.createRank(source.getEnumerationValue(), SequenceValue.NEW);
	},

	calculateRank: function(predecessor, successor, source) {
		var sourceEnum= source.getEnumerationValue();
		if (predecessor == null && successor == null) 
			return this.createRank(sourceEnum, SequenceValue.INITIAL);
		var predecessorEnum= predecessor != null ? predecessor.getEnumerationValue() : null;
		var predecessorSeq= predecessor != null ? predecessor.getSequenceValue() : null;
		var successorEnum= successor != null ? successor.getEnumerationValue() : null;
		var successorSeq= successor != null ? successor.getSequenceValue() : null;
		if (predecessorSeq != null && predecessorSeq.isNew()) 
			predecessorSeq= null;
		if (successorSeq != null && successorSeq.isNew()) 
			successorSeq= null;
		var targetEnum= null;
		var targetSeq= null;
		if (predecessor != null && successor == null) {
			targetEnum= RankingAttribute.compareEnum(sourceEnum, predecessorEnum, this.fDirection) < 0 ? predecessorEnum : sourceEnum;
			targetSeq= RankingAttribute.calculateSeq(predecessorSeq, null);
		} else if (predecessor == null && successor != null) {
			targetEnum= RankingAttribute.compareEnum(sourceEnum, successorEnum, this.fDirection) < 0 ? sourceEnum : successorEnum;
			targetSeq= RankingAttribute.calculateSeq(null, successorSeq);
		} else {
			if (predecessorEnum.getLiteralId() === successorEnum.getLiteralId()) {
				targetEnum= predecessorEnum;
				targetSeq= RankingAttribute.calculateSeq(predecessorSeq, successorSeq);
			} else if (predecessorEnum.getLiteralId() === sourceEnum.getLiteralId()) {
				targetEnum= predecessorEnum;
				targetSeq= RankingAttribute.calculateSeq(predecessorSeq, null);
			} else if (successorEnum.getLiteralId() === sourceEnum.getLiteralId()) {
				targetEnum= successorEnum;
				targetSeq= RankingAttribute.calculateSeq(null, successorSeq);
			} else {
				var predecessorToSource= RankingAttribute.compareEnum(predecessorEnum, sourceEnum, this.fDirection);
				var successorToSource= RankingAttribute.compareEnum(successorEnum, sourceEnum, this.fDirection);
				var predecessorToSuccessor= RankingAttribute.compareEnum(predecessorEnum, successorEnum, this.fDirection);
				if (predecessorToSource < 0 && successorToSource < 0) {
					if (predecessorToSuccessor < 0) {
						targetEnum= predecessorEnum;
						targetSeq= RankingAttribute.calculateSeq(predecessorSeq, null);
					} else {
						targetEnum= predecessorEnum;
						targetSeq= RankingAttribute.calculateSeq(null, successorSeq);
					}
				} else if (predecessorToSource > 0 && successorToSource > 0) {
					if (predecessorToSuccessor > 0) {
						targetEnum= predecessorEnum;
						targetSeq= RankingAttribute.calculateSeq(predecessorSeq, null);
					} else {
						targetEnum= predecessorEnum;
						targetSeq= RankingAttribute.calculateSeq(null, successorSeq);
					}
				}
			}
		}
		if (targetEnum == null || targetSeq == null) 
			return source;
		return this.createRank(targetEnum, targetSeq);
	},

	getDependentAttributes: function() {
		return [this.fSequenceAttributeId, this.fEnumerationAttributeId];
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		this.fEnumerationAttribute= planModel.findAttribute(this.fEnumerationAttributeId);
		this.fSequenceAttribute= planModel.findAttribute(this.fSequenceAttributeId);
		var $subject= planElements;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var planElement= $subject[$count];
			var enumValue= planElement.getAttributeValue(this.fEnumerationAttribute);
			var seqValue= this.fromNativeValue(planElement.getAttributeValue(this.fSequenceAttribute), enumValue);
			planElement.define(this, this.createRank(enumValue, seqValue));
		}
		future.callback(null);
	},

	onChange: function(deltaBuilder, planElementDelta) {
		var newEnum;
		var newSeq;
		var enumDelta= planElementDelta.getAttributeDelta(this.fEnumerationAttribute);
		if (enumDelta != null) {
			newEnum= enumDelta.getNewValue();
		} else {
			newEnum= planElementDelta.getPlanElement().getAttributeValue(this.fEnumerationAttribute);
		}
		var seqDelta= planElementDelta.getAttributeDelta(this.fSequenceAttribute);
		if (seqDelta != null) {
			newSeq= this.fromNativeValue(seqDelta.getNewValue(), newEnum);
		} else {
			var rawSeq= planElementDelta.getPlanElement().getAttributeValue(this.fSequenceAttribute);
			newSeq= this.fromNativeValue(rawSeq, newEnum);
		}
		var newValue= this.createRank(newEnum, newSeq);
		var oldValue= planElementDelta.getPlanElement().define(this, newValue);
		deltaBuilder.changed(planElementDelta.getPlanElement(), this, oldValue, newValue);
	},

	getAttributeType: function() {
		return PlanningAttributeType.RANKING;
	},

	setValue: function(receiver, value) {
		var attributeId= this;
		receiver.getPlanModel().compoundChange(dojo.hitch(this, function(deltaBuilder) {
			if (value == null) {
				var enumerationValue= receiver.getAttributeValue(this.fEnumerationAttribute);
				receiver.setAttributeValue(attributeId, this.createRank(enumerationValue, SequenceValue.NEW));
			} else {
				var enumerationValue= value.getEnumerationValue();
				receiver.setAttributeValue(this.fEnumerationAttribute, enumerationValue);
				receiver.setAttributeValue(this.fSequenceAttribute, this.toNativeValue(value.getSequenceValue(), enumerationValue));
			}
			return null;
		}));
	},

	fromNativeValue: function(value, enumValue) {
		if (enumValue == null) 
			return SequenceValue.INITIAL;
		var scope= enumValue.getLiteralId();
		if (value != null && value.indexOf(RankingAttribute.SEQUENCE_ATTRIBUTE_LEGACYSCOPE) === 0) 
			scope= RankingAttribute.SEQUENCE_ATTRIBUTE_LEGACYSCOPE;
		return FACTORY.valueOf(value, scope);
	},

	toNativeValue: function(value, enumValue) {
		return value.serializeSequenceValue(enumValue.getLiteralId());
	},

	createRank: function(enumValue, seqValue) {
		return new Value(enumValue, seqValue, this.fDirection);
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.apt.api.client.IPlanningAttributeListener': true
	}
});
var Value= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.RankingAttribute.Value", null, {
	"-chains-": { constructor: "manual" },

	//fEnumerationValue: null,

	//fSequenceValue: null,

	//fDirection: null,

	constructor: function(enumerationValue, sequenceValue, direction) {
		this.fDirection= 1;
		this.fEnumerationValue= enumerationValue;
		this.fSequenceValue= sequenceValue;
		this.fDirection= direction;
	},

	canRank: function() {
		return this.fEnumerationValue !== undefined && this.fEnumerationValue != null;
	},

	isSpecified: function() {
		return this.fEnumerationValue != null && this.fSequenceValue != null && !this.fSequenceValue.isNew();
	},

	getEnumerationValue: function() {
		return this.fEnumerationValue;
	},

	compareEnumerationValueTo: function(other) {
		return RankingAttribute.compareEnum(this.fEnumerationValue, other.fEnumerationValue, this.fDirection);
	},

	getSequenceValue: function() {
		return this.fSequenceValue;
	},

	compareTo: function(other) {
		if (!this.canRank() || !other.canRank()) {
			return (this.canRank() ? 0 : 1) - (other.canRank() ? 0 : 1);
		}
		var result= RankingAttribute.compareEnum(this.fEnumerationValue, other.fEnumerationValue, this.fDirection);
		if (result === 0) 
			result= RankingAttribute.compareSequence(this.fSequenceValue, other.fSequenceValue, 1);
		return result;
	},

	equals: function(other) {
		if (this === other) 
			return true;
		if (this.constructor !== other.constructor) 
			return false;
		return this.compareTo(other) === 0;
	}
});

RankingAttribute.SEQUENCE_ATTRIBUTE_LEGACYSCOPE= "__tpZgxeHEd6ry8lWYPBHvQ";
RankingAttribute.PARAM_ATTR= "attribute";
RankingAttribute.PARAM_REVERSE= "reverse";
RankingAttribute.calculateSeq= function(predecessorSeq, successorSeq) {
	if (predecessorSeq != null) {
		if (successorSeq != null) {
			return FACTORY.between(predecessorSeq, successorSeq);
		} else {
			return FACTORY.successor(predecessorSeq);
		}
	} else if (successorSeq != null) {
		return FACTORY.predecessor(successorSeq);
	} else {
		return SequenceValue.INITIAL;
	}
};
RankingAttribute.compareEnum= function(a, b, direction) {
	if (a == null || b == null) 
		return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
	return a.compareTo(b) * direction;
};
RankingAttribute.compareSequence= function(a, b, direction) {
	if (a == null || b == null) 
		return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
	return a.compareTo(b) * direction;
};
Value.UNRANKED= new Value(null, SequenceValue.NEW, 1);

})();
