/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2007, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.PrimaryTagAttribute");

dojo.require("com.ibm.team.apt.api.client.IPlanItem");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.PlanningAttributeValueSet");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute");

(function() {
var apt= com.ibm.team.apt;
var IPlanItem= apt.api.client.IPlanItem;
var attributes= apt.shared.client.internal.model.attributes;
var PlanningAttributeValueSet= attributes.PlanningAttributeValueSet;
var SharedPlanningAttribute= attributes.SharedPlanningAttribute;

dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.PrimaryTagAttribute", SharedPlanningAttribute, {

	//fValueSet: null,

	constructor: function(description, planningClient, planContext) {
		this.inherited(arguments, [description, planningClient, planContext]);
	},

	getDependentAttributes: function() {
		return [IPlanItem.TAGS];
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		var values= [];
		var $subject= planElements;
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var planElement= $subject[$count];
			var tags= planElement.getAttributeValue(IPlanItem.TAGS);
			var primaryTag= tags == null || tags.length === 0 ? null : tags[0];
			planElement.define(this, primaryTag);
			if (primaryTag != null) {
				values.push(primaryTag);
			}
		}
		this.fValueSet= new PlanningAttributeValueSet(values, null);
		future.callback(null);
	},

	onChange: function(deltaBuilder, delta) {
		var planElement= delta.getPlanElement();
		var attributeDelta= delta.getAttributeDelta(IPlanItem.TAGS);
		var tags= attributeDelta.getNewValue();
		var newValue= tags == null || tags.length === 0 ? null : tags[0];
		var oldValue= planElement.define(this, newValue);
		deltaBuilder.changed(planElement, this, oldValue, newValue);
	},

	setValue: function(receiver, value) {
		var tags;
		if (value != null) {
			tags= receiver.getAttributeValue(IPlanItem.TAGS);
			var idx= -1;
			if (tags != null) {
				tags= tags.slice(0);
				idx= dojo.indexOf(tags, value);
				if (idx !== -1) {
					tags.splice(idx, 1);
				}
			} else {
				tags= [];
			}
			tags.unshift(value);
		} else {
			tags= [];
		}
		receiver.setAttributeValue(IPlanItem.TAGS, tags);
	},

	getValueSet: function(planElement) {
		return this.fValueSet;
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.apt.api.client.IPlanningAttributeListener': true
	}
});

})();
