/****************************************************************************** 
 Licensed Materials - Property of IBM
 © Copyright IBM Corporation 2013, 2019. All Rights Reserved.
 
 Note to U.S. Government Users Restricted Rights:
 Use, duplication or disclosure restricted by GSA ADP Schedule
 Contract with IBM Corp.
******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.NewRankingAttribute");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.client.internal.IExecutionEnvironment");
dojo.require("com.ibm.team.apt.api.client.internal.PlanningAttributeIdentifierImpl");
dojo.require("com.ibm.team.apt.api.common.planning.IPlanningAttributeDescription");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.client.SequenceValue");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute");
dojo.require("dojo.i18n");

dojo.requireLocalization("com.ibm.team.apt.shared.client.internal.model.attributes", "Messages");

(function() {
var Messages= dojo.i18n.getLocalization("com.ibm.team.apt.shared.client.internal.model.attributes", "Messages");

var jdojo= com.ibm.jdojo.lang.Runtime;
var apt= com.ibm.team.apt;
var api= apt.api;
var internal= api.client.internal;
var IExecutionEnvironment= internal.IExecutionEnvironment;
var PlanningAttributeIdentifierImpl= internal.PlanningAttributeIdentifierImpl;
var planning= api.common.planning;
var IPlanningAttributeDescription= planning.IPlanningAttributeDescription;
var PlanningAttributeType= planning.PlanningAttributeType;
var SequenceValue= apt.client.SequenceValue;
var FACTORY= SequenceValue.FACTORY;
var SharedPlanningAttribute= apt.shared.client.internal.model.attributes.SharedPlanningAttribute;

var NewRankingAttribute= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.NewRankingAttribute", SharedPlanningAttribute, {

	//fSequenceAttributeLegacyScope: null,

	//fSequenceAttribute: null,

	//fSequenceAttributeId: null,

	fDirection: 0,

	constructor: function(description, planningClient, planContext) {
		this.inherited(arguments, [description, planningClient, planContext]);
		var direction= -1;
		if (description.getParameter(NewRankingAttribute.PARAM_REVERSE) != null || String(description.getParameter(NewRankingAttribute.PARAM_REVERSE)).toLowerCase() === "false") 
			direction= -1;
		this.fDirection= direction;
		this.fSequenceAttributeLegacyScope= description.getId();
		this.fSequenceAttributeId= new PlanningAttributeIdentifierImpl(description.getId() + "." + IPlanningAttributeDescription.RANKING_SEQUENCE_ATTRIBUTE_ID_SUFFIX);
	},

	unRankIfRanked: function(element) {
		if (this.isRanked(element)) {
			this.unrank(element);
		}
	},

	isRanked: function(element) {
		var value= this.getValue(element);
		return value != null && value.isSpecified();
	},

	calculateRank: function(predecessor, successor) {
		if (predecessor == null && successor == null) 
			return this.createRank(SequenceValue.INITIAL);
		var predecessorSeq= predecessor != null ? predecessor.getSequenceValue() : null;
		var successorSeq= successor != null ? successor.getSequenceValue() : null;
		if (predecessorSeq != null && predecessorSeq.isNew()) 
			predecessorSeq= null;
		if (successorSeq != null && successorSeq.isNew()) 
			successorSeq= null;
		var targetSeq= null;
		if (predecessorSeq != null && successorSeq == null) {
			targetSeq= this.calculateSeq(predecessorSeq, null);
		} else if (predecessorSeq == null && successorSeq != null) {
			targetSeq= this.calculateSeq(null, successorSeq);
		} else {
			targetSeq= this.calculateSeq(predecessorSeq, successorSeq);
		}
		return this.createRank(targetSeq);
	},

	updateItemsInModel: function(elementsWithRank, planModel, done) {
		var batches= this.getBatches(elementsWithRank);
		var totalBatches= batches.length;
		this.fPlanningClient.getExecutionEnvironment().newWorkerWithProgress(dojo.hitch(this, function(monitor) {
			if (batches.length > 0 && batches.length === totalBatches) {
				monitor.beginTask(Messages.NewRankCalculator_STATUS_MESSAGE, totalBatches);
			}
			var elements= batches.shift();
			if (elements != null) {
				this.setBatchAttributeValue(elements, planModel);
				monitor.worked(1);
			}
			if (batches.length > 0) {
				return 100;
			}
			monitor.done();
			if (done != null) {
				done();
			}
			return IExecutionEnvironment.DONE;
		})).schedule(100);
	},

	getBatches: function(elementsWithRank) {
		var batches= [];
		var batch= [];
		var $subject= jdojo.getValues(elementsWithRank);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var item= $subject[$count];
			batch.push(item);
			if (batch.length === NewRankingAttribute.BATCHSIZE) {
				batches.push(batch);
				batch= [];
			}
		}
		if (batch.length > 0) {
			batches.push(batch);
		}
		return batches;
	},

	setBatchAttributeValue: function(elements, planModel) {
		var attributeId= this;
		planModel.compoundChange(dojo.hitch(this, function(deltaBuilder) {
			var $subject2= elements;
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var elementObj= $subject2[$count2];
				var element= elementObj.element;
				var newRank= elementObj.newRank;
				if (newRank == null) {
					element.setAttributeValue(attributeId, Value.UNRANKED);
				} else {
					element.setAttributeValue(this.fSequenceAttribute, this.toNativeValue(newRank.getSequenceValue()));
				}
			}
			return null;
		}));
	},

	getDependentAttributes: function() {
		return [this.fSequenceAttributeId];
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		this.fSequenceAttribute= planModel.findAttribute(this.fSequenceAttributeId);
		var $subject3= planElements;
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var planElement= $subject3[$count3];
			var nativeSequence= planElement.getAttributeValue(this.fSequenceAttribute);
			var sequenceValue= this.fromNativeValue(nativeSequence);
			planElement.define(this, this.createRank(sequenceValue));
		}
		future.callback(null);
	},

	onChange: function(deltaBuilder, planElementDelta) {
		var newSeq;
		var seqDelta= planElementDelta.getAttributeDelta(this.fSequenceAttribute);
		if (seqDelta != null) {
			newSeq= this.fromNativeValue(seqDelta.getNewValue());
		} else {
			var rawSeq= planElementDelta.getPlanElement().getAttributeValue(this.fSequenceAttribute);
			newSeq= this.fromNativeValue(rawSeq);
		}
		var newValue= this.createRank(newSeq);
		var oldValue= planElementDelta.getPlanElement().define(this, newValue);
		deltaBuilder.changed(planElementDelta.getPlanElement(), this, oldValue, newValue);
	},

	getAttributeType: function() {
		return PlanningAttributeType.NEW_RANKING;
	},

	setValue: function(receiver, value) {
		var attributeId= this;
		receiver.getPlanModel().compoundChange(dojo.hitch(this, function(deltaBuilder) {
			if (value == null) {
				receiver.setAttributeValue(attributeId, Value.UNRANKED);
			} else {
				receiver.setAttributeValue(this.fSequenceAttribute, this.toNativeValue(value.getSequenceValue()));
			}
			return null;
		}));
	},

	getSequenceAttribute: function() {
		return this.fSequenceAttribute;
	},

	setRankIfNecessary: function(predecessor, successor, element) {
		var source= this.getValue(element);
		if (!source.fallsBetween(predecessor, successor)) {
			var newRank= this.calculateRank(predecessor, successor);
			this.setValue(element, newRank);
			return newRank;
		}
		return null;
	},

	unrank: function(receiver) {
		this.setValue(receiver, Value.UNRANKED);
	},

	fromNativeValue: function(value) {
		if (value == null) {
			return SequenceValue.NEW;
		}
		return FACTORY.valueOf(value, this.fSequenceAttributeLegacyScope);
	},

	toNativeValue: function(value) {
		return value.serializeSequenceValue(this.fSequenceAttributeLegacyScope);
	},

	createRank: function(seqValue) {
		return new Value(seqValue);
	},

	calculateSeq: function(predecessorSeq, successorSeq) {
		if (predecessorSeq != null) {
			if (successorSeq != null) {
				return FACTORY.between(predecessorSeq, successorSeq);
			} else {
				return FACTORY.successor(predecessorSeq);
			}
		} else if (successorSeq != null) {
			return FACTORY.predecessor(successorSeq);
		} else {
			return SequenceValue.INITIAL;
		}
	},

	$interfaces: {
		'com.ibm.team.apt.api.client.IPlanningAttributeDependent': true,
		'com.ibm.team.apt.api.client.IPlanningAttributeListener': true
	}
});
var Value= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.NewRankingAttribute.Value", null, {
	"-chains-": { constructor: "manual" },

	//fSequenceValue: null,

	constructor: function(sequenceValue) {
		this.fSequenceValue= sequenceValue;
	},

	canRank: function() {
		return true;
	},

	isSpecified: function() {
		return this.fSequenceValue != null && !this.fSequenceValue.isNew();
	},

	getSequenceValue: function() {
		return this.fSequenceValue;
	},

	compareTo: function(other) {
		var otherSeq= other == null ? null : other.fSequenceValue;
		return NewRankingAttribute.compareSequence(this.fSequenceValue, otherSeq, 1);
	},

	equals: function(other) {
		if (this === other) 
			return true;
		if (this.constructor !== other.constructor) 
			return false;
		return this.compareTo(other) === 0;
	},

	fallsBetween: function(predecessor, successor) {
		if (this.isSpecified()) {
			if (predecessor == null) {
				return this.compareTo(successor) < 0;
			} else if (successor == null) {
				return this.compareTo(predecessor) > 0;
			} else {
				return this.compareTo(predecessor) > 0 && this.compareTo(successor) < 0;
			}
		}
		return false;
	}
});

NewRankingAttribute.BATCHSIZE= 125;
NewRankingAttribute.PARAM_REVERSE= "reverse";
NewRankingAttribute.compareSequence= function(a, b, direction) {
	if (a == null || b == null) 
		return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
	return a.compareTo(b) * direction;
};
Value.UNRANKED= new Value(SequenceValue.NEW);

})();
