/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2007, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.client.internal.PlanningAttributeIdentifierImpl");
dojo.require("com.ibm.team.apt.api.client.util.Flag");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var apt= com.ibm.team.apt;
var client= apt.api.client;
var PlanningAttributeIdentifierImpl= client.internal.PlanningAttributeIdentifierImpl;
var Flag= client.util.Flag;
var SharedPlanningAttribute= apt.shared.client.internal.model.attributes.SharedPlanningAttribute;

dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute", SharedPlanningAttribute, {

	constructor: function(description, planningClient, context) {
		this.inherited(arguments, [description, planningClient, context]);
	},

	initialize: function(planModel, planElements, future /*, flags... */ ) {
		var flags= Array.prototype.slice.call(arguments, 3);
		var $this= this;
		var runnable= function(deltaBuilder) {
			var $subject2= planElements;
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var planElement= $subject2[$count2];
				var value= new DirtyAttributes({});
				var oldValue= planElement.define($this, value);
				if (deltaBuilder != null) 
					deltaBuilder.changed(planElement, $this, oldValue, value);
			}
			return null;
		};
		if (Flag.contains(flags, Flag.Refresh)) {
			planModel.compoundChange(runnable);
		} else {
			runnable(null);
		}
		future.callback(null);
	},

	setValue: function(receiver, value) {
		var $this= this;
		receiver.getPlanModel().compoundChange(function(deltaBuilder) {
			var oldValue= receiver.define($this, value);
			deltaBuilder.changed(receiver, $this, oldValue, value);
			return null;
		});
	}
});
var DirtyAttributes= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DirtyAttribute.DirtyAttributes", null, {
	"-chains-": { constructor: "manual" },

	//fDirtyAttributes: null,

	constructor: function(dirtyAttributes) {
		this.fDirtyAttributes= dirtyAttributes;
	},

	isDirty: function() {
		return jdojo.getProperties(this.fDirtyAttributes).length !== 0;
	},

	getAttributes: function() {
		var result= [];
		var $subject= jdojo.getProperties(this.fDirtyAttributes);
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var identifier= $subject[$count];
			result.push(new PlanningAttributeIdentifierImpl(identifier));
		}
		return result;
	},

	dirty: function(identifier, value) {
		var key= identifier.getId();
		if (value === (key in this.fDirtyAttributes)) 
			return this;
		var map= dojo.mixin({}, this.fDirtyAttributes);
		if (value) {
			map[key]= value;
		} else {
			delete map[key];
		}
		return new DirtyAttributes(map);
	}
});

})();
