/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.team.apt.api.client.IPlanItem");
dojo.require("com.ibm.team.apt.api.common.planning.PlanningAttributeType");
dojo.require("com.ibm.team.apt.shared.client.internal.model.attributes.AbstractValueComparator");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var apt= com.ibm.team.apt;
var api= apt.api;
var IPlanItem= api.client.IPlanItem;
var PlanningAttributeType= api.common.planning.PlanningAttributeType;
var AbstractValueComparator= apt.shared.client.internal.model.attributes.AbstractValueComparator;

/**
 * @since 3.0
 */
var DefaultAttributeValueComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator", null, {
	"-chains-": { constructor: "manual" }
});
var StringComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.StringComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.toLowerCase().localeCompare(valueB.toLowerCase());
	}
});
var OwnerComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.OwnerComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(left, right) {
		var result= 0;
		var leftString= this.getStringComparisonValue(left);
		var rightString= this.getStringComparisonValue(right);
		if (leftString != null && rightString != null) {
			result= leftString.localeCompare(rightString);
		} else {
			result= this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
		}
		return result;
	},

	getStringComparisonValue: function(contributor) {
		if (jdojo.implementsInterface(contributor, "com.ibm.team.apt.api.common.repository.IContributor")) {
			return contributor.getName();
		}
		return null;
	}
});
var NumberComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.NumberComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		if (valueA < valueB) 
			return -1;
		if (valueA > valueB) 
			return 1;
		return 0;
	}
});
var DecimalComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.DecimalComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.compareTo(valueB);
	}
});
var BooleanComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.BooleanComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		if (valueA !== valueB) {
			return valueA ? 1 : -1;
		}
		return 0;
	}
});
var InstantComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.InstantComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.compareTo(valueB);
	}
});
var DurationComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.DurationComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.compareTo(valueB);
	}
});
var TimespanComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.TimespanComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.compareTo(valueB);
	}
});
var EnumerationComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.EnumerationComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	compareValues: function(valueA, valueB) {
		return this.doCompare(valueA, valueB);
	},

	doCompare: function(valueA, valueB) {
		if (valueA == null && valueB != null) 
			return -1;
		else if (valueA != null) 
			return valueA.compareTo(valueB);
		else 
			return 0;
	}
});
var LabelComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.LabelComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(left, right) {
		var result= 0;
		var leftString= this.getStringComparisonValue(left);
		var rightString= this.getStringComparisonValue(right);
		if (leftString != null && rightString != null) {
			result= leftString.localeCompare(rightString);
			if (result === 0) {
				if (!!left.getItemId() && !!right.getItemId()) {
					result= left.getItemId().localeCompare(right.getItemId());
				}
			}
		} else {
			result= this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
		}
		return result;
	},

	getStringComparisonValue: function(uiItem) {
		if (jdojo.implementsInterface(uiItem, "com.ibm.team.apt.api.common.IUIItem")) {
			return uiItem.getLabel();
		}
		return null;
	}
});
var CategoryComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.CategoryComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(left, right) {
		var result= 0;
		var leftString= this.getStringComparisonValue(left);
		var rightString= this.getStringComparisonValue(right);
		if (leftString != null && rightString != null) {
			result= left.getCategoryId().localeCompare(right.getCategoryId());
			if (result === 0) {
				if (!!left.getItemId() && !!right.getItemId()) {
					result= left.getItemId().localeCompare(right.getItemId());
				}
			}
		} else {
			result= this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
		}
		return result;
	},

	getStringComparisonValue: function(category) {
		if (jdojo.implementsInterface(category, "com.ibm.team.apt.api.common.workitem.ICategory")) {
			return category.getLabel();
		}
		return null;
	}
});
var ReferenceComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.ReferenceComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		var refsA= valueA.getReferences();
		var refsB= valueB.getReferences();
		if (refsA.length !== refsB.length) {
			return refsA.length > refsB.length ? 1 : -1;
		} else {
			for (var i= 0; i < refsB.length; i++){
				var refA= refsA[i];
				var refB= refsB[i];
				if (!refA.isEqual(refB)) {
					return ReferenceComparator.compareValue(refA).localeCompare(ReferenceComparator.compareValue(refB));
				}
			}
		}
		return 0;
	}
});
var WorkflowResolutionComparator= dojo.declare("com.ibm.team.apt.shared.client.internal.model.attributes.DefaultAttributeValueComparator.WorkflowResolutionComparator", AbstractValueComparator, {

	constructor: function(attribute) {
		this.inherited(arguments, [attribute, false]);
	},

	doCompare: function(valueA, valueB) {
		return valueA.getId().toLowerCase().localeCompare(valueB.getId().toLowerCase());
	}
});

DefaultAttributeValueComparator.createComparator= function(attribute) {
	switch(attribute.getDescription().getAttributeType()) {
		case PlanningAttributeType.STRING:
		case PlanningAttributeType.HTML:
			return new StringComparator(attribute);
		case PlanningAttributeType.INTEGER:
		case PlanningAttributeType.FLOAT:
			return new NumberComparator(attribute);
		case PlanningAttributeType.DECIMAL:
			return new DecimalComparator(attribute);
		case PlanningAttributeType.BOOLEAN:
			return new BooleanComparator(attribute);
		case PlanningAttributeType.INSTANT:
			return new InstantComparator(attribute);
		case PlanningAttributeType.DURATION:
			return new DurationComparator(attribute);
		case PlanningAttributeType.TIMESPAN:
			return new TimespanComparator(attribute);
		case PlanningAttributeType.ITEM:
		case PlanningAttributeType.WORKFLOW_STATE:
		case PlanningAttributeType.WORKITEM_TYPE:
			if ((IPlanItem.OWNER.getId() === attribute.getId())) {
				return new OwnerComparator(attribute);
			} else if ((IPlanItem.CATEGORY.getId() === attribute.getId())) {
				return new CategoryComparator(attribute);
			} else {
				return new LabelComparator(attribute);
			}
		case PlanningAttributeType.ENUMERATION:
			return new EnumerationComparator(attribute);
		case PlanningAttributeType.REFERENCE:
			return new ReferenceComparator(attribute);
		case PlanningAttributeType.WORKFLOW_RESOLUTION:
			return new WorkflowResolutionComparator(attribute);
	}
	return null;
};
ReferenceComparator.compareValue= function(reference) {
	var result= null;
	var handle= reference.getItemHandle();
	if (handle != null) {
		result= handle.getHandleValue();
	}
	if (result == null) {
		result= reference.getUri();
	}
	if (result == null) {
		result= "";
	}
	return result;
};

})();
