/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.duration.Timespan");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.workitem.Duration");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var Duration= com.ibm.team.apt.api.common.workitem.Duration;

/**
 * @since 3.0
 */
var Timespan= dojo.declare("com.ibm.team.apt.shared.client.internal.duration.Timespan", null, {
	"-chains-": { constructor: "manual" },

	//fStart: null,

	//fEnd: null,

	//fDuration: null,

	constructor: function(start, end) {
		this.fStart= start;
		this.fEnd= end;
		if (!(this.fStart.getTime() <= this.fEnd.getTime())) Assert.fail("this.fStart.getTime() <= this.fEnd.getTime()", "Timespan:30");
	},

	getStart: function() {
		return this.fStart;
	},

	getEnd: function() {
		return this.fEnd;
	},

	getDuration: function() {
		if (this.fDuration == null) {
			this.fDuration= new Duration(this.fEnd.getTime() - this.fStart.getTime());
		}
		return this.fDuration;
	},

	contains: function(instant) {
		return this.fStart.beforeEq(instant) && this.fEnd.after(instant);
	},

	overlap: function(other) {
		if (other == null) 
			return null;
		var otherStart= other.getStart();
		var otherEnd= other.getEnd();
		if (this.fEnd.before(otherStart) || this.fStart.after(otherEnd)) 
			return null;
		var start= this.fStart.before(otherStart) ? otherStart : this.fStart;
		var end= this.fEnd.before(otherEnd) ? this.fEnd : otherEnd;
		return new Timespan(start, end);
	},

	compareTo: function(other) {
		return Timespan.__comparisonValue(this) - Timespan.__comparisonValue(other);
	},

	eq: function(other) {
		return other != null && this.fStart.eq(other.getStart()) && this.fEnd.eq(other.getEnd());
	},

	toString: function() {
		return this.fStart.toString() + " - " + this.fEnd.toString();
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.ITimespan': true
	}
});

Timespan.__comparisonValue= function(timespan) {
	var start= timespan.getStart().getTime();
	var end= timespan.getEnd().getTime();
	return ((((end - start) / 2 + start))|0);
};

})();
