/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2009, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.duration.PlanDuration");

dojo.require("com.ibm.jdojo.util.Assert");
dojo.require("com.ibm.team.apt.api.common.workitem.Duration");

(function() {
var Assert= com.ibm.jdojo.util.Assert;
var Duration= com.ibm.team.apt.api.common.workitem.Duration;

var PlanDuration= dojo.declare("com.ibm.team.apt.shared.client.internal.duration.PlanDuration", Duration, {

	fOriginalEstimate: 0,

	fCorrectedEstimate: 0,

	fTimeSpent: 0,

	constructor: function(originalEstimate, correctedEstimate, timeSpent, isResolved) {
		this.inherited(arguments, [PlanDuration.calculateDuration(originalEstimate, correctedEstimate, timeSpent, isResolved)]);
		this.fOriginalEstimate= originalEstimate;
		this.fCorrectedEstimate= correctedEstimate;
		this.fTimeSpent= timeSpent;
	},

	getEstimate: function() {
		return this.getCorrectedEstimate().isSpecified() ? this.getCorrectedEstimate() : this.getOriginalEstimate();
	},

	getCorrectedEstimate: function() {
		return new Duration(this.fCorrectedEstimate);
	},

	getOriginalEstimate: function() {
		return new Duration(this.fOriginalEstimate);
	},

	getTimeSpent: function() {
		return new Duration(this.fTimeSpent);
	},

	getTimeRemaining: function() {
		var timeSpent= this.getTimeSpent().getMilliseconds();
		if (PlanDuration.isEncodedTimeRemaining(timeSpent)) {
			return new Duration(PlanDuration.decodeTimeSpent2TimeRemaining(timeSpent));
		}
		if (timeSpent >= 0) {
			var value= this.getEstimate().getMilliseconds() - timeSpent;
			if (value >= 0) {
				return new Duration(value);
			} else {
				return Duration.INVALID;
			}
		}
		return new Duration(this.getEstimate().getMilliseconds());
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.planning.IPlanDuration': true
	}
});

PlanDuration.INVALID_TIME_SPENT_OFFSET= 3;
PlanDuration.calculateDuration= function(originalEstimate, correctedEstimate, timeSpent, isResolved) {
	var result= originalEstimate;
	if (correctedEstimate >= 0) 
		result= correctedEstimate;
	if (timeSpent >= 0) {
		if (!isResolved) {
			if (result >= 0) {
				result= result - timeSpent;
				result= result < 0 ? 0 : result;
			}
		} else {
			result= timeSpent;
		}
	}
	return result;
};
PlanDuration.encodeInvalidTimeRemaining= function(value) {
	var result= 0;
	result+= PlanDuration.INVALID_TIME_SPENT_OFFSET;
	result+= value;
	result*= -1;
	return result;
};
PlanDuration.decodeTimeSpent2TimeRemaining= function(value) {
	if (!(PlanDuration.isEncodedTimeRemaining(value))) Assert.fail("PlanDuration.isEncodedTimeRemaining(value)", "PlanDuration:94");
	var result= value;
	result*= -1;
	result-= PlanDuration.INVALID_TIME_SPENT_OFFSET;
	return result;
};
PlanDuration.isEncodedTimeRemaining= function(timeSpent) {
	return timeSpent < -2;
};
PlanDuration.UNSPECIFIED= new PlanDuration(-1, -1, -1, false);

})();
