/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2009, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.team.apt.shared.client.internal.duration.Instant");

dojo.require("com.ibm.jdojo.lang.Exception");
dojo.require("com.ibm.jdojo.lang.JavaScriptException");
dojo.require("com.ibm.team.apt.api.common.workitem.Duration");
dojo.require("dojo.date.locale");
dojo.require("dojo.date.stamp");
dojo.require("jazz.app.i18n");

(function() {
var lang= com.ibm.jdojo.lang;
var Exception= lang.Exception;
var JavaScriptException= lang.JavaScriptException;
var Duration= com.ibm.team.apt.api.common.workitem.Duration;
var i18n= jazz.app.i18n;

var Instant= dojo.declare("com.ibm.team.apt.shared.client.internal.duration.Instant", null, {
	"-chains-": { constructor: "manual" },

	//fDate: null,

	constructor: function(date) {
		this.fDate= date;
	},

	getTime: function() {
		return this.fDate.getTime();
	},

	setHours: function(hour, min, sec, ms) {
		var newDate= new Date(this.fDate.getTime());
		newDate.setHours(hour, min, sec, ms);
		return new Instant(newDate);
	},

	before: function(instant) {
		return this.fDate.getTime() < instant.fDate.getTime();
	},

	beforeEq: function(instant) {
		return this.fDate.getTime() <= instant.fDate.getTime();
	},

	after: function(instant) {
		return this.fDate.getTime() > instant.fDate.getTime();
	},

	afterEq: function(instant) {
		return this.fDate.getTime() >= instant.fDate.getTime();
	},

	eq: function(instant) {
		return this.fDate.getTime() === instant.fDate.getTime();
	},

	plus: function(duration) {
		return new Instant(new Date(this.fDate.getTime() + duration.getMilliseconds()));
	},

	minus: function(duration) {
		return new Instant(new Date(this.fDate.getTime() - duration.getMilliseconds()));
	},

	compareTo: function(o) {
		if (this.before(o)) 
			return -1;
		if (this.after(o)) 
			return 1;
		return 0;
	},

	durationUntil: function(other) {
		return new Duration(other.getTime() - this.getTime());
	},

	toString: function() {
		return this.fDate.toString();
	},

	format: function(options) {
		var format;
		try {
			format= i18n.date.locale.format(this.fDate, options);
		} catch (e) {
			if ((e= e instanceof Exception ? e : new JavaScriptException(e)) instanceof Exception) {
				var lfo= {};
				lfo.selector= options.selector;
				lfo.formatLength= options.formatLength;
				lfo.datePattern= options.datePattern;
				lfo.timePattern= options.timePattern;
				lfo.locale= "en-us";
				format= dojo.date.locale.format(this.fDate, lfo);
			} else {
				throw e;
			}
		}
		return format;
	},

	$interfaces: {
		'com.ibm.team.apt.api.common.IInstant': true
	}
});

Instant.currentTime= function() {
	return new Instant(new Date());
};
Instant.time= function(milliseconds) {
	return new Instant(new Date(milliseconds));
};
Instant.fromString= function(dateString) {
	return new Instant(dojo.date.stamp.fromISOString(dateString));
};
Instant.fromDate= function(date) {
	return new Instant(date);
};

})();
