/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.TeamMemberAreaAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.ScriptableAttribute"); //$NON-NLS-1$

(function() {

var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;


dojo.declare("com.ibm.team.apt.shared.client.TeamMemberAreaAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$
	
	__plan: null,
	__valueSet: null,
		
	constructor: function(descriptor) {
		this.__thisAttributeId= new PlanningAttributeIdentifier(descriptor.getId());
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return [PlanItem.CATEGORY];
	},
	
	initialize: function(planElement, monitor) {
		this.__plan= planElement.getPlanModel();
		this.__valueSet= new PlanningAttributeValueSet(
				this.__plan.getTeamMemberAreas(),
				this.__plan.getRootTeamMemberArea());
		monitor.done();
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		var delta= planElementDelta.getAttributeDelta(PlanItem.CATEGORY);
		var oldValue= delta.getOldValue();
		var oldArea= oldValue != null ? this.__plan.getTeamMemberArea(oldValue) : null;
		var newArea= this.__plan.getTeamMemberArea(delta.getNewValue());
		
		if (oldArea == null || !oldArea.equals(newArea)) {
			deltaBuilder.changed(planElementDelta.getPlanElement(), this.__thisAttributeId, oldArea, newArea);
		}
	},
		
	getValueSet: function() {
		return this.__valueSet;
	},
	
	getValue: function(receiver) {
		var result= undefined;
		if (receiver instanceof PlanItem) {
			var category= receiver.getAttributeValue(PlanItem.CATEGORY);
			if(category) {
				result= this.__plan.getTeamMemberArea(category);
			}
		}
		return result;
	},
	
	setValue: function(receiver, value) {
		if (receiver instanceof PlanItem) {
			if (!this.getValue(receiver).equals(value)){
				var category= this.__plan.getPrimaryCategoryFor(value);
				if (category != null) {
					receiver.setAttributeValue(PlanItem.CATEGORY, category);
				}
			}
		}
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__sentinel: null // terminates this class definition
});

})();
