/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2023. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.ProgressAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanElement"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanElementAccessor"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.ScriptableAttribute"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.progress.ProgressInformation"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.progress.ProgressComputer"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressComputer"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressLabelProvider"); //$NON-NLS-1$

(function() {

var PlanElement						= com.ibm.team.apt.client.PlanElement;
var PlanItem						= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;

dojo.declare("com.ibm.team.apt.shared.client.ProgressAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$
	
	__complexityAttr: null,
	__attributeId: null,
	__dependantAttributes: null,
	
	constructor: function(descriptor) {
		this.__attributeId= new PlanningAttributeIdentifier(descriptor.getId());
		
		this.__dependantAttributes= [];
		this.__dependantAttributes.push(this.__attributeId);
		this.__dependantAttributes.push(PlanElement.CHILDREN_COUNT);
		this.__dependantAttributes.push(PlanItem.COMPLEXITY);
		this.__dependantAttributes.push(PlanItem.DURATION);
		this.__dependantAttributes.push(PlanItem.STATE);
		this.__dependantAttributes.push(PlanItem.ITEM_TYPE);
	},

	// ---- api ------------------------------------------------------------------------------------------------------------
	
	getDependantAttributes: function() {
		return this.__dependantAttributes;
	},

	initialize: function(planElement, monitor) {
		this.__complexityAttr= planElement.getPlanModel().findAttribute(PlanItem.COMPLEXITY);
		monitor.done();
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		var planElement= planElementDelta.getPlanElement();
		
		if (!planElementDelta.affectsAttribute(this.__attributeId)) {
			deltaBuilder.changed(planElement, this.__attributeId, null, null);
		}

		var parent= planElement.getParent();
		if (parent != null && parent instanceof com.ibm.team.apt.client.PlanItem) {
			deltaBuilder.changed(parent, this.__attributeId, null, null);
		}
	},

	getAttributeType: function() {
		return PlanningAttributeType.STRING;
	},
	
	getValueSet: function() {
		return PlanningAttributeValueSet.EMPTY;
	},

	getValue: function(receiver) {
		var complexityAttr= receiver.getPlanModel().getComplexityAttribute();
		if(complexityAttr) {
			var progressInformation= new com.ibm.team.apt.shared.client.internal.progress.ProgressInformation();
			var itemAccessor= new com.ibm.team.apt.client.PlanElementAccessor(complexityAttr);
			if(itemAccessor.isTopLevelPlanItem(receiver)){
				var progressComputor= this._getProgressComputer(receiver, itemAccessor, progressInformation);
				var entries= true ? itemAccessor.getChildren(receiver) : [receiver];
				for(var i= 0; i < entries.length; i++){
					progressComputor.compute(entries[i]);
				}
				var labelProvider= this._getLabelProvider(receiver, itemAccessor);
				return labelProvider.getProgressText(progressInformation);
			}
		}
		return null;
	},
	
	_getLabelProvider: function(receiver, accessor) {
		var options= {};
		options.getParameter= dojo.hitch(this, function(parameterName) {

			if (parameterName == "showLabels") {
				return false;
			} else if (receiver.getPlanModel().useComplexity()) {
				if (parameterName == "complexityLabel") {
					return this.__complexityAttr.getParameter("label") || "";
				} else if (parameterName == "complexityUnit") {
					return this.__complexityAttr.getParameter("abbreviation") || "";
				}else if (parameterName == "type") {
					return this.__complexityAttr.getParameter("type") || "";
				}
			}

			return null;
		});

		if (this.__useComplexity(receiver, accessor)) {
			return new com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressLabelProvider(options);
		} else {
			return new com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider(options);
		}
	},
	
	_getProgressComputer: function(receiver, accessor, progressInformation) {
		return this.__useComplexity(receiver, accessor) ? new com.ibm.team.apt.shared.client.internal.progress.StoryPointProgressComputer(accessor, progressInformation) : new com.ibm.team.apt.shared.client.internal.progress.ProgressComputer(accessor, progressInformation);
	},
	
	__useComplexity: function(receiver, itemAccessor) {
		if(!itemAccessor.isPlanItem(receiver)){
			return receiver.getPlanModel().useComplexity();
			
		} else {
			return ((function(children){
				for(var i= 0; i < children.length; i++) {
					if(itemAccessor.isTopLevelPlanItem(children[i])){
						return true;
					} else {
						var result= arguments.callee.call(this, itemAccessor.getChildren(children[i]));
						if(result){
							return true;
						}
					}
				}
				return false;
			})(itemAccessor.getChildren(receiver)));
		}
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__sentinel: null // terminates this class definition
});

})();
