/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.PrimaryTagAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.shared.client.DelegateAttribute"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanItem"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$

(function() {
	
var Assert= com.ibm.jdojo.util.Assert;
var PlanItem= com.ibm.team.apt.client.PlanItem;
var PlanningAttributeType= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet= com.ibm.team.apt.client.PlanningAttributeValueSet;

dojo.declare("com.ibm.team.apt.shared.client.PrimaryTagAttribute", com.ibm.team.apt.shared.client.DelegateAttribute, { //$NON-NLS-1$
		
	constructor: function() {
		this._delegateId= com.ibm.team.apt.client.PlanItem.TAGS;
	},	
		
	getValue: function(receiver) {
		return this.__getPrimaryTag(this._delegate.getValue(receiver));
	},
	
	setValue: function(receiver, value) {
		var tags= this._delegate.getValue(receiver); 
		var result= value == null ? [] : [value];
		
		if (tags != null && tags.length > 1) {
			// add additional tags...
			
			var additionalTags= tags.slice(1);
			if (value != null) {
				// ...but make sure the primary tag is not repeated in the additional tags
				var duplicateIndex= dojo.indexOf(additionalTags, value);
				if (duplicateIndex != -1) {
					additionalTags.splice(duplicateIndex, 1);
				}
			}
			
			result.push.apply(result, additionalTags);
		}
		
		
		this._delegate.setValue(receiver, result);
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		var delta= planElementDelta.getAttributeDelta(this._delegateId);
		deltaBuilder.changed(planElementDelta.getPlanElement(), this.__thisAttributeId, this.__getPrimaryTag(delta.getOldValue()), this.__getPrimaryTag(delta.getNewValue()));
	},
	
	getAttributeType: function() {
		return PlanningAttributeType.STRING;
	},
	
	getValueSet: function() {
		return PlanningAttributeValueSet.EMPTY;
	},

	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__getPrimaryTag: function(tags) {
		if(!tags)
			return null;
		
		Assert.isArray(tags);
		
		if (tags.length == 0)
			return null;
		
		return tags[0];
	},
	
	__sentinel: null // terminates this class definition
});

})();
