/*******************************************************************************
 * Licensed Materials - Property of IBM (c) Copyright IBM Corporation 2005,
 * 2012. All Rights Reserved.
 *

 * Note to U.S. Government Users Restricted Rights: Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 ******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.NewRankingAttribute");

dojo.require("com.ibm.team.apt.client.PlanItem");
dojo.require("com.ibm.team.apt.client.SequenceValue");
dojo.require("com.ibm.team.apt.client.PlanningAttributeType");
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet");
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier");
dojo.require("com.ibm.team.apt.client.ScriptableAttribute");

(function() {

	var PlanItem= com.ibm.team.apt.client.PlanItem;
	var SequenceValue= com.ibm.team.apt.client.SequenceValue;
	var PlanningAttributeType= com.ibm.team.apt.client.PlanningAttributeType;
	var PlanningAttributeValueSet= com.ibm.team.apt.client.PlanningAttributeValueSet;
	var PlanningAttributeIdentifier= com.ibm.team.apt.client.PlanningAttributeIdentifier;

	var SEQUENCE_ATTRIBUTE_ID_SUFFIX= "_pm7NmRYUEd6L1tNIGdz5qQ";
	var SEQUENCE_ATTRIBUTE_LEGACYSCOPE= "__tpZgxeHEd6ry8lWYPBHvQ";

	function compare(a, b, direction) {
		if (a == null || b == null)
			return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
		return a.compareTo(b) * direction;
	}

	function isSpecified(seq) {
		return seq != null && !seq.isNew()
	}
	function calculateSeq(predecessorSeq, successorSeq) {
		if (isSpecified(predecessorSeq) && isSpecified(successorSeq)) {
			return SequenceValue.FACTORY.between(predecessorSeq, successorSeq);
		} else if (isSpecified(predecessorSeq)) {
			return SequenceValue.FACTORY.successor(predecessorSeq);
		} else if (isSpecified(successorSeq)) {
			return SequenceValue.FACTORY.predecessor(successorSeq);
		} else {
			return SequenceValue.INITIAL;
		}
	}

	dojo.declare("com.ibm.team.apt.shared.client.NewRankingAttribute", com.ibm.team.apt.client.ScriptableAttribute, {

		__options: null,
		__sequenceAttribute: null,
		__sequenceAttributeId: null,
		__attributeCache: null,

		constructor: function(descriptor) {
			this.__attributeCache= {};
			this.__attributeId= new PlanningAttributeIdentifier(descriptor.getId());
			this.__direction= "true" == String(descriptor.getParameter("reverse") || "true").toLowerCase() ? -1 : 1;
			this.__sequenceAttributeId= new PlanningAttributeIdentifier(descriptor.getId() + "." + SEQUENCE_ATTRIBUTE_ID_SUFFIX);
		},

		// ---- api --------------------------------------------------------------------------------------------

		getDependantAttributes: function() {
			return [ this.__sequenceAttributeId ];
		},

		initialize: function(planElement, monitor) {
			this.__sequenceAttribute= planElement.getPlanModel().findAttribute(this.__sequenceAttributeId);
			monitor.done();
		},

		getUnranked: function(source) {
			return this.__createRank(SequenceValue.NEW);
		},

		calculateRank: function(predecessor, successor, source) {
			var target= target= calculateSeq(predecessor, successor);
			if (target == null){
				target= source;
			}
			return target;
		},

		changed: function(planElementDelta, deltaBuilder) {
			var oldValue, newValue;
			var seqDelta= planElementDelta.getAttributeDelta(this.__sequenceAttribute);
			if (seqDelta) {
				oldValue= seqDelta.getOldValue();
				newValue= seqDelta.getNewValue();
			} else {
				oldValue= newValue= planElementDelta.getPlanElement().getAttributeValue(this.__sequenceAttribute);
			}
			this.__toCache(planElementDelta.getPlanElement(), newValue);

			deltaBuilder.changed(planElementDelta.getPlanElement(), this.__attributeId, oldValue, newValue);
		},

		getAttributeType: function() {
			return PlanningAttributeType.RANKING;
		},

		getValueSet: function() {
			return PlanningAttributeValueSet.EMPTY;
		},

		getValue: function(receiver) {
			var result= undefined;
			if (receiver instanceof PlanItem) {
				result= this.__fromCache(receiver);
				if (result == null) {
					var sequenceValue= receiver.getAttributeValue(this.__sequenceAttribute);
					result= this.__createRank(sequenceValue);
					this.__toCache(receiver, result);
				}
			}
			return result;
		},

		setValue: function(receiver, value) {
			if (receiver instanceof PlanItem) {
				this.__toCache(receiver, null);
				var serialized= value.serializeSequenceValue(this.__attributeId.getId());
				receiver.setAttributeValue(this.__sequenceAttribute, serialized);
			}
		},

		__fromCache: function(planItem) {
			return this.__attributeCache[planItem.getUuid()];
		},

		__toCache: function(planItem, value) {
			this.__attributeCache[planItem.getUuid()]= value;
		},

		// ---- implementation -----------------------------------------------------------------------------------------

		__createRank: function(seqValue) {
			return new com.ibm.team.apt.shared.client.NewRankingAttribute._Value(seqValue);
		},

		__sentinel: null
	// terminates this class definition
	});

	com.ibm.team.apt.shared.client.NewRankingAttribute.SEQUENCE_ATTRIBUTE_ID_SUFFIX= SEQUENCE_ATTRIBUTE_ID_SUFFIX;

	dojo.declare("com.ibm.team.apt.shared.client.NewRankingAttribute._Value", null, {

		__sequenceValue: null,
		__direction: 1,

		constructor: function(sequenceValue, direction) {
			this.__sequenceValue= sequenceValue;
			this.__direction= direction;
		},

		// ---- API -------------------------------------------------------------------------------------------------

		canRank: function() {
			return true;
		},

		isSpecified: function() {
			return this.__sequenceValue && !this.__sequenceValue.isNew();
		},

		getSequenceValue: function(scope) {
			return this.__sequenceValue;
		},

		// ---- Comparable implementation ------------------------------------------------------------------------------
		compareTo: function(other) {
			return compare(this.__sequenceValue, other.__sequenceValue, 1);
		},

		equals: function(other) {
			if (this === other)
				return true;

			if (this.declaredClass !== other.declaredClass)
				return false;

			return this.compareTo(other) == 0;
		},

		// ---- implementation --------------------------------------------------------------------------------------------

		__sentinel: null
	// terminates this class definition
	});

})();
