/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2019. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.team.apt.shared.client.DelegateAttribute"); //$NON-NLS-1$

dojo.require("com.ibm.team.apt.client.PlanningAttributeType"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeValueSet"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.PlanningAttributeIdentifier"); //$NON-NLS-1$
dojo.require("com.ibm.team.apt.client.ScriptableAttribute"); //$NON-NLS-1$

(function() {

var PlanningAttributeType			= com.ibm.team.apt.client.PlanningAttributeType;
var PlanningAttributeValueSet		= com.ibm.team.apt.client.PlanningAttributeValueSet;
var PlanningAttributeIdentifier		= com.ibm.team.apt.client.PlanningAttributeIdentifier;


dojo.declare("com.ibm.team.apt.shared.client.DelegateAttribute", com.ibm.team.apt.client.ScriptableAttribute, { //$NON-NLS-1$
	
	_delegate: null,
	_delegateId: null,
		
	constructor: function(descriptor) {
		this.__thisAttributeId= new PlanningAttributeIdentifier(descriptor.getId());
		var delegateId= descriptor.getParameter("attribute"); //$NON-NLS-1$
		if(delegateId){
			this._delegateId= new PlanningAttributeIdentifier(delegateId);
		}
	},

	// ---- api ------------------------------------------------------------------------------------------------------------

	getDependantAttributes: function() {
		return this._delegateId ? [ this._delegateId ] : [ ];
	},
	
	initialize: function(planElement, monitor) {
		if(this._delegateId){
			this._delegate= planElement.getPlanModel().findAttribute(this._delegateId);
		}
		monitor.done();
	},
	
	changed: function(planElementDelta, deltaBuilder) {
		if(this._delegateId){
			var delta= planElementDelta.getAttributeDelta(this._delegateId);
			deltaBuilder.changed(planElementDelta.getPlanElement(), this.__thisAttributeId, delta.getOldValue(), delta.getNewValue());
		}
	},
	
	getAttributeType: function() {
		return this._delegate ? this._delegate.getAttributeType() : null;
	},
	
	getValueSet: function() {
		return this._delegate ? this._delegate.getValueSet() : null;
	},
	
	getValue: function(receiver) {
		return this._delegate ? this._delegate.getValue(receiver) : null;
	},
	
	setValue: function(receiver, value) {
		if(this._delegate) {
			this._delegate.setValue(receiver, value);
		}
	},
	
	// ---- implementation -------------------------------------------------------------------------------------------------
	
	__sentinel: null // terminates this class definition
});

})();
