/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.shared.client.internal.duration.Instant;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment;
import com.ibm.team.apt.shared.client.internal.scheduler.time.AssignmentIterator;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class WorktimeScheduler
extends DojoObject {
    private AssignmentIterator fIterator = null;

    public WorktimeScheduler(ICalendarIterator timeIterator) {
        if (timeIterator instanceof AssignmentIterator) {
            this.fIterator = (AssignmentIterator)timeIterator;
        } else {
            Assignment assignment = new Assignment(Instant.time(1), Instant.time(JSMath.pow((double)2.0, (double)52.0)), 1.0);
            this.fIterator = new AssignmentIterator(timeIterator, new Assignment[]{assignment});
        }
    }

    public ITimespan schedule(IInstant earliestStart, IDuration duration, boolean forward) {
        long currentEnd;
        long currentStart;
        this.fIterator.reset(earliestStart, forward);
        Direction access = forward ? Direction.Forward : Direction.Backward;
        double lastAssignment = this.fIterator.getAssignment();
        long scaledDuration = lastAssignment == 0.0 ? JSMath.max((long)1L, (long)duration.getMilliseconds()) : (long)JSMath.max((int)1, (int)JSMath.round((double)((double)duration.getMilliseconds() / lastAssignment)));
        long startTime = currentStart = access.low(this.fIterator.current());
        long endTime = currentEnd = access.high(this.fIterator.current(), scaledDuration);
        while (scaledDuration > 0L) {
            scaledDuration = (long)((double)scaledDuration - JSMath.abs((double)(currentEnd - currentStart)));
            endTime = currentEnd;
            assert (this.fIterator.next() != null);
            if (lastAssignment != this.fIterator.getAssignment()) {
                scaledDuration = JSMath.max((int)1, (int)JSMath.round((double)((double)scaledDuration * lastAssignment / this.fIterator.getAssignment())));
                lastAssignment = this.fIterator.getAssignment();
            }
            currentStart = access.low(this.fIterator.current());
            currentEnd = access.high(this.fIterator.current(), scaledDuration);
        }
        Instant begin = Instant.time(startTime);
        Instant end = Instant.time(endTime);
        return forward ? new Timespan(begin, end) : new Timespan(end, begin);
    }

    public long workTime(ITimespan timespan) {
        long currentEnd;
        this.fIterator.reset(timespan.getStart(), true);
        long workTime = 0L;
        long maxEnd = timespan.getEnd().getTime();
        do {
            long currentStart = JSMath.min((long)this.fIterator.current().getStart().getTime(), (long)maxEnd);
            currentEnd = JSMath.min((long)this.fIterator.current().getEnd().getTime(), (long)maxEnd);
            workTime = (long)((double)workTime + (double)JSMath.max((long)0L, (long)(currentEnd - currentStart)) * this.fIterator.getAssignmentForWorkTime());
        } while (this.fIterator.nextForWorkTime() != null && currentEnd != maxEnd);
        return JSMath.round((double)workTime);
    }

    private static enum Direction {
        Forward{

            @Override
            public long low(ITimespan timespan) {
                return timespan.getStart().getTime();
            }

            @Override
            public long high(ITimespan timespan, long rawDuration) {
                return JSMath.min((long)timespan.getEnd().getTime(), (long)(timespan.getStart().getTime() + rawDuration));
            }
        }
        ,
        Backward{

            @Override
            public long low(ITimespan timespan) {
                return timespan.getEnd().getTime();
            }

            @Override
            public long high(ITimespan timespan, long rawDuration) {
                return JSMath.max((long)timespan.getStart().getTime(), (long)(timespan.getEnd().getTime() - rawDuration));
            }
        };


        public abstract long low(ITimespan var1);

        public abstract long high(ITimespan var1, long var2);
    }
}

