/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSDate;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.shared.client.internal.duration.Instant;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class WorktimeIterator
extends DojoObject
implements ICalendarIterator {
    private static final IDuration DAY = new Duration(86400000L);
    private ITimespan fCurrent = null;
    private IInstant fCurrentDay = null;
    private Workday[] fWorkdays = new Workday[0];
    private Direction fDirection;

    public WorktimeIterator(Workday[] workdays) {
        boolean isValid = false;
        Workday[] workdayArray = workdays;
        int n = workdays.length;
        int n2 = 0;
        while (n2 < n) {
            Workday workday;
            this.fWorkdays[workday.day - 1] = workday = workdayArray[n2];
            isValid |= workday.workingTime > 0 && workday.endTime > 0;
            ++n2;
        }
        if (!isValid) {
            int workDuration = 86399999;
            Workday[] workdayArray2 = workdays;
            int n3 = workdays.length;
            n = 0;
            while (n < n3) {
                Workday workday = workdayArray2[n];
                workday.workingTime = workDuration;
                workday.endTime = workDuration;
                ++n;
            }
        }
    }

    @Override
    public void reset(IInstant earliestStart, boolean forward) {
        this.fDirection = forward ? Direction.Forward : Direction.Backward;
        this.fCurrentDay = earliestStart;
        this.validate();
        if (forward && earliestStart.after(this.fCurrent.getStart())) {
            if (earliestStart.before(this.fCurrent.getEnd())) {
                this.fCurrent = new Timespan(earliestStart, this.fCurrent.getEnd());
            } else {
                this.next();
            }
        } else if (!forward && earliestStart.before(this.fCurrent.getEnd())) {
            if (earliestStart.after(this.fCurrent.getStart())) {
                this.fCurrent = new Timespan(this.fCurrent.getStart(), earliestStart);
            } else {
                this.next();
            }
        }
    }

    @Override
    public ITimespan current() {
        return this.fCurrent;
    }

    @Override
    public ITimespan next() {
        this.fCurrentDay = this.fDirection.next(this.fCurrentDay, DAY);
        this.validate();
        return this.fCurrent;
    }

    private void validate() {
        Workday workDay;
        JSDate date = new JSDate(this.fCurrentDay.getTime());
        while (true) {
            workDay = this.fWorkdays[date.getDay()];
            date.setHours(0, 0, 0, 0);
            if (workDay.workingTime > 0) break;
            this.fCurrentDay = this.fDirection.next(this.fCurrentDay, DAY);
            date = new JSDate(this.fCurrentDay.getTime());
        }
        long start = date.getTime() + (long)workDay.endTime - (long)workDay.workingTime;
        long end = date.getTime() + (long)workDay.endTime;
        this.fCurrent = new Timespan(Instant.time(start), Instant.time(end));
    }

    private static enum Direction {
        Forward{

            @Override
            public IInstant next(IInstant instant, IDuration duration) {
                return instant.plus(duration);
            }
        }
        ,
        Backward{

            @Override
            public IInstant next(IInstant instant, IDuration duration) {
                return instant.minus(duration);
            }
        };


        public abstract IInstant next(IInstant var1, IDuration var2);
    }

    public static class Workday {
        public int day;
        public int endTime;
        public int workingTime;

        public Workday(int day, int workingTime, int endTime) {
        }
    }
}

