/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class UnionIterator
extends DojoObject
implements ICalendarIterator {
    private ICalendarIterator[] fIterators = null;
    private ITimespan fCurrent = null;
    private boolean fForward;

    public UnionIterator(ICalendarIterator[] iterators) {
        assert (iterators.length > 0);
        this.fIterators = iterators;
    }

    @Override
    public void reset(IInstant earliestStart, boolean forward) {
        this.fForward = forward;
        int i = 0;
        while (i < this.fIterators.length) {
            this.fIterators[i].reset(earliestStart, forward);
            ++i;
        }
        this.fCurrent = this.validate(earliestStart);
    }

    @Override
    public ITimespan current() {
        return this.fCurrent;
    }

    @Override
    public ITimespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.validate(this.fForward ? this.fCurrent.getEnd() : this.fCurrent.getStart());
        }
        return this.fCurrent;
    }

    private ITimespan validate(IInstant earliestStart) {
        IInstant end;
        IInstant begin;
        do {
            ITimespan currentPeriod;
            begin = earliestStart;
            end = null;
            int i = 0;
            while (i < this.fIterators.length) {
                currentPeriod = this.fIterators[i].current();
                if (currentPeriod == null) {
                    return null;
                }
                if (begin == null || (this.fForward ? currentPeriod.getStart().after(begin) : currentPeriod.getEnd().before(begin))) {
                    begin = this.fForward ? currentPeriod.getStart() : currentPeriod.getEnd();
                }
                ++i;
            }
            IInstant candidateInstant = begin;
            int i2 = 0;
            while (i2 < this.fIterators.length) {
                currentPeriod = this.fIterators[i2].current();
                if (!this.contains(currentPeriod, candidateInstant)) {
                    while (!(this.fForward ? !currentPeriod.getEnd().beforeEq(candidateInstant) : !currentPeriod.getStart().afterEq(candidateInstant))) {
                        currentPeriod = this.fIterators[i2].next();
                        if (currentPeriod != null) continue;
                        return null;
                    }
                    begin = null;
                    end = null;
                }
                if (end == null || (this.fForward ? currentPeriod.getEnd().before(end) : currentPeriod.getStart().after(end))) {
                    end = this.fForward ? currentPeriod.getEnd() : currentPeriod.getStart();
                }
                ++i2;
            }
        } while (begin == null || end == null);
        if (this.fForward) {
            return new Timespan(earliestStart.after(begin) ? earliestStart : begin, end);
        }
        return new Timespan(end, earliestStart.before(begin) ? earliestStart : begin);
    }

    private boolean contains(ITimespan timespan, IInstant instant) {
        if (this.fForward) {
            return timespan.getStart().beforeEq(instant) && timespan.getEnd().after(instant);
        }
        return timespan.getEnd().afterEq(instant) && timespan.getStart().before(instant);
    }
}

