/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class TimespanIterator
extends DojoObject
implements ICalendarIterator {
    private ITimespan[] fTimespans;
    private ITimespan fCurrent = null;
    private int fCurrentIndex = -1;
    private boolean fForward = true;

    public TimespanIterator(ITimespan[] timespans) {
        if (timespans.length == 0) {
            this.fTimespans = new Timespan[0];
        } else {
            timespans = this.sanitizeTimespans(timespans);
            this.fTimespans = new Timespan[0];
            JSArrays.push((Object[])this.fTimespans, (Object)timespans[0]);
            int i = 1;
            while (i < timespans.length) {
                ITimespan current = timespans[i];
                if (current != this.fTimespans[this.fTimespans.length - 1]) {
                    JSArrays.push((Object[])this.fTimespans, (Object)current);
                }
                ++i;
            }
        }
    }

    public void add(ITimespan when) {
        int positionToInsert = 0;
        int i = 0;
        while (i < this.fTimespans.length) {
            ITimespan timespan = this.fTimespans[i];
            positionToInsert = i;
            if (timespan.contains(when.getStart()) && timespan.contains(when.getEnd())) {
                return;
            }
            if (timespan.contains(when.getStart()) && !timespan.contains(when.getEnd())) {
                when = new Timespan(timespan.getStart(), when.getEnd());
                JSArrays.splice((Object[])this.fTimespans, (int)i, (int)1, (Object[])new ITimespan[]{when});
                this.fTimespans = this.sanitizeTimespans(this.fTimespans);
                return;
            }
            if (timespan.getEnd().eq(when.getStart())) {
                when = new Timespan(timespan.getStart(), when.getEnd());
                JSArrays.splice((Object[])this.fTimespans, (int)i, (int)1, (Object[])new ITimespan[]{when});
                this.fTimespans = this.sanitizeTimespans(this.fTimespans);
                return;
            }
            if (!timespan.contains(when.getStart()) && timespan.contains(when.getEnd())) {
                when = new Timespan(when.getStart(), timespan.getEnd());
                JSArrays.splice((Object[])this.fTimespans, (int)i, (int)1, (Object[])new ITimespan[]{when});
                this.fTimespans = this.sanitizeTimespans(this.fTimespans);
                return;
            }
            if (when.contains(timespan.getStart()) && when.contains(timespan.getEnd())) {
                JSArrays.splice((Object[])this.fTimespans, (int)i, (int)1, (Object[])new ITimespan[]{when});
                this.fTimespans = this.sanitizeTimespans(this.fTimespans);
                return;
            }
            if (when.getStart().before(timespan.getStart())) {
                JSArrays.splice((Object[])this.fTimespans, (int)i, (int)0, (Object[])new ITimespan[]{when});
                this.fTimespans = this.sanitizeTimespans(this.fTimespans);
                return;
            }
            if (when.getStart().afterEq(this.fTimespans[i].getEnd())) {
                positionToInsert = i + 1;
            }
            ++i;
        }
        JSArrays.splice((Object[])this.fTimespans, (int)positionToInsert, (int)0, (Object[])new ITimespan[]{when});
    }

    public ITimespan[] sanitizeTimespans(ITimespan[] timespans) {
        JSArrays.sort((Object[])timespans, (JSArrays.IComparator)new JSArrays.IComparator<ITimespan>(){

            public int compare(ITimespan left, ITimespan right) {
                return left.getStart().compareTo(right.getStart());
            }
        });
        int i = 1;
        while (i < timespans.length) {
            ITimespan previous = timespans[i - 1];
            ITimespan current = timespans[i];
            if (previous.getStart().eq(current.getStart()) && previous.getEnd().eq(current.getEnd())) {
                timespans[i] = timespans[i - 1];
            } else if (previous.getEnd().after(current.getStart())) {
                timespans[i] = previous.getEnd().after(current.getEnd()) ? timespans[i - 1] : new Timespan(previous.getEnd(), current.getEnd());
            }
            ++i;
        }
        return timespans;
    }

    public void clear() {
        this.fTimespans = new ITimespan[0];
        this.fCurrent = null;
        this.fCurrentIndex = -1;
        this.fForward = true;
    }

    @Override
    public void reset(IInstant earliestStart, boolean forward) {
        ITimespan current = null;
        int currentIndex = forward ? 0 : this.fTimespans.length - 1;
        while (!(forward ? currentIndex >= this.fTimespans.length : currentIndex < 0)) {
            current = this.fTimespans[currentIndex];
            if (forward) {
                if (current.getStart().afterEq(earliestStart) || current.getEnd().after(earliestStart)) break;
                ++currentIndex;
                continue;
            }
            if (current.getEnd().beforeEq(earliestStart) || current.getStart().before(earliestStart)) break;
            --currentIndex;
        }
        this.fCurrent = forward && currentIndex < this.fTimespans.length ? (earliestStart.after(current.getStart()) ? new Timespan(earliestStart, current.getEnd()) : current) : (!forward && currentIndex >= 0 ? (earliestStart.before(current.getEnd()) ? new Timespan(current.getStart(), earliestStart) : current) : null);
        this.fCurrentIndex = currentIndex;
        this.fForward = forward;
    }

    @Override
    public ITimespan current() {
        return this.fCurrent;
    }

    @Override
    public ITimespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.fForward && this.fCurrentIndex < this.fTimespans.length - 1 ? this.fTimespans[++this.fCurrentIndex] : (!this.fForward && this.fCurrentIndex > 0 ? this.fTimespans[--this.fCurrentIndex] : null);
        }
        return this.fCurrent;
    }

    public ITimespan[] getTimespans() {
        return this.fTimespans;
    }
}

