/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.shared.client.internal.duration.Instant;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class ExclusionIterator
extends DojoObject
implements ICalendarIterator {
    private static final IInstant LOWEST = Instant.time(1);
    private static final IInstant HIGHEST = Instant.time(JSMath.pow((double)2.0, (double)52.0));
    private ICalendarIterator fWrapped;
    private boolean fForward = true;
    private ITimespan fCurrent = null;

    public ExclusionIterator(ICalendarIterator wrapped) {
        this.fWrapped = wrapped;
    }

    @Override
    public void reset(IInstant earliestStart, boolean forward) {
        this.fForward = forward;
        this.fWrapped.reset(earliestStart, forward);
        ITimespan wrappedCurrent = this.fWrapped.current();
        IInstant begin = null;
        IInstant end = null;
        while (wrappedCurrent != null && wrappedCurrent.contains(earliestStart)) {
            begin = forward ? wrappedCurrent.getEnd() : wrappedCurrent.getStart();
            wrappedCurrent = this.fWrapped.next();
        }
        if (begin == null) {
            IInstant iInstant = begin = forward ? LOWEST : HIGHEST;
        }
        if (wrappedCurrent != null) {
            end = forward ? wrappedCurrent.getStart() : wrappedCurrent.getEnd();
        } else {
            IInstant iInstant = end = forward ? HIGHEST : LOWEST;
        }
        this.fCurrent = forward ? new Timespan(earliestStart.after(begin) ? earliestStart : begin, end) : new Timespan(end, earliestStart.before(begin) ? earliestStart : begin);
    }

    @Override
    public ITimespan current() {
        return this.fCurrent;
    }

    @Override
    public ITimespan next() {
        if (this.fCurrent != null) {
            if (this.fForward ? this.fCurrent.getEnd() != HIGHEST : this.fCurrent.getStart() != LOWEST) {
                ITimespan wrappedLast = this.fWrapped.current();
                ITimespan wrappedNext = this.fWrapped.next();
                this.fCurrent = this.fForward ? new Timespan(wrappedLast.getEnd(), wrappedNext != null ? wrappedNext.getStart() : HIGHEST) : new Timespan(wrappedNext != null ? wrappedNext.getEnd() : LOWEST, wrappedLast.getStart());
            } else {
                this.fCurrent = null;
            }
        }
        return this.fCurrent;
    }
}

