/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.shared.client.internal.duration.Timespan;
import com.ibm.team.apt.shared.client.internal.scheduler.time.Assignment;
import com.ibm.team.apt.shared.client.internal.scheduler.time.ICalendarIterator;

public class AssignmentIterator
extends DojoObject
implements ICalendarIterator {
    private ITimespan fCurrent;
    private ITimespan fRest;
    private int fCurrentAssignment;
    private int fLastAssignment;
    private Assignment[] fAssignments;
    private ICalendarIterator fWrapper;
    private boolean fForward;

    public AssignmentIterator(ICalendarIterator wrapper, Assignment[] assignments) {
        Assignment current;
        assert (wrapper != null && assignments != null && assignments.length > 0);
        this.fWrapper = wrapper;
        JSArrays.sort((Object[])assignments, (JSArrays.IComparator)new JSArrays.IComparator<Assignment>(){

            public int compare(Assignment left, Assignment right) {
                return left.getStart().compareTo(right.getStart());
            }
        });
        int i = 1;
        while (i < assignments.length) {
            Assignment previous = assignments[i - 1];
            current = assignments[i];
            if (previous.getStart().eq(current.getStart()) && previous.getEnd().eq(current.getEnd())) {
                assignments[i] = assignments[i - 1];
            } else if (previous.getEnd().after(current.getStart())) {
                assignments[i] = previous.getEnd().after(current.getEnd()) ? assignments[i - 1] : new Assignment(previous.getEnd(), current.getEnd(), current.getAssignment());
            }
            ++i;
        }
        this.fAssignments = new Assignment[0];
        JSArrays.push((Object[])this.fAssignments, (Object)((Object)assignments[0]));
        i = 1;
        while (i < assignments.length) {
            Assignment current2 = assignments[i];
            if (current2 != this.fAssignments[this.fAssignments.length - 1]) {
                JSArrays.push((Object[])this.fAssignments, (Object)((Object)current2));
            }
            ++i;
        }
        IInstant maxDate = assignments[0].getEnd();
        this.fLastAssignment = 0;
        int i2 = 0;
        while (i2 < this.fAssignments.length) {
            current = this.fAssignments[i2];
            if (maxDate.before(current.getEnd())) {
                maxDate = current.getEnd();
                this.fLastAssignment = i2;
            }
            ++i2;
        }
    }

    @Override
    public void reset(IInstant earliestStart, boolean forward) {
        int index;
        this.fForward = forward;
        this.fCurrentAssignment = index = this.findIndex(earliestStart, forward);
        this.fRest = null;
        Assignment assignment = this.fAssignments[index];
        IInstant resetInstant = earliestStart;
        if (forward) {
            if (earliestStart.before(assignment.getStart())) {
                resetInstant = assignment.getStart();
            }
        } else if (earliestStart.after(assignment.getEnd())) {
            resetInstant = assignment.getEnd();
        }
        this.fWrapper.reset(resetInstant, forward);
        this.fCurrent = this.fWrapper.current();
    }

    @Override
    public ITimespan current() {
        return this.fCurrent;
    }

    @Override
    public ITimespan next() {
        if (this.fCurrent != null) {
            this.fCurrent = this.computeNext();
        }
        return this.fCurrent;
    }

    public ITimespan nextForWorkTime() {
        ITimespan tempCurrent = this.next();
        if (!this.fAssignments[this.fLastAssignment].endsAfter(tempCurrent.getEnd())) {
            tempCurrent = null;
        }
        return tempCurrent;
    }

    public double getAssignmentForWorkTime() {
        double tempAssignment = this.getAssignment();
        if (!this.fAssignments[this.fLastAssignment].endsAfter(this.fCurrent.getEnd())) {
            tempAssignment = 0.0;
        }
        return tempAssignment;
    }

    public double getAssignment() {
        return this.fAssignments[this.fCurrentAssignment].getAssignment();
    }

    private ITimespan computeNext() {
        ITimespan next = this.fRest == null ? this.fWrapper.next() : this.fRest;
        Assignment assignment = this.fAssignments[this.fCurrentAssignment];
        do {
            if (assignment.containsTimespan(next) || this.fForward && this.fCurrentAssignment == this.fAssignments.length - 1 || !this.fForward && this.fCurrentAssignment == 0) {
                this.fRest = null;
                return next;
            }
            if (this.fForward) {
                if (next.getStart().afterEq(assignment.getEnd())) {
                    this.fCurrentAssignment = this.findIndex(next.getStart(), true);
                    assignment = this.fAssignments[this.fCurrentAssignment];
                    this.fWrapper.reset(assignment.getStart(), true);
                    next = this.fWrapper.current();
                    continue;
                }
                Timespan result = new Timespan(next.getStart(), assignment.getEnd());
                this.fRest = new Timespan(assignment.getEnd(), next.getEnd());
                return result;
            }
            if (next.getEnd().before(assignment.getStart())) {
                this.fCurrentAssignment = this.findIndex(next.getEnd(), false);
                assignment = this.fAssignments[this.fCurrentAssignment];
                this.fWrapper.reset(assignment.getEnd(), false);
                next = this.fWrapper.current();
                continue;
            }
            Timespan result = new Timespan(assignment.getStart(), next.getEnd());
            this.fRest = new Timespan(next.getStart(), assignment.getStart());
            return result;
        } while (this.fCurrentAssignment > 0 && this.fCurrentAssignment < this.fAssignments.length - 1);
        return next;
    }

    private int findIndex(IInstant when, boolean forward) {
        int low = 0;
        int high = this.fAssignments.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >> 1;
            Assignment assignment = this.fAssignments[mid];
            if (assignment.contains(when)) {
                return mid;
            }
            if (assignment.getStart().after(when)) {
                high = mid - 1;
                continue;
            }
            assert (assignment.getEnd().compareTo(when) == 0 || assignment.getEnd().before(when));
            low = mid + 1;
        }
        if (forward) {
            return JSMath.min((int)low, (int)(this.fAssignments.length - 1));
        }
        return JSMath.max((int)(low - 1), (int)0);
    }
}

