/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.scheduler.time;

import com.ibm.jdojo.dojo.date.Date;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSDate;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;

public class Assignment
extends DojoObject {
    private IInstant fStartDate;
    private IInstant fEndDate;
    private double fAssignment;

    public Assignment(IInstant startDate, IInstant endDate, double assignment) {
        assert (startDate != null && endDate != null && assignment >= 0.0 && assignment <= 1.0);
        this.fStartDate = startDate;
        this.fEndDate = endDate;
        this.fAssignment = assignment;
    }

    public IInstant getStart() {
        return this.fStartDate;
    }

    public IInstant getEnd() {
        return this.fEndDate;
    }

    public double getAssignment() {
        return this.fAssignment;
    }

    public boolean endsAfter(IInstant instant) {
        return this.fEndDate.after(instant) || this.isSameDay(this.fEndDate, instant);
    }

    public boolean startsBefore(IInstant instant) {
        return this.fStartDate.before(instant) || this.isSameDay(this.fStartDate, instant);
    }

    public boolean contains(IInstant instant) {
        return this.endsAfter(instant) && this.startsBefore(instant);
    }

    public boolean containsTimespan(ITimespan timespan) {
        return this.endsAfter(timespan.getEnd()) && this.startsBefore(timespan.getStart());
    }

    private boolean isSameDay(IInstant a, IInstant b) {
        return Date.compare((JSDate)new JSDate(a.getTime()), (JSDate)new JSDate(b.getTime()), (String)"date") == 0;
    }
}

