/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider;

public class StoryPointProgressLabelProvider
extends AbstractProgressLabelProvider
implements IProgressLabelProvider {
    private String __complexityUnit;
    private String __complexityLabel;

    public StoryPointProgressLabelProvider(AbstractProgressLabelProvider.LabelProviderOptions options) {
        super(options);
        if (options != null) {
            this.__complexityLabel = options.getParameter.getParameter("complexityLabel");
            this.__complexityUnit = options.getParameter.getParameter("complexityUnit");
        }
    }

    private boolean hasUnitsConfigured() {
        return this.__complexityUnit != null && this.__complexityLabel != null;
    }

    @Override
    public IProgressInformation.Unit getSizingUnit() {
        return IProgressInformation.Unit.COMPLEXITY;
    }

    public String getMessage(IProgressInformation element) {
        if (this.hasUnitsConfigured()) {
            if (element == null) {
                return "Computing...";
            }
            if (element.getCount() == 0) {
                return "No Work";
            }
            if (element.getEstimatedCount(IProgressInformation.Unit.COMPLEXITY) == 0 && element.getOpenCount() > 0) {
                return "No Work Estimated";
            }
            return null;
        }
        return "Complexity Attribute Not Defined";
    }

    public String getProgressText(IProgressInformation element) {
        String result = JSStrings.substitute((String)"${0}/${1} ${2}", (Object[])new Object[]{element.getStepsDone(IProgressInformation.Unit.COMPLEXITY), element.getSteps(IProgressInformation.Unit.COMPLEXITY), this._getComplexityUnit()});
        if (this._showLabels) {
            result = JSStrings.substitute((String)"Progress: ${0}", (Object[])new Object[]{result});
        }
        return result;
    }

    public IProgressLabelProvider.IDescription[] getAllDescriptions(IProgressInformation element) {
        if (!this.hasUnitsConfigured()) {
            return null;
        }
        JSArray descriptions = new JSArray();
        AbstractProgressLabelProvider.Description description = this.getComplexityUnitsCompletedText(element);
        if (description != null) {
            descriptions.push((Object)description);
        }
        if ((description = this.getComplexityUnitsExpectedText(element)) != null) {
            descriptions.push((Object)description);
        }
        if (element.getSteps(IProgressInformation.Unit.TIME) != 0L) {
            description = this.getWorkCompletedText(element);
            if (description != null) {
                descriptions.push((Object)description);
            }
            if ((description = this.getWorkExpectedText(element)) != null) {
                descriptions.push((Object)description);
            }
        }
        if ((description = this.getItemsEstimatedText(element)) != null) {
            descriptions.push((Object)description);
        }
        if ((description = this.getItemsCompletedText(element)) != null) {
            descriptions.push((Object)description);
        }
        return (IProgressLabelProvider.IDescription[])descriptions.toArray();
    }

    public String getConfigurationMissingMessage() {
        if (!this.hasUnitsConfigured()) {
            JSArray lines = JSArray.create();
            lines.push((Object)"<span class=\"header\">Missing Configuration</span>");
            lines.push((Object)"Complexity Attribute is not defined. Open the <strong><!--INSERT(PROJECT_AREA_LINK)-->Project Area<!--INSERT_END--></strong> editor, select the <strong>Process Configuration</strong> tab, and navigate to <strong>Project Configuration &gt; Iteration Plan &gt; Work Item Complexity Attribute</strong> to select a work item attribute which stands for complexity.");
            return lines.join("<br />");
        }
        return null;
    }

    public String getTooltipText(IProgressInformation element) {
        if (this.hasUnitsConfigured()) {
            JSArray descriptions = new JSArray();
            descriptions.push((Object)this.getComplexityUnitsCompletedText(element));
            descriptions.push((Object)this.getComplexityUnitsExpectedText(element));
            if (element.getSteps(IProgressInformation.Unit.TIME) != 0L) {
                descriptions.push((Object)this.getWorkCompletedText(element));
                descriptions.push((Object)this.getWorkExpectedText(element));
            }
            descriptions.push((Object)this.getItemsEstimatedText(element));
            descriptions.push((Object)this.getItemsCompletedText(element));
            JSArray lines = JSArray.create();
            lines.push((Object)"<span class=\"header\">Progress Report</span>");
            this.renderDescriptionsAsTable((JSArray<IProgressLabelProvider.IDescription>)descriptions, (JSArray<String>)lines);
            return JSStrings.substitute((String)"<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", (Object)lines.join("\n"));
        }
        return this.getConfigurationMissingMessage();
    }

    public AbstractProgressLabelProvider.Description getComplexityUnitsCompletedText(IProgressInformation element) {
        AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
        description.label = JSStrings.substitute((String)"${0} done:", (Object[])new Object[]{this._getComplexityLabel()});
        description.value = JSStrings.substitute((String)"${0} of ${1}", (Object[])new Object[]{this._format(element.getStepsDone(IProgressInformation.Unit.COMPLEXITY)), this._format(element.getSteps(IProgressInformation.Unit.COMPLEXITY))});
        return description;
    }

    public AbstractProgressLabelProvider.Description getComplexityUnitsExpectedText(IProgressInformation element) {
        if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {
            double dir = this.getDeltaDirection(element);
            String deltaMessage = dir > 0.0 ? "Ahead by ${0} ${1}" : (dir < 0.0 ? "Behind by ${0} ${1}" : "On track");
            String delta = JSStrings.substitute((String)deltaMessage, (Object[])new Object[]{JSMath.abs((double)this._round(element.getStepsDoneDelta(IProgressInformation.Unit.COMPLEXITY), 2)), this._getComplexityUnit()});
            AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
            description.label = JSStrings.substitute((String)"Expected ${0}:", (Object[])new Object[]{this._getComplexityLabel()});
            description.value = JSStrings.substitute((String)"${0} (${1})", (Object[])new Object[]{JSMath.round((double)element.getStepsDoneExpected(IProgressInformation.Unit.COMPLEXITY)), delta});
            return description;
        }
        return null;
    }

    public AbstractProgressLabelProvider.Description getItemsEstimatedText(IProgressInformation element) {
        if (!element.isAllWorkDone()) {
            AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
            description.label = "Items estimated:";
            description.value = JSStrings.substitute((String)"${0}%", (Object[])new Object[]{JSMath.round((double)(element.getQualityOfPlanning(IProgressInformation.Unit.COMPLEXITY) * 100.0))});
            return description;
        }
        return null;
    }

    public AbstractProgressLabelProvider.Description getItemsCompletedText(IProgressInformation element) {
        AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
        description.label = "Items completed:";
        if (this.hasUnitsConfigured()) {
            description.value = !element.isAllWorkDone() ? JSStrings.substitute((String)"${0} out of ${1} (${2}%)", (Object[])new Object[]{element.getCloseCount(), element.getCount(), JSMath.round((double)(element.getClosedRatio() * 100.0))}) : JSStrings.substitute((String)"${0} out of ${1} (${2}%)", (Object[])new Object[]{"All", element.getCount(), 100});
        }
        return description;
    }

    public String getUnitsLabel(IProgressInformation.Unit unit) {
        if (this.hasUnitsConfigured()) {
            return this._getComplexityLabel();
        }
        return "Complexity Attribute is not defined. Open the <strong><!--INSERT(PROJECT_AREA_LINK)-->Project Area<!--INSERT_END--></strong> editor, select the <strong>Process Configuration</strong> tab, and navigate to <strong>Project Configuration &gt; Iteration Plan &gt; Work Item Complexity Attribute</strong> to select a work item attribute which stands for complexity.";
    }

    public String getUnitsShortLabel(IProgressInformation.Unit unit) {
        if (this.hasUnitsConfigured()) {
            return this._getComplexityUnit();
        }
        return "Complexity Attribute is not defined. Open the <strong><!--INSERT(PROJECT_AREA_LINK)-->Project Area<!--INSERT_END--></strong> editor, select the <strong>Process Configuration</strong> tab, and navigate to <strong>Project Configuration &gt; Iteration Plan &gt; Work Item Complexity Attribute</strong> to select a work item attribute which stands for complexity.";
    }

    private double _round(double d, int digits) {
        double fac = JSMath.pow((double)10.0, (double)digits);
        return (double)JSMath.round((double)(d * fac)) / fac;
    }

    protected String _getComplexityLabel() {
        return this.__complexityLabel != null ? this.__complexityLabel : "";
    }

    protected String _getComplexityUnit() {
        return this.__complexityUnit != null ? this.__complexityUnit : "";
    }
}

