/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.jdojo.util.NLS;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.api.common.workitem.WorkItemAttributeType;
import com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider;

public class ProgressLabelProvider2
extends AbstractProgressLabelProvider
implements IProgressLabelProvider {
    private static final String EMPTY = "";
    private final boolean fForTopLevelWorkItemType;
    private final String fComplexityLabel;
    private final String fComplexityUnit;
    private final String fComplexityType;

    public ProgressLabelProvider2(AbstractProgressLabelProvider.LabelProviderOptions options) {
        super(options);
        this.fForTopLevelWorkItemType = this.getParameterValue(options, "topLevelWorkItemType", String.valueOf(false)) == String.valueOf(true);
        this.fComplexityLabel = this.getParameterValue(options, "complexityLabel", EMPTY);
        this.fComplexityUnit = this.getParameterValue(options, "complexityUnit", EMPTY);
        this.fComplexityType = this.getParameterValue(options, "type", EMPTY);
    }

    private String getParameterValue(AbstractProgressLabelProvider.LabelProviderOptions option, String key, String defaultValue) {
        if (option == null) {
            return defaultValue;
        }
        String value = option.getParameter.getParameter(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public double getFillLevel(IProgressInformation element) {
        return ProgressLabelProvider2.avg(this._getFillLevelForUnit(IProgressInformation.Unit.COMPLEXITY, element), this._getFillLevelForUnit(IProgressInformation.Unit.TIME, element));
    }

    @Override
    public double[] getDoneRange(IProgressInformation element) {
        double[] rangeTime = this._getDoneRangeForUnit(IProgressInformation.Unit.TIME, element);
        if (!this.mentionComplexity(element)) {
            return rangeTime;
        }
        double[] rangeComplexity = this._getDoneRangeForUnit(IProgressInformation.Unit.COMPLEXITY, element);
        if (element.getStepsDone(IProgressInformation.Unit.TIME) == 0L && element.getStepsLeft(IProgressInformation.Unit.TIME) == 0L) {
            return new double[]{0.0, rangeComplexity[1]};
        }
        return new double[]{0.0, ProgressLabelProvider2.avg(rangeComplexity[1], rangeTime[1])};
    }

    @Override
    public double[] getProjectionRange(IProgressInformation element) {
        if (element == null || !element.isRealTimeSpecified()) {
            return new double[]{-1.0, -1.0};
        }
        double stepsProgress = this.mentionComplexity(element) ? element.getStepsProgress(IProgressInformation.Unit.COMPLEXITY) : element.getStepsProgress(IProgressInformation.Unit.TIME);
        double ratio = stepsProgress - element.getRealTimeProgress();
        if (ratio > 0.0) {
            return new double[]{stepsProgress - ratio, ratio};
        }
        return new double[]{stepsProgress, -ratio};
    }

    @Override
    public double getDeltaDirection(IProgressInformation element) {
        if (element == null || !element.isRealTimeSpecified()) {
            return 0.0;
        }
        return (this.mentionComplexity(element) ? element.getStepsProgress(IProgressInformation.Unit.COMPLEXITY) : element.getStepsProgress(IProgressInformation.Unit.TIME)) - element.getRealTimeProgress();
    }

    public String getMessage(IProgressInformation element) {
        if (element == null) {
            return EMPTY;
        }
        if (!this.hasUnitsConfigured()) {
            return "Complexity Attribute Not Defined";
        }
        if (element.getCount() == 0) {
            return "No Work";
        }
        if (element.getOpenCount() > 0 && element.getEstimatedCount(IProgressInformation.Unit.TIME) + element.getEstimatedCount(IProgressInformation.Unit.COMPLEXITY) == 0) {
            return "No Work Estimated";
        }
        return null;
    }

    @Override
    public String getQualityText(IProgressInformation element) {
        String result = "--";
        if (element != null && element.getCount() != 0 && !element.isAllWorkDone()) {
            int estimatedCountTime;
            int estimatedCountComplexity = element.getEstimatedCount(IProgressInformation.Unit.COMPLEXITY);
            double value = estimatedCountComplexity == 0 ^ (estimatedCountTime = element.getEstimatedCount(IProgressInformation.Unit.TIME)) == 0 ? (estimatedCountComplexity != 0 ? element.getQualityOfPlanning(IProgressInformation.Unit.COMPLEXITY) : element.getQualityOfPlanning(IProgressInformation.Unit.TIME)) * 100.0 : (element.getQualityOfPlanning(IProgressInformation.Unit.COMPLEXITY) + element.getQualityOfPlanning(IProgressInformation.Unit.TIME)) * 50.0;
            result = NLS.bind((String)"${0}%", (Object)JSMath.round((double)value), (Object[])new Object[0]);
        }
        if (this._showLabels) {
            result = NLS.bind((String)"Estimated: ${0}", (Object)result, (Object[])new Object[0]);
        }
        return result;
    }

    public String getProgressText(IProgressInformation element) {
        if (element == null) {
            return "--";
        }
        String complexityPart = null;
        String timePart = null;
        if (this.mentionComplexity(element)) {
            complexityPart = this.fComplexityType.equals(WorkItemAttributeType.DURATION.name()) ? NLS.bind((String)"${0}/${1} ${2}", (Object)this._toHours(element.getStepsDone(IProgressInformation.Unit.COMPLEXITY)), (Object[])new Object[]{this._toHours(element.getSteps(IProgressInformation.Unit.COMPLEXITY)), this.getUnitsShortLabel(IProgressInformation.Unit.COMPLEXITY)}) : NLS.bind((String)"${0}/${1} ${2}", (Object)element.getStepsDone(IProgressInformation.Unit.COMPLEXITY), (Object[])new Object[]{element.getSteps(IProgressInformation.Unit.COMPLEXITY), this.getUnitsShortLabel(IProgressInformation.Unit.COMPLEXITY)});
        }
        if (element.getSteps(IProgressInformation.Unit.TIME) > 0L) {
            timePart = NLS.bind((String)"${0}/${1} ${2}", (Object)this._toHours(element.getStepsDone(IProgressInformation.Unit.TIME)), (Object[])new Object[]{this._toHours(element.getSteps(IProgressInformation.Unit.TIME)), this.getUnitsShortLabel(IProgressInformation.Unit.TIME)});
        }
        if (complexityPart != null ^ timePart != null) {
            return complexityPart != null ? complexityPart : timePart;
        }
        if (complexityPart != null && timePart != null) {
            return NLS.bind((String)"${0} | ${1}", complexityPart, (Object[])new Object[]{timePart});
        }
        return "--";
    }

    public String getTooltipText(IProgressInformation element) {
        if (element == null) {
            return EMPTY;
        }
        JSArray lines = JSArray.create();
        lines.push((Object)NLS.bind((String)"<span class=\"header\">${0}</span>", (Object)"Progress Report", (Object[])new Object[0]));
        this.renderDescriptionsAsTable((JSArray<IProgressLabelProvider.IDescription>)new JSArray((Object[])this.getAllDescriptions(element)), (JSArray<String>)lines);
        return JSStrings.substitute((String)"<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", (Object)lines.join("\n"));
    }

    public IProgressLabelProvider.IDescription[] getAllDescriptions(IProgressInformation element) {
        JSArray result = new JSArray();
        if (element != null) {
            if (this.mentionComplexity(element)) {
                ProgressLabelProvider2.pushIfNotNull(result, this.getWorkProgressTextForUnit(IProgressInformation.Unit.COMPLEXITY, element));
                ProgressLabelProvider2.pushIfNotNull(result, this.getWorkExpectedTextForUnit(IProgressInformation.Unit.COMPLEXITY, element));
            }
            ProgressLabelProvider2.pushIfNotNull(result, this.getWorkProgressTextForUnit(IProgressInformation.Unit.TIME, element));
            ProgressLabelProvider2.pushIfNotNull(result, this.getWorkExpectedTextForUnit(IProgressInformation.Unit.TIME, element));
            if (this.mentionComplexity(element)) {
                ProgressLabelProvider2.pushIfNotNull(result, this.getQualityTextForUnit(IProgressInformation.Unit.COMPLEXITY, element));
            }
            ProgressLabelProvider2.pushIfNotNull(result, this.getQualityTextForUnit(IProgressInformation.Unit.TIME, element));
            AbstractProgressLabelProvider.Description desc = new AbstractProgressLabelProvider.Description();
            desc.label = "Items Completed:";
            boolean oldShowLabel = this._showLabels;
            this._showLabels = false;
            try {
                desc.value = NLS.bind((String)"${0} of ${1} (${2})", (Object)element.getCloseCount(), (Object[])new Object[]{element.getCount(), this.getOpenCloseText(element)});
            }
            finally {
                this._showLabels = oldShowLabel;
            }
            ProgressLabelProvider2.pushIfNotNull(result, desc);
        }
        return (IProgressLabelProvider.IDescription[])result.toArray();
    }

    @Override
    public String getOpenCloseText(IProgressInformation element) {
        String result = "--";
        if (element != null) {
            result = NLS.bind((String)"${0}%", (Object)JSMath.round((double)(element.getClosedRatio() * 100.0)), (Object[])new Object[0]);
        }
        if (this._showLabels) {
            result = NLS.bind((String)"Closed: ${0}", (Object)result, (Object[])new Object[0]);
        }
        return result;
    }

    public String getConfigurationMissingMessage() {
        if (!this.hasUnitsConfigured()) {
            JSArray lines = JSArray.create();
            lines.push((Object)JSStrings.substitute((String)"<span class=\"header\">${0}</span>", (Object)"Missing Configuration"));
            lines.push((Object)"Complexity Attribute is not defined. Open the <strong><!--INSERT(PROJECT_AREA_LINK)-->Project Area<!--INSERT_END--></strong> editor, select the <strong>Process Configuration</strong> tab, and navigate to <strong>Project Configuration &gt; Iteration Plan &gt; Work Item Complexity Attribute</strong> to select a work item attribute which stands for complexity.");
            return lines.join("<br />");
        }
        return null;
    }

    private boolean hasUnitsConfigured() {
        return this.fComplexityLabel != null && this.fComplexityUnit != null;
    }

    private boolean mentionComplexity(IProgressInformation element) {
        return this.fForTopLevelWorkItemType || element.getSteps(IProgressInformation.Unit.COMPLEXITY) > 0L;
    }

    protected AbstractProgressLabelProvider.Description getQualityTextForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        AbstractProgressLabelProvider.Description desc = new AbstractProgressLabelProvider.Description();
        desc.label = NLS.bind((String)"Items with '${0}':", (Object)this.getUnitsLabel(unit), (Object[])new Object[0]);
        desc.value = this._getQualityTextForUnit(unit, element);
        return desc;
    }

    protected AbstractProgressLabelProvider.Description getWorkProgressTextForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        AbstractProgressLabelProvider.Description desc = new AbstractProgressLabelProvider.Description();
        desc.label = NLS.bind((String)"${0} Done:", (Object)this.getUnitsLabel(unit), (Object[])new Object[0]);
        desc.value = this.fComplexityType.equals(WorkItemAttributeType.DURATION.name()) ? NLS.bind((String)"${0} of ${1} (${2}%)", (Object)this._toHours(element.getStepsDone(unit)), (Object[])new Object[]{this._toHours(element.getSteps(unit)), JSMath.round((double)(element.getStepsProgress(unit) * 100.0))}) : NLS.bind((String)"${0} of ${1} (${2}%)", (Object)this.formatByUnit(unit, element.getStepsDone(unit)), (Object[])new Object[]{this.formatByUnit(unit, element.getSteps(unit)), JSMath.round((double)(element.getStepsProgress(unit) * 100.0))});
        return desc;
    }

    protected AbstractProgressLabelProvider.Description getWorkExpectedTextForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        if (element == null || !element.isRealTimeSpecified()) {
            return null;
        }
        double dir = this._getDeltaDirectionForUnit(unit, element);
        String pattern = dir > 0.0 ? "Ahead by ${0}${1}" : (dir < 0.0 ? "Behind by ${0}${1}" : "On Time");
        AbstractProgressLabelProvider.Description desc = new AbstractProgressLabelProvider.Description();
        desc.label = NLS.bind((String)"Expected ${0}:", (Object)this.getUnitsLabel(unit), (Object[])new Object[0]);
        if (this.fComplexityType.equals(WorkItemAttributeType.DURATION.name())) {
            String message = NLS.bind((String)pattern, (Object)this._toHours(JSMath.abs((double)element.getStepsDoneDelta(unit))), (Object[])new Object[]{this.getUnitsShortLabel(unit)});
            desc.value = JSStrings.substitute((String)"${0} (${1})", (Object[])new Object[]{this._toHours(element.getStepsDoneExpected(unit)), message});
        } else {
            String message = NLS.bind((String)pattern, (Object)this.formatByUnit(unit, JSMath.round((double)JSMath.abs((double)element.getStepsDoneDelta(unit)))), (Object[])new Object[]{this.getUnitsShortLabel(unit)});
            desc.value = JSStrings.substitute((String)"${0} (${1})", (Object[])new Object[]{this.formatByUnit(unit, element.getStepsDoneExpected(unit)), message});
        }
        return desc;
    }

    private String formatByUnit(IProgressInformation.Unit unit, double value) {
        switch (unit) {
            case TIME: {
                return this._toHours(value);
            }
            case COMPLEXITY: {
                return this._format(value);
            }
        }
        return String.valueOf(value);
    }

    public String getUnitsLabel(IProgressInformation.Unit unit) {
        return unit == IProgressInformation.Unit.COMPLEXITY ? this.fComplexityLabel : "Hours";
    }

    public String getUnitsShortLabel(IProgressInformation.Unit unit) {
        return unit == IProgressInformation.Unit.COMPLEXITY ? this.fComplexityUnit : "hrs";
    }

    @Override
    public IProgressInformation.Unit getSizingUnit() {
        throw new RuntimeException("not supported");
    }

    private static <T> void pushIfNotNull(JSArray<T> array, T element) {
        if (element != null) {
            array.push(element);
        }
    }

    private static double avg(double ... values) {
        double result = 0.0;
        int i = 0;
        while (i < values.length) {
            result += values[i];
            ++i;
        }
        return result / (double)values.length;
    }
}

