/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.shared.client.internal.progress.AbstractProgressLabelProvider;

public class ProgressLabelProvider
extends AbstractProgressLabelProvider
implements IProgressLabelProvider {
    public static final String SIZE_UNIT_LABEL = "milliseconds";

    public ProgressLabelProvider(AbstractProgressLabelProvider.LabelProviderOptions options) {
        super(options);
    }

    @Override
    public IProgressInformation.Unit getSizingUnit() {
        return IProgressInformation.Unit.TIME;
    }

    public String getUnitsLabel(IProgressInformation.Unit unit) {
        return SIZE_UNIT_LABEL;
    }

    public String getUnitsShortLabel(IProgressInformation.Unit unit) {
        return "ms";
    }

    public String getMessage(IProgressInformation element) {
        if (element == null) {
            return "Computing...";
        }
        if (element.getCount() == 0) {
            return "No Work";
        }
        if (element.getEstimatedCount(IProgressInformation.Unit.TIME) == 0 && element.getOpenCount() > 0) {
            return "No Work Estimated";
        }
        return null;
    }

    public String getProgressText(IProgressInformation element) {
        String result = "";
        if (element != null && element.getCount() != 0) {
            double direction = this._getDeltaDirectionForUnit(IProgressInformation.Unit.TIME, element);
            result = String.valueOf(result) + this._toHours(element.getStepsDone(IProgressInformation.Unit.TIME));
            result = String.valueOf(result) + "/";
            result = String.valueOf(result) + this._toHours(element.getSteps(IProgressInformation.Unit.TIME));
            if (element.isRealTimeSpecified()) {
                result = String.valueOf(result) + " | ";
                result = String.valueOf(result) + "<span class=\"" + (direction > 0.0 ? "ahead" : (direction < 0.0 ? "behind" : "none")) + "\">";
                if (direction > 0.0) {
                    result = String.valueOf(result) + "+";
                }
                result = String.valueOf(result) + this._toHours(element.getStepsDoneDelta(IProgressInformation.Unit.TIME));
                result = String.valueOf(result) + "</span>";
            }
            result = String.valueOf(result) + " h";
        } else {
            result = String.valueOf(result) + "--";
        }
        if (this._showLabels) {
            result = JSStrings.substitute((String)"Progress: ${0}", (Object[])new Object[]{result});
        }
        return result;
    }

    public String getTooltipText(IProgressInformation element) {
        JSArray descriptions = new JSArray();
        descriptions.push((Object)this.getWorkCompletedText(element));
        descriptions.push((Object)this.getWorkExpectedText(element));
        descriptions.push((Object)this.getItemsEstimatedText(element));
        descriptions.push((Object)this.getItemsCompletedText(element));
        JSArray lines = JSArray.create();
        lines.push((Object)"<span class=\"header\">Progress Report</span>");
        this.renderDescriptionsAsTable((JSArray<IProgressLabelProvider.IDescription>)descriptions, (JSArray<String>)lines);
        return JSStrings.substitute((String)"<div class=\"com-ibm-team-apt-progressTooltip\">${0}</div>", (Object)lines.join("\n"));
    }

    public String getConfigurationMissingMessage() {
        return null;
    }

    public IProgressLabelProvider.IDescription[] getAllDescriptions(IProgressInformation element) {
        JSArray descriptions = new JSArray();
        AbstractProgressLabelProvider.Description description = this.getWorkCompletedText(element);
        if (description != null) {
            descriptions.push((Object)description);
        }
        if ((description = this.getWorkExpectedText(element)) != null) {
            descriptions.push((Object)description);
        }
        if ((description = this.getItemsEstimatedText(element)) != null) {
            descriptions.push((Object)description);
        }
        if ((description = this.getItemsCompletedText(element)) != null) {
            descriptions.push((Object)description);
        }
        return (IProgressLabelProvider.IDescription[])descriptions.toArray();
    }

    public AbstractProgressLabelProvider.Description getItemsEstimatedText(IProgressInformation element) {
        if (!element.isAllWorkDone()) {
            AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
            description.label = "Items estimated:";
            description.value = JSStrings.substitute((String)"${0}%", (Object[])new Object[]{JSMath.round((double)(element.getQualityOfPlanning(IProgressInformation.Unit.TIME) * 100.0))});
            return description;
        }
        return null;
    }

    public AbstractProgressLabelProvider.Description getItemsCompletedText(IProgressInformation element) {
        AbstractProgressLabelProvider.Description description = new AbstractProgressLabelProvider.Description();
        description.label = "Items completed:";
        description.value = !element.isAllWorkDone() ? JSStrings.substitute((String)"${0} out of ${1} (${2}%)", (Object[])new Object[]{element.getCloseCount(), element.getCount(), JSMath.round((double)(element.getClosedRatio() * 100.0))}) : JSStrings.substitute((String)"${0} out of ${1} (${2}%)", (Object[])new Object[]{"All", element.getCount(), 100});
        return description;
    }
}

