/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.JSConstants;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSMath;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressInformationDetailed;

public class ProgressInformation
extends DojoObject
implements IProgressInformationDetailed {
    private long[] fStepsDone = new long[2];
    private long[] fStepsLeft = new long[2];
    private long fRealTimeDone;
    private long fRealTimeLeft;
    private int fOpenCount = 0;
    private int fCloseCount = 0;
    private int[] fEstimatedCount = new int[2];
    private String[] fDescendantsItemIds = (String[])JSArrays.create();

    public ProgressInformation(long realTimeDone, long realTimeLeft) {
        if ((double)realTimeDone == (Double)JSConstants.UNDEFINED) {
            realTimeDone = -1L;
        }
        if ((double)realTimeLeft == (Double)JSConstants.UNDEFINED) {
            realTimeLeft = -1L;
        }
        this.fRealTimeDone = realTimeDone;
        this.fRealTimeLeft = realTimeLeft;
    }

    private int getIndex(IProgressInformation.Unit unit) {
        if (unit == IProgressInformation.Unit.COMPLEXITY) {
            return 1;
        }
        return 0;
    }

    public void deltaStepsDone(IProgressInformation.Unit unit, long delta) {
        int index = this.getIndex(unit);
        this.fStepsDone[index] = this.safeDelta(this.fStepsDone[index], delta);
    }

    public void deltaStepsLeft(IProgressInformation.Unit unit, long delta) {
        int index = this.getIndex(unit);
        this.fStepsLeft[index] = this.safeDelta(this.fStepsLeft[index], delta);
    }

    public void deltaRealTimeDone(long delta) {
        if (this.fRealTimeDone != delta) {
            this.fRealTimeDone = this.safeDelta(JSMath.max((long)0L, (long)this.fRealTimeDone), delta);
        }
    }

    public void deltaRealTimeLeft(long delta) {
        if (this.fRealTimeLeft != delta) {
            this.fRealTimeLeft = this.safeDelta(JSMath.max((long)0L, (long)this.fRealTimeLeft), delta);
        }
    }

    public void deltaOpenCount(int delta) {
        this.fOpenCount = (int)this.safeDelta(this.fOpenCount, delta);
    }

    public void deltaCloseCount(int delta) {
        this.fCloseCount = (int)this.safeDelta(this.fCloseCount, delta);
    }

    public void deltaEstimateCount(IProgressInformation.Unit unit, int delta) {
        int index = this.getIndex(unit);
        this.fEstimatedCount[index] = (int)this.safeDelta(this.fEstimatedCount[index], delta);
    }

    private long safeDelta(long value, long delta) {
        return JSMath.max((long)0L, (long)(value + delta));
    }

    public boolean isAllWorkDone() {
        return this.fCloseCount > 0 && this.fOpenCount == 0;
    }

    public boolean isRealTimeSpecified() {
        return this.fRealTimeDone != -1L || this.fRealTimeLeft != -1L;
    }

    public long getStepsLeft(IProgressInformation.Unit unit) {
        return this.fStepsLeft[this.getIndex(unit)];
    }

    public long getStepsDone(IProgressInformation.Unit unit) {
        return this.fStepsDone[this.getIndex(unit)];
    }

    public long getSteps(IProgressInformation.Unit unit) {
        int index = this.getIndex(unit);
        return this.fStepsDone[index] + this.fStepsLeft[index];
    }

    public long getRealTimeDone() {
        return this.fRealTimeDone;
    }

    public long getRealTimeLeft() {
        return this.fRealTimeLeft;
    }

    public long getRealTime() {
        return this.fRealTimeDone + this.fRealTimeLeft;
    }

    public int getOpenCount() {
        return this.fOpenCount;
    }

    public int getCloseCount() {
        return this.fCloseCount;
    }

    public int getCount() {
        return this.fOpenCount + this.fCloseCount;
    }

    public int getEstimatedCount(IProgressInformation.Unit unit) {
        return this.fEstimatedCount[this.getIndex(unit)];
    }

    public double getStepsDoneExpected(IProgressInformation.Unit unit) {
        return (double)this.getSteps(unit) * this.getRealTimeProgress();
    }

    public double getStepsDoneDelta(IProgressInformation.Unit unit) {
        long stepsDone = this.getStepsDone(unit);
        long stepsLeft = this.getStepsLeft(unit);
        return (double)stepsDone - (double)(stepsDone + stepsLeft) * this.getRealTimeProgress();
    }

    public double getStepsProgress(IProgressInformation.Unit unit) {
        long stepsLeft;
        long stepsDone = this.getStepsDone(unit);
        long divisor = stepsDone + (stepsLeft = this.getStepsLeft(unit));
        return divisor <= 0L ? 1L : stepsDone / divisor;
    }

    public double getRealTimeProgress() {
        long divisor = this.fRealTimeDone + this.fRealTimeLeft;
        return divisor <= 0L ? 0L : this.fRealTimeDone / divisor;
    }

    public double getClosedRatio() {
        if (this.getCount() == 0) {
            return 1.0;
        }
        return (double)this.fCloseCount / (double)this.getCount();
    }

    public double getQualityOfPlanning(IProgressInformation.Unit unit) {
        if (this.fOpenCount == 0) {
            return this.fCloseCount != 0 ? 1 : 0;
        }
        return (double)this.getEstimatedCount(unit) / (double)this.fOpenCount;
    }

    public String[] getDescendantsItemIds() {
        return this.fDescendantsItemIds;
    }

    public void addDescendantItemId(String descendantItemId) {
        JSArrays.push((Object[])this.fDescendantsItemIds, (Object)descendantItemId);
    }
}

