/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.team.apt.api.common.planning.IPlanDuration;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressItemAccessor;
import com.ibm.team.apt.shared.client.internal.progress.AbstractProgressComputer;

public class NewProgressComputer
extends AbstractProgressComputer {
    boolean fDelayedChildrenLoading;

    public NewProgressComputer(IProgressItemAccessor<Object> itemAccessor, IProgressInformation progressInformation) {
        super(itemAccessor, progressInformation);
    }

    public void setDelayedChildrenLoadingMode(boolean enableDelayedChildrenLoading) {
        this.fDelayedChildrenLoading = enableDelayedChildrenLoading;
    }

    @Override
    protected boolean _visit(Object element) {
        if (!this.fItemAccessor.isPlanItem(element)) {
            return false;
        }
        if (this.fItemAccessor.isAuxiliaryPlanItem(element)) {
            return this.hasUnloadedChildren(element);
        }
        if (!this.fItemAccessor.isPrimaryElement(element)) {
            return this.hasUnloadedChildren(element);
        }
        this.visitForInfo(element);
        return this.handleUnloadedChildren(element);
    }

    protected boolean handleUnloadedChildren(Object element) {
        return this.hasUnloadedChildren(element) && this.updateProgressInfo(this.fItemAccessor.getProgressInformation(element));
    }

    public boolean updateProgressInfo(IProgressInformation progressInformation) {
        if (progressInformation != null) {
            this.fProgressInformation.deltaOpenCount(progressInformation.getOpenCount());
            this.fProgressInformation.deltaCloseCount(progressInformation.getCloseCount());
            this.fProgressInformation.deltaStepsDone(IProgressInformation.Unit.TIME, progressInformation.getStepsDone(IProgressInformation.Unit.TIME));
            this.fProgressInformation.deltaStepsLeft(IProgressInformation.Unit.TIME, progressInformation.getStepsLeft(IProgressInformation.Unit.TIME));
            this.fProgressInformation.deltaEstimateCount(IProgressInformation.Unit.TIME, progressInformation.getEstimatedCount(IProgressInformation.Unit.TIME));
            this.fProgressInformation.deltaStepsDone(IProgressInformation.Unit.COMPLEXITY, progressInformation.getStepsDone(IProgressInformation.Unit.COMPLEXITY));
            this.fProgressInformation.deltaStepsLeft(IProgressInformation.Unit.COMPLEXITY, progressInformation.getStepsLeft(IProgressInformation.Unit.COMPLEXITY));
            this.fProgressInformation.deltaEstimateCount(IProgressInformation.Unit.COMPLEXITY, progressInformation.getEstimatedCount(IProgressInformation.Unit.COMPLEXITY));
            return true;
        }
        return false;
    }

    protected boolean hasUnloadedChildren(Object element) {
        return this.fDelayedChildrenLoading && this.fItemAccessor.hasUnloadedChildren(element);
    }

    protected void visitForInfo(Object element) {
        if (this.fItemAccessor.isResolved(element)) {
            this.fProgressInformation.deltaCloseCount(1);
        } else {
            this.fProgressInformation.deltaOpenCount(1);
        }
        this.visitForTime(element);
        this.visitForComplexity(element);
    }

    private void visitForTime(Object element) {
        boolean isTopLevelItem = this.fItemAccessor.isTopLevelPlanItem(element);
        IPlanDuration planDuration = this.fItemAccessor.getDuration(element);
        if (planDuration != null) {
            if (this.fItemAccessor.isResolved(element)) {
                if (!isTopLevelItem) {
                    this.fProgressInformation.deltaStepsDone(IProgressInformation.Unit.TIME, planDuration.getMilliseconds());
                }
            } else {
                if (!isTopLevelItem) {
                    this.fProgressInformation.deltaStepsLeft(IProgressInformation.Unit.TIME, planDuration.getMilliseconds());
                    this.fProgressInformation.deltaStepsDone(IProgressInformation.Unit.TIME, planDuration.getTimeSpent().getMilliseconds());
                }
                if (planDuration.isSpecified() || isTopLevelItem) {
                    this.fProgressInformation.deltaEstimateCount(IProgressInformation.Unit.TIME, 1);
                }
            }
        }
    }

    private void visitForComplexity(Object element) {
        boolean isTopLevelItem = this.fItemAccessor.isTopLevelPlanItem(element);
        long storyPts = this.fItemAccessor.getComplexity(element);
        if (this.fItemAccessor.isResolved(element)) {
            if (isTopLevelItem) {
                this.fProgressInformation.deltaStepsDone(IProgressInformation.Unit.COMPLEXITY, storyPts);
            }
        } else {
            if (isTopLevelItem) {
                this.fProgressInformation.deltaStepsLeft(IProgressInformation.Unit.COMPLEXITY, storyPts);
            }
            if (!isTopLevelItem || storyPts > 0L) {
                this.fProgressInformation.deltaEstimateCount(IProgressInformation.Unit.COMPLEXITY, 1);
            }
        }
    }
}

