/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.progress;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.IJSFunction;
import com.ibm.jdojo.lang.annotations.Inline;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojo.util.JSStrings;
import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;

public abstract class AbstractProgressLabelProvider
extends DojoObject
implements IProgressLabelProvider {
    protected boolean _showLabels = true;

    public AbstractProgressLabelProvider(LabelProviderOptions options) {
        if (options != null) {
            this._showLabels = "true".equals(String.valueOf(options.getParameter.getParameter("showLabels")).toLowerCase());
        }
    }

    public String getOpenCloseText(IProgressInformation element) {
        String result = null;
        result = element != null && !element.isAllWorkDone() ? JSStrings.substitute((String)"${0}%", (Object[])new Object[]{JSMath.round((double)(element.getClosedRatio() * 100.0))}) : "Done";
        if (this._showLabels) {
            result = JSStrings.substitute((String)"Closed: ${0}", (Object[])new String[]{result});
        }
        return result;
    }

    public abstract IProgressInformation.Unit getSizingUnit();

    public double getFillLevel(IProgressInformation element) {
        return this._getFillLevelForUnit(this.getSizingUnit(), element);
    }

    public double[] getDoneRange(IProgressInformation element) {
        return this._getDoneRangeForUnit(this.getSizingUnit(), element);
    }

    public double[] getProjectionRange(IProgressInformation element) {
        return this._getProjectionRangeForUnit(this.getSizingUnit(), element);
    }

    public double getDeltaDirection(IProgressInformation element) {
        return this._getDeltaDirectionForUnit(this.getSizingUnit(), element);
    }

    public String getQualityText(IProgressInformation element) {
        return this._getQualityTextForUnit(this.getSizingUnit(), element);
    }

    protected double[] _getDoneRangeForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        if (element == null) {
            return new double[]{0.0, 0.0};
        }
        double stepsProgress = element.getStepsProgress(unit);
        return new double[]{0.0, stepsProgress < 1.0 ? stepsProgress - this.__aheadRange(unit, element) : stepsProgress};
    }

    protected double _getFillLevelForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        return element != null ? element.getQualityOfPlanning(unit) : 0.0;
    }

    protected double[] _getProjectionRangeForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        if (element != null && element.isRealTimeSpecified()) {
            double ratio = element.getStepsProgress(unit) - element.getRealTimeProgress();
            if (ratio > 0.0) {
                return new double[]{element.getStepsProgress(unit) - this.__aheadRange(unit, element), ratio};
            }
            return new double[]{element.getStepsProgress(unit), -ratio};
        }
        return new double[]{-1.0, -1.0};
    }

    protected double _getDeltaDirectionForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        return element != null && element.isRealTimeSpecified() ? element.getStepsProgress(unit) - element.getRealTimeProgress() : 0.0;
    }

    protected String _getQualityTextForUnit(IProgressInformation.Unit unit, IProgressInformation element) {
        String result = null;
        result = element != null && element.getCount() != 0 && !element.isAllWorkDone() ? JSStrings.substitute((String)"${0}%", (Object[])new Object[]{JSMath.round((double)(element.getQualityOfPlanning(unit) * 100.0))}) : "--";
        if (this._showLabels) {
            result = JSStrings.substitute((String)"Estimated: ${0}", (Object[])new String[]{result});
        }
        return result;
    }

    private double __aheadRange(IProgressInformation.Unit unit, IProgressInformation element) {
        if (element != null && element.isRealTimeSpecified()) {
            double ratio = element.getStepsProgress(unit) - element.getRealTimeProgress();
            return JSMath.max((double)0.0, (double)ratio);
        }
        return 0.0;
    }

    @Inline(value="dojo.number.format(${value})", requires={"dojo.number"})
    protected native String _format(double var1);

    protected String _absString(String value) {
        if (value.charAt(0) == '-') {
            return value.substring(1);
        }
        return value;
    }

    protected boolean _hasWork(IProgressInformation element) {
        return element.getCount() > 0;
    }

    protected boolean _hasEstimatedWork(IProgressInformation.Unit unit, IProgressInformation element) {
        return this._hasWork(element) && element.getEstimatedCount(unit) > 0;
    }

    public Description getWorkCompletedText(IProgressInformation element) {
        Description description = new Description();
        description.label = "Work hours done:";
        description.value = JSStrings.substitute((String)"${0} of ${1}", (Object[])new Object[]{this._toHours(element.getStepsDone(IProgressInformation.Unit.TIME)), this._toHours(element.getSteps(IProgressInformation.Unit.TIME))});
        return description;
    }

    public Description getWorkExpectedText(IProgressInformation element) {
        if (element.isRealTimeSpecified() && !element.isAllWorkDone()) {
            double dir = this._getDeltaDirectionForUnit(IProgressInformation.Unit.TIME, element);
            String deltaMessage = dir > 0.0 ? "Ahead by ${0} hrs" : (dir < 0.0 ? "Behind by ${0} hrs" : "On time");
            String delta = JSStrings.substitute((String)deltaMessage, (Object[])new Object[]{this._toHours(JSMath.abs((double)element.getStepsDoneDelta(IProgressInformation.Unit.TIME)))});
            Description description = new Description();
            description.label = "Expected work hours:";
            description.value = JSStrings.substitute((String)"${0} (${1})", (Object[])new Object[]{this._toHours(element.getStepsDoneExpected(IProgressInformation.Unit.TIME)), delta});
            return description;
        }
        return null;
    }

    protected String _toHours(double value) {
        double n = 2.0;
        double fac = JSMath.pow((double)10.0, (double)n);
        boolean neg = value < 0.0;
        value = JSMath.abs((double)value);
        double result = (double)JSMath.round((double)(value / 3600000.0 * fac)) / fac;
        double fraction = result - JSMath.floor((double)result);
        result -= fraction;
        if (fraction <= 0.125) {
            fraction = 0.0;
        } else if (fraction > 0.125 && fraction <= 0.25) {
            fraction = 0.25;
        } else if (fraction > 0.25 && fraction <= 0.5) {
            fraction = 0.5;
        } else if (fraction > 0.5 && fraction <= 0.75) {
            fraction = 0.75;
        } else if (fraction > 0.75) {
            fraction = 1.0;
        }
        return this._format((result + fraction) * (double)(neg ? -1 : 1));
    }

    protected void renderDescriptionsAsTable(JSArray<IProgressLabelProvider.IDescription> descriptions, JSArray<String> lines) {
        lines.push((Object)"<table border=\"0\">");
        int i = 0;
        while (i < descriptions.length) {
            IProgressLabelProvider.IDescription desc = (IProgressLabelProvider.IDescription)descriptions.get(i);
            if (desc != null) {
                lines.push((Object)JSStrings.substitute((String)"<tr><td class=\"label\">${0}</td><td class=\"value\">${1}</td></tr>", (Object[])new Object[]{desc.getLabel(), desc.getValue()}));
            }
            ++i;
        }
        lines.push((Object)"</table>");
    }

    public static class Description
    extends DojoObject
    implements IProgressLabelProvider.IDescription {
        public String label;
        public String value;

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static interface IParamaterProvider
    extends IJSFunction {
        public String getParameter(String var1);
    }

    public static class LabelProviderOptions {
        IParamaterProvider getParameter;

        public LabelProviderOptions(IParamaterProvider getParameter) {
        }
    }
}

