/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.model.attributes;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Undefined;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanElementDelta;
import com.ibm.team.apt.api.client.IPlanModel;
import com.ibm.team.apt.api.client.IPlanModelDeltaBuilder;
import com.ibm.team.apt.api.client.IPlanModificationRunnable;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IPlanningAttributeDelta;
import com.ibm.team.apt.api.client.IPlanningAttributeDependent;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.client.IPlanningAttributeListener;
import com.ibm.team.apt.api.client.internal.IFuture;
import com.ibm.team.apt.api.client.internal.IPlanContext;
import com.ibm.team.apt.api.client.internal.IPlanningClient;
import com.ibm.team.apt.api.client.internal.PlanningAttributeIdentifierImpl;
import com.ibm.team.apt.api.client.util.Flag;
import com.ibm.team.apt.api.common.planning.IPlanningAttributeDescription;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.api.common.workitem.IEnumerationElement;
import com.ibm.team.apt.shared.client.internal.SequenceValue;
import com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute;

public class RankingAttribute
extends SharedPlanningAttribute<Value>
implements IPlanningAttributeDependent,
IPlanningAttributeListener {
    private static final String SEQUENCE_ATTRIBUTE_LEGACYSCOPE = "__tpZgxeHEd6ry8lWYPBHvQ";
    private IPlanningAttribute<?> fSequenceAttribute = null;
    private IPlanningAttributeIdentifier fSequenceAttributeId = null;
    private IPlanningAttribute<?> fEnumerationAttribute = null;
    private IPlanningAttributeIdentifier fEnumerationAttributeId = null;
    private int fDirection;
    private static final String PARAM_ATTR = "attribute";
    private static final String PARAM_REVERSE = "reverse";

    public RankingAttribute(IPlanningAttributeDescription description, IPlanningClient planningClient, IPlanContext planContext) {
        super(description, planningClient, planContext);
        String enumerationAttributeId = description.getParameter(PARAM_ATTR);
        int direction = -1;
        if (description.getParameter(PARAM_REVERSE) != null || String.valueOf(description.getParameter(PARAM_REVERSE)).toLowerCase() == "false") {
            direction = -1;
        }
        this.fDirection = direction;
        this.fSequenceAttributeId = new PlanningAttributeIdentifierImpl(String.valueOf(enumerationAttributeId) + "." + "_pm7NmRYUEd6L1tNIGdz5qQ");
        this.fEnumerationAttributeId = new PlanningAttributeIdentifierImpl(enumerationAttributeId);
    }

    public Value getUnranked(Value source) {
        return this.createRank(source.getEnumerationValue(), SequenceValue.NEW);
    }

    public Value calculateRank(Value predecessor, Value successor, Value source) {
        SequenceValue successorSeq;
        IEnumerationElement sourceEnum = source.getEnumerationValue();
        if (predecessor == null && successor == null) {
            return this.createRank(sourceEnum, SequenceValue.INITIAL);
        }
        IEnumerationElement predecessorEnum = predecessor != null ? predecessor.getEnumerationValue() : null;
        SequenceValue predecessorSeq = predecessor != null ? predecessor.getSequenceValue() : null;
        IEnumerationElement successorEnum = successor != null ? successor.getEnumerationValue() : null;
        SequenceValue sequenceValue = successorSeq = successor != null ? successor.getSequenceValue() : null;
        if (predecessorSeq != null && predecessorSeq.isNew()) {
            predecessorSeq = null;
        }
        if (successorSeq != null && successorSeq.isNew()) {
            successorSeq = null;
        }
        IEnumerationElement targetEnum = null;
        SequenceValue targetSeq = null;
        if (predecessor != null && successor == null) {
            targetEnum = RankingAttribute.compareEnum(sourceEnum, predecessorEnum, this.fDirection) < 0 ? predecessorEnum : sourceEnum;
            targetSeq = RankingAttribute.calculateSeq(predecessorSeq, null);
        } else if (predecessor == null && successor != null) {
            targetEnum = RankingAttribute.compareEnum(sourceEnum, successorEnum, this.fDirection) < 0 ? sourceEnum : successorEnum;
            targetSeq = RankingAttribute.calculateSeq(null, successorSeq);
        } else if (predecessorEnum.getLiteralId() == successorEnum.getLiteralId()) {
            targetEnum = predecessorEnum;
            targetSeq = RankingAttribute.calculateSeq(predecessorSeq, successorSeq);
        } else if (predecessorEnum.getLiteralId() == sourceEnum.getLiteralId()) {
            targetEnum = predecessorEnum;
            targetSeq = RankingAttribute.calculateSeq(predecessorSeq, null);
        } else if (successorEnum.getLiteralId() == sourceEnum.getLiteralId()) {
            targetEnum = successorEnum;
            targetSeq = RankingAttribute.calculateSeq(null, successorSeq);
        } else {
            int predecessorToSource = RankingAttribute.compareEnum(predecessorEnum, sourceEnum, this.fDirection);
            int successorToSource = RankingAttribute.compareEnum(successorEnum, sourceEnum, this.fDirection);
            int predecessorToSuccessor = RankingAttribute.compareEnum(predecessorEnum, successorEnum, this.fDirection);
            if (predecessorToSource < 0 && successorToSource < 0) {
                if (predecessorToSuccessor < 0) {
                    targetEnum = predecessorEnum;
                    targetSeq = RankingAttribute.calculateSeq(predecessorSeq, null);
                } else {
                    targetEnum = predecessorEnum;
                    targetSeq = RankingAttribute.calculateSeq(null, successorSeq);
                }
            } else if (predecessorToSource > 0 && successorToSource > 0) {
                if (predecessorToSuccessor > 0) {
                    targetEnum = predecessorEnum;
                    targetSeq = RankingAttribute.calculateSeq(predecessorSeq, null);
                } else {
                    targetEnum = predecessorEnum;
                    targetSeq = RankingAttribute.calculateSeq(null, successorSeq);
                }
            }
        }
        if (targetEnum == null || targetSeq == null) {
            return source;
        }
        return this.createRank(targetEnum, targetSeq);
    }

    public IPlanningAttributeIdentifier[] getDependentAttributes() {
        return new IPlanningAttributeIdentifier[]{this.fSequenceAttributeId, this.fEnumerationAttributeId};
    }

    @Override
    public void initialize(IPlanModel planModel, IPlanElement[] planElements, IFuture<Void, Object> future, Flag ... flags) {
        this.fEnumerationAttribute = planModel.findAttribute(this.fEnumerationAttributeId);
        this.fSequenceAttribute = planModel.findAttribute(this.fSequenceAttributeId);
        IPlanElement[] iPlanElementArray = planElements;
        int n = planElements.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanElement planElement = iPlanElementArray[n2];
            IEnumerationElement enumValue = (IEnumerationElement)planElement.getAttributeValue(this.fEnumerationAttribute);
            SequenceValue seqValue = this.fromNativeValue((String)planElement.getAttributeValue(this.fSequenceAttribute), enumValue);
            planElement.define((IPlanningAttributeIdentifier)this, (Object)this.createRank(enumValue, seqValue));
            ++n2;
        }
        future.callback(null);
    }

    public void onChange(IPlanModelDeltaBuilder deltaBuilder, IPlanElementDelta planElementDelta) {
        SequenceValue newSeq;
        IPlanningAttributeDelta enumDelta = planElementDelta.getAttributeDelta(this.fEnumerationAttribute);
        IEnumerationElement newEnum = enumDelta != null ? (IEnumerationElement)enumDelta.getNewValue() : (IEnumerationElement)planElementDelta.getPlanElement().getAttributeValue(this.fEnumerationAttribute);
        IPlanningAttributeDelta seqDelta = planElementDelta.getAttributeDelta(this.fSequenceAttribute);
        if (seqDelta != null) {
            newSeq = this.fromNativeValue((String)seqDelta.getNewValue(), newEnum);
        } else {
            String rawSeq = (String)planElementDelta.getPlanElement().getAttributeValue(this.fSequenceAttribute);
            newSeq = this.fromNativeValue(rawSeq, newEnum);
        }
        Value newValue = this.createRank(newEnum, newSeq);
        Value oldValue = (Value)((Object)planElementDelta.getPlanElement().define((IPlanningAttributeIdentifier)this, (Object)newValue));
        deltaBuilder.changed(planElementDelta.getPlanElement(), (IPlanningAttributeIdentifier)this, (Object)oldValue, (Object)newValue);
    }

    public Object getAttributeType() {
        return PlanningAttributeType.RANKING;
    }

    @Override
    public void setValue(final IPlanElement receiver, final Value value) {
        RankingAttribute attributeId = this;
        receiver.getPlanModel().compoundChange((IPlanModificationRunnable)new IPlanModificationRunnable<Void, RuntimeException>((IPlanningAttributeIdentifier)attributeId){
            private final /* synthetic */ IPlanningAttributeIdentifier val$attributeId;
            {
                this.val$attributeId = iPlanningAttributeIdentifier;
            }

            public Void run(IPlanModelDeltaBuilder deltaBuilder) throws RuntimeException {
                if (value == null) {
                    IEnumerationElement enumerationValue = (IEnumerationElement)receiver.getAttributeValue((IPlanningAttributeIdentifier)RankingAttribute.this.fEnumerationAttribute);
                    receiver.setAttributeValue(this.val$attributeId, (Object)RankingAttribute.this.createRank(enumerationValue, SequenceValue.NEW));
                } else {
                    IEnumerationElement enumerationValue = value.getEnumerationValue();
                    receiver.setAttributeValue((IPlanningAttributeIdentifier)RankingAttribute.this.fEnumerationAttribute, (Object)enumerationValue);
                    receiver.setAttributeValue((IPlanningAttributeIdentifier)RankingAttribute.this.fSequenceAttribute, (Object)RankingAttribute.this.toNativeValue(value.getSequenceValue(), enumerationValue));
                }
                return null;
            }
        });
    }

    private SequenceValue fromNativeValue(String value, IEnumerationElement enumValue) {
        if (enumValue == null) {
            return SequenceValue.INITIAL;
        }
        String scope = enumValue.getLiteralId();
        if (value != null && value.indexOf(SEQUENCE_ATTRIBUTE_LEGACYSCOPE) == 0) {
            scope = SEQUENCE_ATTRIBUTE_LEGACYSCOPE;
        }
        return SequenceValue.FACTORY.valueOf(value, scope);
    }

    private String toNativeValue(SequenceValue value, IEnumerationElement enumValue) {
        return value.serializeSequenceValue(enumValue.getLiteralId());
    }

    private Value createRank(IEnumerationElement enumValue, SequenceValue seqValue) {
        return new Value(enumValue, seqValue, this.fDirection);
    }

    private static SequenceValue calculateSeq(SequenceValue predecessorSeq, SequenceValue successorSeq) {
        if (predecessorSeq != null) {
            if (successorSeq != null) {
                return SequenceValue.FACTORY.between(predecessorSeq, successorSeq);
            }
            return SequenceValue.FACTORY.successor(predecessorSeq);
        }
        if (successorSeq != null) {
            return SequenceValue.FACTORY.predecessor(successorSeq);
        }
        return SequenceValue.INITIAL;
    }

    private static int compareEnum(IEnumerationElement a, IEnumerationElement b, int direction) {
        if (a == null || b == null) {
            return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
        }
        return a.compareTo(b) * direction;
    }

    private static int compareSequence(SequenceValue a, SequenceValue b, int direction) {
        if (a == null || b == null) {
            return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
        }
        return a.compareTo(b) * direction;
    }

    public static class Value
    extends DojoObject {
        private IEnumerationElement fEnumerationValue = null;
        private SequenceValue fSequenceValue = null;
        private int fDirection = 1;
        public static final Value UNRANKED = new Value(null, SequenceValue.NEW, 1);

        public Value(IEnumerationElement enumerationValue, SequenceValue sequenceValue, int direction) {
            this.fEnumerationValue = enumerationValue;
            this.fSequenceValue = sequenceValue;
            this.fDirection = direction;
        }

        public boolean canRank() {
            return this.fEnumerationValue != Undefined.VALUE() && this.fEnumerationValue != null;
        }

        public boolean isSpecified() {
            return this.fEnumerationValue != null && this.fSequenceValue != null && !this.fSequenceValue.isNew();
        }

        public IEnumerationElement getEnumerationValue() {
            return this.fEnumerationValue;
        }

        public int compareEnumerationValueTo(Value other) {
            return RankingAttribute.compareEnum(this.fEnumerationValue, other.fEnumerationValue, this.fDirection);
        }

        public SequenceValue getSequenceValue() {
            return this.fSequenceValue;
        }

        public int compareTo(Value other) {
            if (!this.canRank() || !other.canRank()) {
                return (this.canRank() ? 0 : 1) - (other.canRank() ? 0 : 1);
            }
            int result = RankingAttribute.compareEnum(this.fEnumerationValue, other.fEnumerationValue, this.fDirection);
            if (result == 0) {
                result = RankingAttribute.compareSequence(this.fSequenceValue, other.fSequenceValue, 1);
            }
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            return this.compareTo((Value)((Object)other)) == 0;
        }
    }
}

