/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.model.attributes;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.IJSFunction;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMap;
import com.ibm.team.apt.api.client.IPlanElement;
import com.ibm.team.apt.api.client.IPlanElementDelta;
import com.ibm.team.apt.api.client.IPlanModel;
import com.ibm.team.apt.api.client.IPlanModelDeltaBuilder;
import com.ibm.team.apt.api.client.IPlanModificationRunnable;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.client.IPlanningAttributeDelta;
import com.ibm.team.apt.api.client.IPlanningAttributeDependent;
import com.ibm.team.apt.api.client.IPlanningAttributeIdentifier;
import com.ibm.team.apt.api.client.IPlanningAttributeListener;
import com.ibm.team.apt.api.client.internal.IExecutionEnvironment;
import com.ibm.team.apt.api.client.internal.IFuture;
import com.ibm.team.apt.api.client.internal.IPlanContext;
import com.ibm.team.apt.api.client.internal.IPlanningClient;
import com.ibm.team.apt.api.client.internal.PlanningAttributeIdentifierImpl;
import com.ibm.team.apt.api.client.util.Flag;
import com.ibm.team.apt.api.common.planning.IPlanningAttributeDescription;
import com.ibm.team.apt.api.common.planning.IProgressMonitor;
import com.ibm.team.apt.api.common.planning.PlanningAttributeType;
import com.ibm.team.apt.shared.client.internal.SequenceValue;
import com.ibm.team.apt.shared.client.internal.model.attributes.SharedPlanningAttribute;

public class NewRankingAttribute
extends SharedPlanningAttribute<Value>
implements IPlanningAttributeDependent,
IPlanningAttributeListener {
    private final String fSequenceAttributeLegacyScope;
    private static final int BATCHSIZE = 125;
    private IPlanningAttribute<?> fSequenceAttribute = null;
    private IPlanningAttributeIdentifier fSequenceAttributeId = null;
    private int fDirection;
    private static final String PARAM_REVERSE = "reverse";

    public NewRankingAttribute(IPlanningAttributeDescription description, IPlanningClient planningClient, IPlanContext planContext) {
        super(description, planningClient, planContext);
        int direction = -1;
        if (description.getParameter(PARAM_REVERSE) != null || String.valueOf(description.getParameter(PARAM_REVERSE)).toLowerCase() == "false") {
            direction = -1;
        }
        this.fDirection = direction;
        this.fSequenceAttributeLegacyScope = description.getId();
        this.fSequenceAttributeId = new PlanningAttributeIdentifierImpl(String.valueOf(description.getId()) + "." + "_pm7NmRYUEd6L1tNIGdz5qQ");
    }

    public void unRankIfRanked(IPlanElement element) {
        if (this.isRanked(element)) {
            this.unrank(element);
        }
    }

    public boolean isRanked(IPlanElement element) {
        Value value = (Value)((Object)this.getValue(element));
        return value != null && value.isSpecified();
    }

    public Value calculateRank(Value predecessor, Value successor) {
        SequenceValue successorSeq;
        if (predecessor == null && successor == null) {
            return this.createRank(SequenceValue.INITIAL);
        }
        SequenceValue predecessorSeq = predecessor != null ? predecessor.getSequenceValue() : null;
        SequenceValue sequenceValue = successorSeq = successor != null ? successor.getSequenceValue() : null;
        if (predecessorSeq != null && predecessorSeq.isNew()) {
            predecessorSeq = null;
        }
        if (successorSeq != null && successorSeq.isNew()) {
            successorSeq = null;
        }
        SequenceValue targetSeq = null;
        targetSeq = predecessorSeq != null && successorSeq == null ? this.calculateSeq(predecessorSeq, null) : (predecessorSeq == null && successorSeq != null ? this.calculateSeq(null, successorSeq) : this.calculateSeq(predecessorSeq, successorSeq));
        return this.createRank(targetSeq);
    }

    public void updateItemsInModel(JSMap<ElementWithRank> elementsWithRank, final IPlanModel planModel, final IDoneCallback done) {
        final JSArray<JSArray<ElementWithRank>> batches = this.getBatches(elementsWithRank);
        final int totalBatches = batches.length;
        this.fPlanningClient.getExecutionEnvironment().newWorkerWithProgress((IExecutionEnvironment.ICallableWithProgress)new IExecutionEnvironment.ICallableWithProgress<Integer>(){

            public Integer run(IProgressMonitor monitor) {
                JSArray elements;
                if (batches.length > 0 && batches.length == totalBatches) {
                    monitor.beginTask("Applying Rank", totalBatches);
                }
                if ((elements = (JSArray)batches.shift()) != null) {
                    NewRankingAttribute.this.setBatchAttributeValue((JSArray<ElementWithRank>)elements, planModel);
                    monitor.worked(1.0);
                }
                if (batches.length > 0) {
                    return 100;
                }
                monitor.done();
                if (done != null) {
                    done.done();
                }
                return -1;
            }
        }).schedule(100);
    }

    private JSArray<JSArray<ElementWithRank>> getBatches(JSMap<ElementWithRank> elementsWithRank) {
        JSArray batches = new JSArray();
        JSArray batch = new JSArray();
        ElementWithRank[] elementWithRankArray = (ElementWithRank[])elementsWithRank.values();
        int n = elementWithRankArray.length;
        int n2 = 0;
        while (n2 < n) {
            ElementWithRank item = elementWithRankArray[n2];
            batch.push((Object)item);
            if (batch.length == 125) {
                batches.push((Object)batch);
                batch = new JSArray();
            }
            ++n2;
        }
        if (batch.length > 0) {
            batches.push((Object)batch);
        }
        return batches;
    }

    protected void setBatchAttributeValue(final JSArray<ElementWithRank> elements, IPlanModel planModel) {
        NewRankingAttribute attributeId = this;
        planModel.compoundChange((IPlanModificationRunnable)new IPlanModificationRunnable<Void, RuntimeException>((IPlanningAttributeIdentifier)attributeId){
            private final /* synthetic */ IPlanningAttributeIdentifier val$attributeId;
            {
                this.val$attributeId = iPlanningAttributeIdentifier;
            }

            public Void run(IPlanModelDeltaBuilder deltaBuilder) throws RuntimeException {
                ElementWithRank[] elementWithRankArray = (ElementWithRank[])elements.toArray();
                int n = elementWithRankArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ElementWithRank elementObj = elementWithRankArray[n2];
                    IPlanElement element = elementObj.element;
                    Value newRank = elementObj.newRank;
                    if (newRank == null) {
                        element.setAttributeValue(this.val$attributeId, (Object)Value.UNRANKED);
                    } else {
                        element.setAttributeValue((IPlanningAttributeIdentifier)NewRankingAttribute.this.fSequenceAttribute, (Object)NewRankingAttribute.this.toNativeValue(newRank.getSequenceValue()));
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public IPlanningAttributeIdentifier[] getDependentAttributes() {
        return new IPlanningAttributeIdentifier[]{this.fSequenceAttributeId};
    }

    @Override
    public void initialize(IPlanModel planModel, IPlanElement[] planElements, IFuture<Void, Object> future, Flag ... flags) {
        this.fSequenceAttribute = planModel.findAttribute(this.fSequenceAttributeId);
        IPlanElement[] iPlanElementArray = planElements;
        int n = planElements.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanElement planElement = iPlanElementArray[n2];
            String nativeSequence = (String)planElement.getAttributeValue(this.fSequenceAttribute);
            SequenceValue sequenceValue = this.fromNativeValue(nativeSequence);
            planElement.define((IPlanningAttributeIdentifier)this, (Object)this.createRank(sequenceValue));
            ++n2;
        }
        future.callback(null);
    }

    public void onChange(IPlanModelDeltaBuilder deltaBuilder, IPlanElementDelta planElementDelta) {
        SequenceValue newSeq;
        IPlanningAttributeDelta seqDelta = planElementDelta.getAttributeDelta(this.fSequenceAttribute);
        if (seqDelta != null) {
            newSeq = this.fromNativeValue((String)seqDelta.getNewValue());
        } else {
            String rawSeq = (String)planElementDelta.getPlanElement().getAttributeValue(this.fSequenceAttribute);
            newSeq = this.fromNativeValue(rawSeq);
        }
        Value newValue = this.createRank(newSeq);
        Value oldValue = (Value)((Object)planElementDelta.getPlanElement().define((IPlanningAttributeIdentifier)this, (Object)newValue));
        deltaBuilder.changed(planElementDelta.getPlanElement(), (IPlanningAttributeIdentifier)this, (Object)oldValue, (Object)newValue);
    }

    public Object getAttributeType() {
        return PlanningAttributeType.NEW_RANKING;
    }

    @Override
    public void setValue(final IPlanElement receiver, final Value value) {
        NewRankingAttribute attributeId = this;
        receiver.getPlanModel().compoundChange((IPlanModificationRunnable)new IPlanModificationRunnable<Void, RuntimeException>((IPlanningAttributeIdentifier)attributeId){
            private final /* synthetic */ IPlanningAttributeIdentifier val$attributeId;
            {
                this.val$attributeId = iPlanningAttributeIdentifier;
            }

            public Void run(IPlanModelDeltaBuilder deltaBuilder) throws RuntimeException {
                if (value == null) {
                    receiver.setAttributeValue(this.val$attributeId, (Object)Value.UNRANKED);
                } else {
                    receiver.setAttributeValue((IPlanningAttributeIdentifier)NewRankingAttribute.this.fSequenceAttribute, (Object)NewRankingAttribute.this.toNativeValue(value.getSequenceValue()));
                }
                return null;
            }
        });
    }

    public IPlanningAttribute<?> getSequenceAttribute() {
        return this.fSequenceAttribute;
    }

    public Value setRankIfNecessary(Value predecessor, Value successor, IPlanElement element) {
        Value source = (Value)((Object)this.getValue(element));
        if (!source.fallsBetween(predecessor, successor)) {
            Value newRank = this.calculateRank(predecessor, successor);
            this.setValue(element, newRank);
            return newRank;
        }
        return null;
    }

    private void unrank(IPlanElement receiver) {
        this.setValue(receiver, Value.UNRANKED);
    }

    private SequenceValue fromNativeValue(String value) {
        if (value == null) {
            return SequenceValue.NEW;
        }
        return SequenceValue.FACTORY.valueOf(value, this.fSequenceAttributeLegacyScope);
    }

    public String toNativeValue(SequenceValue value) {
        return value.serializeSequenceValue(this.fSequenceAttributeLegacyScope);
    }

    private Value createRank(SequenceValue seqValue) {
        return new Value(seqValue);
    }

    public SequenceValue calculateSeq(SequenceValue predecessorSeq, SequenceValue successorSeq) {
        if (predecessorSeq != null) {
            if (successorSeq != null) {
                return SequenceValue.FACTORY.between(predecessorSeq, successorSeq);
            }
            return SequenceValue.FACTORY.successor(predecessorSeq);
        }
        if (successorSeq != null) {
            return SequenceValue.FACTORY.predecessor(successorSeq);
        }
        return SequenceValue.INITIAL;
    }

    private static int compareSequence(SequenceValue a, SequenceValue b, int direction) {
        if (a == null || b == null) {
            return ((a == null ? 1 : 0) - (b == null ? 1 : 0)) * direction;
        }
        return a.compareTo(b) * direction;
    }

    public static class ElementWithRank {
        public IPlanElement element;
        public Value newRank;

        public ElementWithRank(IPlanElement element, Value newRank) {
            this.element = element;
            this.newRank = newRank;
        }
    }

    public static interface IDoneCallback
    extends IJSFunction {
        public void done();
    }

    public static class Value
    extends DojoObject {
        public static final Value UNRANKED = new Value(SequenceValue.NEW);
        private SequenceValue fSequenceValue = null;

        public Value(SequenceValue sequenceValue) {
            this.fSequenceValue = sequenceValue;
        }

        public boolean canRank() {
            return true;
        }

        public boolean isSpecified() {
            return this.fSequenceValue != null && !this.fSequenceValue.isNew();
        }

        public SequenceValue getSequenceValue() {
            return this.fSequenceValue;
        }

        public int compareTo(Value other) {
            SequenceValue otherSeq = other == null ? null : other.fSequenceValue;
            return NewRankingAttribute.compareSequence(this.fSequenceValue, otherSeq, 1);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (((Object)((Object)this)).getClass() != other.getClass()) {
                return false;
            }
            return this.compareTo((Value)((Object)other)) == 0;
        }

        public boolean fallsBetween(Value predecessor, Value successor) {
            if (this.isSpecified()) {
                if (predecessor == null) {
                    return this.compareTo(successor) < 0;
                }
                if (successor == null) {
                    return this.compareTo(predecessor) > 0;
                }
                return this.compareTo(predecessor) > 0 && this.compareTo(successor) < 0;
            }
            return false;
        }
    }
}

