/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.model.attributes;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSBoolean;
import com.ibm.team.apt.api.client.IAttributeValueComparator;
import com.ibm.team.apt.api.client.IPlanItem;
import com.ibm.team.apt.api.client.IPlanningAttribute;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.api.common.IUIItem;
import com.ibm.team.apt.api.common.IUIItemHandle;
import com.ibm.team.apt.api.common.repository.IContributor;
import com.ibm.team.apt.api.common.repository.IReference;
import com.ibm.team.apt.api.common.repository.IReferences;
import com.ibm.team.apt.api.common.workitem.ICategory;
import com.ibm.team.apt.api.common.workitem.IDuration;
import com.ibm.team.apt.api.common.workitem.IEnumerationElement;
import com.ibm.team.apt.api.common.workitem.IWorkflowResolution;
import com.ibm.team.apt.shared.client.internal.model.attributes.AbstractValueComparator;
import com.ibm.team.workitem.shared.common.BigDecimal;

public class DefaultAttributeValueComparator
extends DojoObject {
    public static IAttributeValueComparator createComparator(IPlanningAttribute<?> attribute) {
        switch (attribute.getDescription().getAttributeType()) {
            case STRING: 
            case HTML: {
                return new StringComparator(attribute);
            }
            case INTEGER: 
            case FLOAT: {
                return new NumberComparator(attribute);
            }
            case DECIMAL: {
                return new DecimalComparator(attribute);
            }
            case BOOLEAN: {
                return new BooleanComparator(attribute);
            }
            case INSTANT: {
                return new InstantComparator(attribute);
            }
            case DURATION: {
                return new DurationComparator(attribute);
            }
            case TIMESPAN: {
                return new TimespanComparator(attribute);
            }
            case WORKITEM_TYPE: 
            case WORKFLOW_STATE: 
            case ITEM: {
                if (IPlanItem.OWNER.getId().equals(attribute.getId())) {
                    return new OwnerComparator(attribute);
                }
                if (IPlanItem.CATEGORY.getId().equals(attribute.getId())) {
                    return new CategoryComparator(attribute);
                }
                return new LabelComparator(attribute);
            }
            case ENUMERATION: {
                return new EnumerationComparator(attribute);
            }
            case REFERENCE: {
                return new ReferenceComparator(attribute);
            }
            case WORKFLOW_RESOLUTION: {
                return new WorkflowResolutionComparator(attribute);
            }
        }
        return null;
    }

    private static class BooleanComparator
    extends AbstractValueComparator<Boolean> {
        public BooleanComparator(IPlanningAttribute<Boolean> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(Boolean valueA, Boolean valueB) {
            if (valueA != valueB) {
                return valueA != false ? 1 : -1;
            }
            return 0;
        }
    }

    private static class CategoryComparator
    extends AbstractValueComparator<ICategory> {
        public CategoryComparator(IPlanningAttribute<ICategory> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(ICategory left, ICategory right) {
            int result = 0;
            String leftString = this.getStringComparisonValue(left);
            String rightString = this.getStringComparisonValue(right);
            if (leftString != null && rightString != null) {
                result = left.getCategoryId().compareTo(right.getCategoryId());
                if (result == 0 && JSBoolean.toBoolean((Object)left.getItemId()).booleanValue() && JSBoolean.toBoolean((Object)right.getItemId()).booleanValue()) {
                    result = left.getItemId().compareTo(right.getItemId());
                }
            } else {
                result = this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
            }
            return result;
        }

        private String getStringComparisonValue(ICategory category) {
            if (category instanceof ICategory) {
                return category.getLabel();
            }
            return null;
        }
    }

    private static class DecimalComparator
    extends AbstractValueComparator<BigDecimal> {
        public DecimalComparator(IPlanningAttribute<BigDecimal> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(BigDecimal valueA, BigDecimal valueB) {
            return valueA.compareTo(valueB);
        }
    }

    private static class DurationComparator
    extends AbstractValueComparator<IDuration> {
        public DurationComparator(IPlanningAttribute<IDuration> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IDuration valueA, IDuration valueB) {
            return valueA.compareTo(valueB);
        }
    }

    private static class EnumerationComparator
    extends AbstractValueComparator<IEnumerationElement> {
        public EnumerationComparator(IPlanningAttribute<IEnumerationElement> attribute) {
            super(attribute, false);
        }

        @Override
        public int compareValues(IEnumerationElement valueA, IEnumerationElement valueB) {
            return this.doCompare(valueA, valueB);
        }

        @Override
        protected int doCompare(IEnumerationElement valueA, IEnumerationElement valueB) {
            if (valueA == null && valueB != null) {
                return -1;
            }
            if (valueA != null) {
                return valueA.compareTo(valueB);
            }
            return 0;
        }
    }

    private static class InstantComparator
    extends AbstractValueComparator<IInstant> {
        public InstantComparator(IPlanningAttribute<IInstant> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IInstant valueA, IInstant valueB) {
            return valueA.compareTo(valueB);
        }
    }

    private static class LabelComparator
    extends AbstractValueComparator<IUIItem> {
        public LabelComparator(IPlanningAttribute<IUIItem> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IUIItem left, IUIItem right) {
            int result = 0;
            String leftString = this.getStringComparisonValue(left);
            String rightString = this.getStringComparisonValue(right);
            if (leftString != null && rightString != null) {
                result = leftString.compareTo(rightString);
                if (result == 0 && JSBoolean.toBoolean((Object)left.getItemId()).booleanValue() && JSBoolean.toBoolean((Object)right.getItemId()).booleanValue()) {
                    result = left.getItemId().compareTo(right.getItemId());
                }
            } else {
                result = this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
            }
            return result;
        }

        private String getStringComparisonValue(IUIItem uiItem) {
            if (uiItem instanceof IUIItem) {
                return uiItem.getLabel();
            }
            return null;
        }
    }

    private static class NumberComparator
    extends AbstractValueComparator<Number> {
        public NumberComparator(IPlanningAttribute<Number> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(Number valueA, Number valueB) {
            if ((Double)valueA < (Double)valueB) {
                return -1;
            }
            if ((Double)valueA > (Double)valueB) {
                return 1;
            }
            return 0;
        }
    }

    private static class OwnerComparator
    extends AbstractValueComparator<IContributor> {
        public OwnerComparator(IPlanningAttribute<IContributor> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IContributor left, IContributor right) {
            int result = 0;
            String leftString = this.getStringComparisonValue(left);
            String rightString = this.getStringComparisonValue(right);
            result = leftString != null && rightString != null ? leftString.compareTo(rightString) : this.compareStringValuesIgnoreCase(left, right, leftString, rightString);
            return result;
        }

        private String getStringComparisonValue(IContributor contributor) {
            if (contributor instanceof IContributor) {
                return contributor.getName();
            }
            return null;
        }
    }

    private static class ReferenceComparator
    extends AbstractValueComparator<IReferences> {
        public ReferenceComparator(IPlanningAttribute<IReferences> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IReferences valueA, IReferences valueB) {
            IReference[] refsB;
            IReference[] refsA = valueA.getReferences();
            if (refsA.length != (refsB = valueB.getReferences()).length) {
                return refsA.length > refsB.length ? 1 : -1;
            }
            int i = 0;
            while (i < refsB.length) {
                IReference refA = refsA[i];
                IReference refB = refsB[i];
                if (!refA.isEqual(refB)) {
                    return ReferenceComparator.compareValue(refA).compareTo(ReferenceComparator.compareValue(refB));
                }
                ++i;
            }
            return 0;
        }

        private static String compareValue(IReference reference) {
            String result = null;
            IUIItemHandle handle = reference.getItemHandle();
            if (handle != null) {
                result = handle.getHandleValue();
            }
            if (result == null) {
                result = reference.getUri();
            }
            if (result == null) {
                result = "";
            }
            return result;
        }
    }

    private static class StringComparator
    extends AbstractValueComparator<String> {
        public StringComparator(IPlanningAttribute<String> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(String valueA, String valueB) {
            return valueA.compareToIgnoreCase(valueB);
        }
    }

    private static class TimespanComparator
    extends AbstractValueComparator<ITimespan> {
        public TimespanComparator(IPlanningAttribute<ITimespan> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(ITimespan valueA, ITimespan valueB) {
            return valueA.compareTo(valueB);
        }
    }

    private static class WorkflowResolutionComparator
    extends AbstractValueComparator<IWorkflowResolution> {
        public WorkflowResolutionComparator(IPlanningAttribute<IWorkflowResolution> attribute) {
            super(attribute, false);
        }

        @Override
        protected int doCompare(IWorkflowResolution valueA, IWorkflowResolution valueB) {
            return valueA.getId().compareToIgnoreCase(valueB.getId());
        }
    }
}

