/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.shared.client.internal.duration;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.team.apt.api.common.IInstant;
import com.ibm.team.apt.api.common.ITimespan;
import com.ibm.team.apt.api.common.workitem.Duration;
import com.ibm.team.apt.api.common.workitem.IDuration;

public class Timespan
extends DojoObject
implements ITimespan {
    private final IInstant fStart;
    private final IInstant fEnd;
    private IDuration fDuration;

    public Timespan(IInstant start, IInstant end) {
        this.fStart = start;
        this.fEnd = end;
        assert (this.fStart.getTime() <= this.fEnd.getTime());
    }

    public IInstant getStart() {
        return this.fStart;
    }

    public IInstant getEnd() {
        return this.fEnd;
    }

    public IDuration getDuration() {
        if (this.fDuration == null) {
            this.fDuration = new Duration(this.fEnd.getTime() - this.fStart.getTime());
        }
        return this.fDuration;
    }

    public boolean contains(IInstant instant) {
        return this.fStart.beforeEq(instant) && this.fEnd.after(instant);
    }

    public ITimespan overlap(ITimespan other) {
        if (other == null) {
            return null;
        }
        IInstant otherStart = other.getStart();
        IInstant otherEnd = other.getEnd();
        if (this.fEnd.before(otherStart) || this.fStart.after(otherEnd)) {
            return null;
        }
        IInstant start = this.fStart.before(otherStart) ? otherStart : this.fStart;
        IInstant end = this.fEnd.before(otherEnd) ? this.fEnd : otherEnd;
        return new Timespan(start, end);
    }

    public int compareTo(ITimespan other) {
        return Timespan.__comparisonValue(this) - Timespan.__comparisonValue(other);
    }

    public boolean eq(ITimespan other) {
        return other != null && this.fStart.eq(other.getStart()) && this.fEnd.eq(other.getEnd());
    }

    public String toString() {
        return String.valueOf(this.fStart.toString()) + " - " + this.fEnd.toString();
    }

    private static int __comparisonValue(ITimespan timespan) {
        long start = timespan.getStart().getTime();
        long end = timespan.getEnd().getTime();
        return (int)((end - start) / 2L + start);
    }
}

